/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.utils.net;

import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class InetSocketAddresses {
    private InetSocketAddresses() {
    }

    public static InetSocketAddress forUaddrString(String uaddr) {
        int secondPort = uaddr.lastIndexOf(46);
        if (secondPort == -1) {
            throw new IllegalArgumentException("address " + uaddr + " doesn't match rfc5665");
        }
        int firstPort = uaddr.lastIndexOf(46, secondPort - 1);
        if (firstPort == -1) {
            throw new IllegalArgumentException("address " + uaddr + " doesn't match rfc5665");
        }
        InetAddress inetAddr = InetAddresses.forString((String)uaddr.substring(0, firstPort));
        int p1 = Integer.parseInt(uaddr.substring(firstPort + 1, secondPort));
        int p2 = Integer.parseInt(uaddr.substring(secondPort + 1));
        int port = (p1 << 8) + p2;
        return new InetSocketAddress(inetAddr, port);
    }

    public static InetSocketAddress inetAddressOf(String address) {
        HostAndPort hostAndPort = HostAndPort.fromString((String)address);
        return new InetSocketAddress(hostAndPort.getHostText(), hostAndPort.getPort());
    }

    private static String stripScopeId(String s) {
        int scope = s.indexOf(37);
        if (scope > 0) {
            return s.substring(0, scope);
        }
        return s;
    }

    public static String uaddrOf(InetSocketAddress socketAddress) {
        int port = socketAddress.getPort();
        int[] port_part = new int[]{(port & 0xFF00) >> 8, port & 0xFF};
        InetAddress address = socketAddress.getAddress();
        String s = address.getHostAddress();
        if (address instanceof Inet6Address) {
            s = InetSocketAddresses.stripScopeId(s);
        }
        return s + "." + port_part[0] + "." + port_part[1];
    }

    public static String uaddrOf(String host, int port) {
        return InetSocketAddresses.uaddrOf(new InetSocketAddress(host, port));
    }

    public static String tcpNetidOf(InetAddress address) {
        if (address instanceof Inet4Address) {
            return "tcp";
        }
        if (address instanceof Inet6Address) {
            return "tcp6";
        }
        throw new IllegalArgumentException("unsupported inet type: " + address.getClass().getName());
    }
}

