/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.gplazma;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.KAuthFile;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.PasswordCredential;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserAuthBase;
import org.dcache.auth.UserAuthRecord;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.UserPwdRecord;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.auth.gplazma.KpwdPrincipal;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaAccountPlugin;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.plugins.GPlazmaSessionPlugin;
import org.dcache.gplazma.util.Preconditions;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KpwdPlugin
implements GPlazmaAuthenticationPlugin,
GPlazmaMappingPlugin,
GPlazmaAccountPlugin,
GPlazmaSessionPlugin {
    private static Logger logger = LoggerFactory.getLogger(KpwdPlugin.class);
    private static final String KPWD = "gplazma.kpwd.file";
    private final File _kpwdFile;
    private long _cacheTime;
    private KAuthFile _cacheAuthFile;

    public KpwdPlugin(Properties properties) {
        String path = properties.getProperty(KPWD, null);
        com.google.common.base.Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"gplazma.kpwd.file argument must be specified");
        this._kpwdFile = new File(path);
    }

    KpwdPlugin(KAuthFile file) {
        this._cacheAuthFile = file;
        this._kpwdFile = null;
    }

    private synchronized KAuthFile getAuthFile() throws AuthenticationException {
        try {
            if (this._kpwdFile != null && this._kpwdFile.lastModified() >= this._cacheTime) {
                this._cacheAuthFile = new KAuthFile(this._kpwdFile.getPath());
                this._cacheTime = System.currentTimeMillis();
            }
            return this._cacheAuthFile;
        }
        catch (IOException e) {
            String msg = String.format("failed to read %s: %s", this._kpwdFile.getName(), e.getMessage());
            throw new AuthenticationException(msg, (Throwable)e);
        }
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        PasswordCredential password = (PasswordCredential)Iterables.getFirst((Iterable)Iterables.filter(privateCredentials, PasswordCredential.class), null);
        Preconditions.checkAuthentication((password != null ? 1 : 0) != 0, (String)"no username and password");
        String name = password.getUsername();
        UserPwdRecord entry = this.getAuthFile().getUserPwdRecord(name);
        Preconditions.checkAuthentication((entry != null ? 1 : 0) != 0, (String)(name + " is unknown"));
        Preconditions.checkAuthentication((entry.isAnonymous() || entry.isDisabled() || entry.passwordIsValid(String.valueOf(password.getPassword())) ? 1 : 0) != 0, (String)"wrong password");
        identifiedPrincipals.add(new KpwdPrincipal((UserAuthBase)entry));
        Preconditions.checkAuthentication((!entry.isDisabled() ? 1 : 0) != 0, (String)"account is disabled");
    }

    public void map(Set<Principal> principals) throws AuthenticationException {
        KpwdPrincipal kpwd = (KpwdPrincipal)Iterables.getFirst((Iterable)Iterables.filter(principals, KpwdPrincipal.class), null);
        if (kpwd == null) {
            UserAuthRecord authRecord;
            KAuthFile authFile = this.getAuthFile();
            String loginName = null;
            Principal principal = null;
            for (Principal p : principals) {
                if (p instanceof LoginNamePrincipal) {
                    Preconditions.checkAuthentication((loginName == null ? 1 : 0) != 0, (String)KpwdPlugin.errorMessage(principal, p));
                    loginName = p.getName();
                    continue;
                }
                if (p instanceof GlobusPrincipal) {
                    Preconditions.checkAuthentication((principal == null ? 1 : 0) != 0, (String)KpwdPlugin.errorMessage(principal, p));
                    principal = p;
                    continue;
                }
                if (p instanceof KerberosPrincipal) {
                    Preconditions.checkAuthentication((principal == null ? 1 : 0) != 0, (String)KpwdPlugin.errorMessage(principal, p));
                    principal = p;
                    continue;
                }
                if (!(p instanceof UserNamePrincipal)) continue;
                Preconditions.checkAuthentication((principal == null ? 1 : 0) != 0, (String)KpwdPlugin.errorMessage(principal, p));
                principal = p;
            }
            Preconditions.checkAuthentication((principal != null ? 1 : 0) != 0, (String)"no mappable principals");
            if (loginName == null) {
                loginName = authFile.getIdMapping(principal.getName());
                Preconditions.checkAuthentication((loginName != null ? 1 : 0) != 0, (String)"no login name");
            }
            Preconditions.checkAuthentication(((authRecord = authFile.getUserRecord(loginName)) != null ? 1 : 0) != 0, (String)("unknown login name: " + loginName));
            Preconditions.checkAuthentication((boolean)authRecord.hasSecureIdentity(principal.getName()), (String)("not allowed to login as " + loginName));
            authRecord.DN = principal.getName();
            kpwd = new KpwdPrincipal((UserAuthBase)authRecord);
        }
        principals.add(kpwd);
        Preconditions.checkAuthentication((!kpwd.isDisabled() ? 1 : 0) != 0, (String)"account disabled");
        principals.add((Principal)new UserNamePrincipal(kpwd.getName()));
        principals.add((Principal)new UidPrincipal(kpwd.getUid()));
        principals.add((Principal)new GidPrincipal(kpwd.getGid(), true));
    }

    private static String errorMessage(Principal principal1, Principal principal2) {
        String name2;
        if (principal1 == null || principal2 == null) {
            return "";
        }
        String name1 = KpwdPlugin.nameFor(principal1);
        if (name1.equals(name2 = KpwdPlugin.nameFor(principal2))) {
            return "multiple " + name2 + " principals found";
        }
        return name1 + " and " + name2 + " principals found";
    }

    private static String nameFor(Principal principal) {
        if (principal instanceof KerberosPrincipal) {
            return "Kerberos";
        }
        if (principal instanceof GlobusPrincipal) {
            return "X509";
        }
        return principal.getClass().getSimpleName();
    }

    public void account(Set<Principal> authorizedPrincipals) throws AuthenticationException {
        KpwdPrincipal kpwd = (KpwdPrincipal)Iterables.getFirst((Iterable)Iterables.filter(authorizedPrincipals, KpwdPrincipal.class), null);
        Preconditions.checkAuthentication((kpwd == null || !kpwd.isDisabled() ? 1 : 0) != 0, (String)"account disabled");
    }

    public void session(Set<Principal> authorizedPrincipals, Set<Object> attrib) throws AuthenticationException {
        KpwdPrincipal kpwd = (KpwdPrincipal)Iterables.getFirst((Iterable)Iterables.filter(authorizedPrincipals, KpwdPrincipal.class), null);
        Preconditions.checkAuthentication((kpwd != null ? 1 : 0) != 0, (String)"no record found");
        attrib.add(new HomeDirectory(kpwd.getHome()));
        attrib.add(new RootDirectory(kpwd.getRoot()));
        attrib.add(new ReadOnly(kpwd.isReadOnly()));
    }
}

