/*
 * Decompiled with CFR 0.152.
 */
package org.pcells.services.connection;

import java.io.Serializable;
import java.net.Socket;
import org.pcells.services.connection.DomainConnection;
import org.pcells.services.connection.DomainConnectionAdapter;
import org.pcells.services.connection.DomainConnectionListener;
import org.pcells.services.connection.DomainEventListener;

public class RawDomainConnection
extends DomainConnectionAdapter {
    private String _hostname;
    private int _portnumber;
    private Socket _socket;

    public RawDomainConnection(String hostname, int portnumber) {
        this._hostname = hostname;
        this._portnumber = portnumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void go() throws Exception {
        this._socket = new Socket(this._hostname, this._portnumber);
        this.setIoStreams(this._socket.getInputStream(), this._socket.getOutputStream());
        try {
            super.go();
        }
        finally {
            try {
                this._socket.close();
            }
            catch (Exception exception) {}
        }
    }

    public void test() {
        System.out.println("Starting test");
        new RunConnection();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage : <hostname> <portNumber>");
            System.exit(4);
        }
        String hostname = args[0];
        int portnumber = Integer.parseInt(args[1]);
        System.out.println("Creating new Raw...");
        RawDomainConnection connection = new RawDomainConnection(hostname, portnumber);
        System.out.println("Starting Test");
        connection.test();
    }

    private class RunConnection
    implements Runnable,
    DomainConnectionListener,
    DomainEventListener {
        public RunConnection() {
            System.out.println("class runConnection init");
            RawDomainConnection.this.addDomainEventListener(this);
            new Thread(this).start();
        }

        @Override
        public void run() {
            try {
                RawDomainConnection.this.go();
            }
            catch (Exception ee) {
                System.out.println("RunConnection got : " + ee);
                ee.printStackTrace();
            }
        }

        @Override
        public void domainAnswerArrived(Object obj, int id) {
            System.out.println("Answer : " + obj);
            if (id == 54) {
                try {
                    RawDomainConnection.this.sendObject((Serializable)((Object)"logoff"), this, 55);
                }
                catch (Exception ee) {
                    System.out.println("Exception in sendObject" + ee);
                }
            }
        }

        @Override
        public void connectionOpened(DomainConnection connection) {
            System.out.println("DomainConnection : connectionOpened");
            try {
                RawDomainConnection.this.sendObject("System", (Serializable)((Object)"ps -f"), this, 54);
            }
            catch (Exception ee) {
                System.out.println("Exception in sendObject" + ee);
            }
        }

        @Override
        public void connectionClosed(DomainConnection connection) {
            System.out.println("DomainConnection : connectionClosed");
        }

        @Override
        public void connectionOutOfBand(DomainConnection connection, Object subject) {
            System.out.println("DomainConnection : connectionOutOfBand");
        }
    }
}

