/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.logback;

import ch.qos.logback.classic.Level;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dmg.util.logback.LoggerName;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class FilterThresholds {
    private final FilterThresholds _parent;
    private final Set<String> _appenders = Sets.newHashSet();
    private final Map<LoggerName, Map<String, Level>> _rules = Maps.newHashMap();
    private final LoadingCache<LoggerName, Map<String, Level>> _effectiveMaps = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<LoggerName, Map<String, Level>>(){

        public Map<String, Level> load(LoggerName logger) {
            return FilterThresholds.this.computeEffectiveMap(logger);
        }
    });
    private final LoadingCache<LoggerName, Optional<Level>> _effectiveLevels = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<LoggerName, Optional<Level>>(){

        public Optional<Level> load(LoggerName logger) {
            try {
                Map map = (Map)FilterThresholds.this._effectiveMaps.get((Object)logger);
                return map.isEmpty() ? Optional.absent() : Optional.of(Collections.min(map.values(), LEVEL_ORDER));
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
        }
    });
    private static final Comparator<Level> LEVEL_ORDER = new Comparator<Level>(){

        @Override
        public int compare(Level o1, Level o2) {
            if (!o1.isGreaterOrEqual(o2)) {
                return -1;
            }
            if (!o2.isGreaterOrEqual(o1)) {
                return 1;
            }
            return 0;
        }
    };

    public FilterThresholds() {
        this(null);
    }

    public FilterThresholds(FilterThresholds parent) {
        this._parent = parent;
    }

    public synchronized void addAppender(String name) {
        Preconditions.checkNotNull((Object)name);
        this._appenders.add(name);
    }

    public synchronized Collection<String> getAppenders() {
        if (this._parent == null) {
            return Lists.newArrayList(this._appenders);
        }
        Collection<String> appenders = this._parent.getAppenders();
        appenders.addAll(this._appenders);
        return appenders;
    }

    public synchronized boolean hasAppender(String appender) {
        return this._appenders.contains(appender) || this._parent != null && this._parent.hasAppender(appender);
    }

    public synchronized Level get(LoggerName logger, String appender) {
        return this.getMap(logger).get(appender);
    }

    public synchronized void setThreshold(LoggerName logger, String appender, Level level) {
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull((Object)level);
        Preconditions.checkArgument((boolean)this.hasAppender(appender));
        HashMap map = this._rules.get(logger);
        if (map == null) {
            map = Maps.newHashMap();
            this._rules.put(logger, map);
        }
        map.put(appender, level);
        this.clearCache();
    }

    public synchronized void remove(LoggerName logger, String appender) {
        Map<String, Level> map = this._rules.get(logger);
        if (map != null) {
            map.remove(appender);
            if (map.isEmpty()) {
                this._rules.remove(logger);
            }
            this.clearCache();
        }
    }

    public synchronized void clear() {
        this._rules.clear();
        this.clearCache();
    }

    private void clearCache() {
        this._effectiveMaps.invalidateAll();
        this._effectiveLevels.invalidateAll();
    }

    private synchronized Map<String, Level> getMap(LoggerName logger) {
        Map<String, Level> map = this._rules.get(logger);
        return map == null ? Collections.emptyMap() : map;
    }

    public synchronized Map<String, Level> getInheritedMap(LoggerName logger) {
        if (this._parent == null) {
            return Maps.newHashMap(this.getMap(logger));
        }
        Map<String, Level> map = this._parent.getInheritedMap(logger);
        map.putAll(this.getMap(logger));
        return map;
    }

    private synchronized Map<String, Level> computeEffectiveMap(LoggerName logger) {
        Map<String, Level> map;
        LoggerName parent = logger.getParent();
        if (parent == null) {
            map = this.getInheritedMap(logger);
        } else {
            map = this.computeEffectiveMap(parent);
            map.putAll(this.getInheritedMap(logger));
        }
        return map;
    }

    public Level getThreshold(LoggerName logger, String appender) {
        try {
            return (Level)((Map)this._effectiveMaps.get((Object)logger)).get(appender);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public Level getThreshold(LoggerName logger) {
        try {
            return (Level)((Optional)this._effectiveLevels.get((Object)logger)).orNull();
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }
}

