/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.graphics;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class TableLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -4794538820552545305L;
    private int _columns = 1;
    private int _vGap;
    private int _hGap;

    public TableLayout(int columns) {
        this._columns = columns;
    }

    public void setHgap(int gap) {
        this._hGap = gap;
    }

    public void setVgap(int gap) {
        this._vGap = gap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int nmembers = target.getComponentCount();
            if (nmembers < 1) {
                return target.getSize();
            }
            int rows = nmembers / this._columns + 1;
            int[] width = new int[this._columns];
            int[] height = new int[rows];
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                Dimension dim = m.getPreferredSize();
                int column = i % this._columns;
                int row = i / this._columns;
                width[column] = Math.max(width[column], dim.width);
                height[row] = Math.max(height[row], dim.height);
            }
            int preHeight = 0;
            for (int aHeight : height) {
                preHeight += aHeight;
            }
            int preWidth = 0;
            for (int aWidth : width) {
                preWidth += aWidth;
            }
            Insets insets = target.getInsets();
            Dimension dd = new Dimension(preWidth + insets.right + insets.left + this._columns * this._hGap, preHeight + insets.top + insets.bottom + rows * this._vGap);
            return dd;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        int[] heightSum;
        int[] widthSum;
        int[] height;
        int[] width;
        Insets insets = target.getInsets();
        Object object = target.getTreeLock();
        synchronized (object) {
            int column;
            Component m;
            int i;
            int nmembers = target.getComponentCount();
            if (nmembers < 1) {
                return;
            }
            int rows = nmembers / this._columns + 1;
            width = new int[this._columns];
            height = new int[rows];
            for (i = 0; i < nmembers; ++i) {
                m = target.getComponent(i);
                Dimension dim = m.getPreferredSize();
                column = i % this._columns;
                int row = i / this._columns;
                width[column] = Math.max(width[column], dim.width);
                height[row] = Math.max(height[row], dim.height);
            }
            widthSum = new int[this._columns];
            heightSum = new int[rows];
            heightSum[0] = insets.top;
            for (i = 1; i < height.length; ++i) {
                heightSum[i] = heightSum[i - 1] + height[i - 1] + this._vGap;
            }
            widthSum[0] = insets.left;
            for (i = 1; i < width.length; ++i) {
                widthSum[i] = widthSum[i - 1] + width[i - 1] + this._hGap;
            }
            for (i = 0; i < nmembers; ++i) {
                m = target.getComponent(i);
                if (!m.isVisible()) continue;
                m.validate();
                int row = i / this._columns;
                column = i % this._columns;
                m.setSize(width[column], height[row]);
                m.setLocation(widthSum[column], heightSum[row]);
            }
        }
        target.setSize(widthSum[widthSum.length - 1] + width[width.length - 1] + insets.right, heightSum[heightSum.length - 1] + height[height.length - 1] + insets.bottom);
    }

    public String toString() {
        String str = "";
        return this.getClass().getName() + "[" + str + "]";
    }
}

