/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.edb;

import dmg.util.edb.SldbEntry;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Random;

public class Sldb {
    private RandomAccessFile _file;
    private static final int __VERSION = 1;
    private static final int __headerOffset = 128;
    private int _rpb;
    private int _bpdr;
    private int _biu;
    private long _lastOpen;
    private long _lastClose;
    private long _dbId;
    private String _dbName = "Unknown";
    private DirectoryDesc[] _desc;
    private Random _random = new Random(new Date().getTime());

    public Sldb(File file) throws IOException {
        this._openExistingFile(file);
    }

    public Sldb(File file, int bytesPerDataRecord, int recordsPerBlock) throws IOException {
        if (file.exists()) {
            throw new IllegalArgumentException("file exists");
        }
        if (bytesPerDataRecord < 1) {
            throw new IllegalArgumentException("bytesPerDataRecord < 1");
        }
        this._file = new RandomAccessFile(file, "rw");
        this._rpb = recordsPerBlock < 32 ? 32 : recordsPerBlock;
        this._bpdr = ((bytesPerDataRecord - 1) / 8 + 1) * 8;
        this._biu = 1;
        this._lastOpen = new Date().getTime();
        this._lastClose = 0L;
        byte[] dir = new byte[this._rpb / 8];
        try {
            this.writeHeader();
            this._file.seek(128L);
            this._file.write(dir);
            this._file.close();
        }
        catch (IOException e) {
            try {
                this._file.close();
            }
            catch (Exception ee) {
                // empty catch block
            }
            throw e;
        }
        this._openExistingFile(file);
    }

    private void _openExistingFile(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("file not found : " + file.getName());
        }
        this._file = new RandomAccessFile(file, "rw");
        try {
            this.readHeader();
        }
        catch (IOException | IllegalArgumentException iae) {
            try {
                this._file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw iae;
        }
        this._desc = new DirectoryDesc[this._biu];
        for (int i = 0; i < this._biu; ++i) {
            this._desc[i] = new DirectoryDesc(i);
        }
    }

    private void writeHeader() throws IOException {
        this._file.seek(0L);
        this._file.writeInt(1);
        this._file.writeInt(this._bpdr);
        this._file.writeInt(this._rpb);
        this._file.writeInt(this._biu);
        this._file.writeLong(this._lastOpen);
        this._file.writeLong(this._lastClose);
        this._file.writeLong(this._dbId);
        this._file.writeUTF(this._dbName);
    }

    private void readHeader() throws IOException {
        this._file.seek(0L);
        int version = this._file.readInt();
        if (version != 1) {
            throw new IllegalArgumentException("Version mismatch : I need 1 ; I found " + version);
        }
        this._bpdr = this._file.readInt();
        this._rpb = this._file.readInt();
        this._biu = this._file.readInt();
        if (this._bpdr < 8 || this._bpdr % 8 != 0 || this._rpb < 32 || this._rpb > 0x4000000 || this._biu < 1) {
            throw new IllegalArgumentException("Not a Sldb File (bpfr=" + this._bpdr + ";rpb=" + this._rpb + ")");
        }
        this._lastOpen = this._file.readLong();
        this._lastClose = this._file.readLong();
        this._dbId = this._file.readLong();
        this._dbName = this._file.readUTF();
    }

    public synchronized void close() throws IOException {
        this._lastClose = new Date().getTime();
        this.writeHeader();
        this._file.close();
        this._file = null;
    }

    public synchronized SldbEntry getEntry(long cookie) {
        return new SldbEntryImpl(cookie);
    }

    public synchronized SldbEntry getEntry() throws IOException {
        int s = this.findSmallestBlock();
        DirectoryDesc d = this._desc[s];
        if (d.getHighWater() > 80) {
            this.extend();
        }
        s = this.findSmallestBlock();
        return this._desc[s].getEntry();
    }

    public synchronized byte[] get(SldbEntry e) throws IOException {
        SldbEntryImpl sldb = (SldbEntryImpl)e;
        int block = sldb._blockPos;
        if (block >= this._biu) {
            throw new IllegalArgumentException("Not withing block " + this._biu);
        }
        if (!this._desc[block].isInUse(sldb)) {
            throw new IllegalArgumentException("Record not in use");
        }
        this._file.seek(sldb._filePos);
        int size = this._file.readInt();
        if (size >= this._bpdr - 4) {
            throw new IllegalArgumentException("Data record corrupted at " + sldb._filePos);
        }
        byte[] res = new byte[size];
        this._file.readFully(res);
        return res;
    }

    public synchronized SldbEntry put(byte[] data, int off, int size) throws IOException {
        SldbEntryImpl ei = (SldbEntryImpl)this.getEntry();
        return this.put(ei, data, off, size);
    }

    public synchronized SldbEntry put(SldbEntry e, byte[] data, int off, int size) throws IOException {
        if (size > this._bpdr - 4) {
            throw new IllegalArgumentException("can only accept " + this._bpdr + " bytes");
        }
        SldbEntryImpl ei = (SldbEntryImpl)e;
        this._file.seek(ei._filePos);
        this._file.writeInt(size);
        this._file.write(data, off, size);
        this._desc[ei._blockPos].setInUse(ei, true);
        return e;
    }

    String dirToString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._biu; ++i) {
            sb.append(this._desc[i].toString()).append("\n");
        }
        return sb.toString();
    }

    synchronized void remove(long cookie) throws IOException {
        this.setInUse(cookie, false);
    }

    public synchronized void remove(SldbEntry e) throws IOException {
        this.setInUse(e, false);
    }

    public synchronized SldbEntry nextUsedEntry(SldbEntry e) {
        SldbEntryImpl ei = (SldbEntryImpl)e;
        int block = ei._blockPos;
        if (block >= this._biu) {
            return null;
        }
        SldbEntryImpl re = this._desc[block].nextUsedEntry(ei);
        if (re != null) {
            return re;
        }
        ++block;
        while (block < this._biu) {
            re = this._desc[block].nextUsedEntry();
            if (re != null) {
                return re;
            }
            ++block;
        }
        return null;
    }

    protected void setInUse(long cookie, boolean set) throws IOException {
        SldbEntryImpl ei = new SldbEntryImpl(cookie);
        int block = ei._blockPos;
        if (block >= this._biu) {
            throw new IllegalArgumentException("Not within block " + this._biu);
        }
        this._desc[block].setInUse(ei, set);
    }

    protected void setInUse(SldbEntry e, boolean set) throws IOException {
        SldbEntryImpl ei = (SldbEntryImpl)e;
        int block = ei._blockPos;
        if (block >= this._biu) {
            throw new IllegalArgumentException("Not within block " + this._biu);
        }
        this._desc[block].setInUse(ei, set);
    }

    private void extend() throws IOException {
        int size = this._desc.length;
        DirectoryDesc[] desc = new DirectoryDesc[size + 1];
        System.arraycopy(this._desc, 0, desc, 0, size);
        desc[size] = new DirectoryDesc();
        if (desc[size].getBlock() != size) {
            throw new IllegalArgumentException("PANIC : block mismath while expending");
        }
        ++this._biu;
        this._file.seek(12L);
        this._file.writeInt(this._biu);
        this._desc = desc;
    }

    private int findSmallestBlock() {
        int minPos = 0;
        int min = this._desc[minPos].getInUse();
        for (int i = 1; i < this._biu; ++i) {
            int t = this._desc[i].getInUse();
            if (t >= min) continue;
            minPos = i;
        }
        return minPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage : ... <filename> create");
            System.err.println("Usage : ... <filename> show");
            System.err.println("Usage : ... <filename> getcookie");
            System.err.println("Usage : ... <filename> write <string> [<cookie>]");
            System.err.println("Usage : ... <filename> read <cookie>");
            System.exit(4);
        }
        sldb = null;
        if (args[1].equals("create")) {
            sldb = new Sldb(new File("xxx"), 1024, 32);
            sldb.close();
            return;
        }
        try {
            sldb = new Sldb(new File(args[0]));
            var2_2 = args[1];
            var3_10 = -1;
            switch (var2_2.hashCode()) {
                case 113762: {
                    if (!var2_2.equals("set")) break;
                    var3_10 = 0;
                    break;
                }
                case 111442729: {
                    if (!var2_2.equals("unset")) break;
                    var3_10 = 1;
                    break;
                }
                case 113399775: {
                    if (!var2_2.equals("write")) break;
                    var3_10 = 2;
                    break;
                }
                case 3377907: {
                    if (!var2_2.equals("next")) break;
                    var3_10 = 3;
                    break;
                }
                case 3496342: {
                    if (!var2_2.equals("read")) break;
                    var3_10 = 4;
                    break;
                }
                case 1257390394: {
                    if (!var2_2.equals("getcookie")) break;
                    var3_10 = 5;
                    break;
                }
                case 3529469: {
                    if (!var2_2.equals("show")) break;
                    var3_10 = 6;
                }
            }
            switch (var3_10) {
                case 0: {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("usage : ... <dbFile> set <n>");
                    }
                    sldb.setInUse(Long.parseLong(args[2]), true);
                    ** break;
lbl51:
                    // 1 sources

                    break;
                }
                case 1: {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("usage : ... unset <n>");
                    }
                    sldb.setInUse(Long.parseLong(args[2]), false);
                    ** break;
lbl57:
                    // 1 sources

                    break;
                }
                case 2: {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("usage : ... <dbFile> write <string> [<cookie>]");
                    }
                    data = args[2].getBytes();
                    if (args.length < 4) {
                        e = sldb.put(data, 0, data.length);
                    } else {
                        e = sldb.getEntry(Long.parseLong(args[3]));
                        sldb.put(e, data, 0, data.length);
                    }
                    System.out.println("" + e.getCookie());
                    ** break;
lbl70:
                    // 1 sources

                    break;
                }
                case 3: {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("usage : ... <dbFile> next <cookie>");
                    }
                    e = sldb.getEntry(Long.parseLong(args[2]));
                    if ((e = sldb.nextUsedEntry(e)) == null) {
                        throw new IllegalArgumentException("No entries left");
                    }
                    System.out.println("" + e.getCookie());
                    ** break;
lbl79:
                    // 1 sources

                    break;
                }
                case 4: {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("usage : ... <dbFile> read <c>");
                    }
                    e = sldb.getEntry(Long.parseLong(args[2]));
                    data = sldb.get(e);
                    System.out.println(new String(data));
                    ** break;
lbl87:
                    // 1 sources

                    break;
                }
                case 5: {
                    if (args.length < 2) {
                        throw new IllegalArgumentException("usage : ... <dbFile> getcookie");
                    }
                    e = sldb.getEntry();
                    System.out.println("" + e.getCookie());
                    ** break;
lbl94:
                    // 1 sources

                    break;
                }
                case 6: {
                    sldb = new Sldb(new File(args[0]));
                    System.out.println(sldb.dirToString());
                    break;
                }
                ** default:
lbl100:
                // 1 sources

                break;
            }
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Wrong Argument : " + iae.getMessage());
            System.exit(4);
        }
        catch (IOException e) {
            System.err.println("IOProblem : " + e.getMessage());
            System.exit(5);
        }
        catch (Exception ee) {
            System.err.println("Problem : " + ee);
            ee.printStackTrace();
            System.exit(6);
        }
        finally {
            try {
                sldb.close();
            }
            catch (Exception ee) {}
        }
        System.exit(0);
    }

    private class DirectoryDesc {
        private long _position;
        private int _block;
        private int _inUse;
        private byte[] _dir;

        private DirectoryDesc(int block) throws IOException {
            if (block >= Sldb.this._biu) {
                throw new IllegalArgumentException("block number to large " + block + " >= " + Sldb.this._biu);
            }
            this._block = block;
            this._position = 128 + this._block * (Sldb.this._rpb / 8 + Sldb.this._rpb * Sldb.this._bpdr);
            Sldb.this._file.seek(this._position);
            this._dir = new byte[Sldb.this._rpb / 8];
            Sldb.this._file.readFully(this._dir);
            this._inUse = this.countInUse();
        }

        private DirectoryDesc() throws IOException {
            this._block = Sldb.this._biu;
            this._inUse = 0;
            this._position = 128 + this._block * (Sldb.this._rpb / 8 + Sldb.this._rpb * Sldb.this._bpdr);
            Sldb.this._file.seek(this._position);
            this._dir = new byte[Sldb.this._rpb / 8];
            Sldb.this._file.write(this._dir);
        }

        private int getHighWater() {
            return (int)((double)((float)this._inUse / (float)Sldb.this._rpb) * 100.0);
        }

        private int getBlock() {
            return this._block;
        }

        private void store() throws IOException {
            Sldb.this._file.seek(this._position);
            Sldb.this._file.write(this._dir);
        }

        private SldbEntryImpl nextUsedEntry(int bytePos, int bitPos) {
            int maxBytes = Sldb.this._rpb / 8;
            while (bytePos < this._dir.length) {
                if ((this._dir[bytePos % maxBytes] & 1 << bitPos) != 0) {
                    long cookie = (long)this._block * (long)Sldb.this._rpb + (long)(bytePos % maxBytes * 8) + (long)bitPos;
                    SldbEntryImpl ei = new SldbEntryImpl(cookie);
                    return ei;
                }
                if (++bitPos < 8) continue;
                ++bytePos;
                bitPos = 0;
            }
            return null;
        }

        private SldbEntryImpl nextUsedEntry(SldbEntryImpl e) {
            int bitPos = e._bitPos + 1;
            int bytePos = e._bytePos;
            if (bitPos >= 8) {
                bitPos = 0;
                ++bytePos;
            }
            return this.nextUsedEntry(bytePos, bitPos);
        }

        private SldbEntryImpl nextUsedEntry() {
            return this.nextUsedEntry(0, 0);
        }

        private SldbEntryImpl getEntry() throws IOException {
            if (this._inUse >= Sldb.this._rpb) {
                throw new IllegalArgumentException("out of space : " + this._block);
            }
            int r = (Sldb.this._random.nextInt() & 0xFFFFFF) % Sldb.this._rpb;
            int bitPos = r % 8;
            int bytePos = r / 8;
            int maxBytes = Sldb.this._rpb / 8;
            for (int i = 0; i < Sldb.this._rpb; ++i) {
                if ((this._dir[bytePos] & 1 << bitPos) == 0) {
                    long cookie = (long)this._block * (long)Sldb.this._rpb + (long)(bytePos * 8) + (long)bitPos;
                    SldbEntryImpl ei = new SldbEntryImpl(cookie);
                    this.setInUse(ei, true);
                    return ei;
                }
                if (++bitPos < 8) continue;
                bytePos = (bytePos + 1) % maxBytes;
                bitPos = 0;
            }
            throw new IllegalArgumentException("out of space(2) : " + this._block);
        }

        public int getInUse() {
            return this._inUse;
        }

        public int countInUse() {
            int c = Sldb.this._rpb / 8;
            int counter = 0;
            for (int i = 0; i < c; ++i) {
                byte v = this._dir[i];
                int mask = 1;
                for (int j = 0; j < 8; ++j) {
                    if ((v & mask) > 0) {
                        ++counter;
                    }
                    mask <<= 1;
                }
            }
            return counter;
        }

        public void setInUse(SldbEntryImpl e, boolean set) throws IOException {
            int m;
            boolean wasSet;
            int v = this._dir[e._bytePos];
            boolean bl = wasSet = (v & (m = 1 << e._bitPos)) > 0;
            if (set && !wasSet) {
                this._dir[((SldbEntryImpl)e)._bytePos] = (byte)(v |= m);
                ++this._inUse;
                this.store();
            } else if (wasSet && !set) {
                this._dir[((SldbEntryImpl)e)._bytePos] = (byte)(v &= ~m);
                --this._inUse;
                this.store();
            }
        }

        public boolean isInUse(long cookie) {
            int p = (int)(cookie % (long)Sldb.this._rpb);
            byte v = this._dir[p / 8];
            int s = p % 8;
            return (v & 1 << p % 8) > 0;
        }

        public boolean isInUse(SldbEntryImpl e) {
            return (this._dir[e._bytePos] & 1 << e._bitPos % 8) > 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("t=").append(Sldb.this._rpb).append(";u=").append(this._inUse).append(";m=");
            for (int i = 0; i < Sldb.this._rpb; ++i) {
                sb.append(this.isInUse(i) ? "1" : "0");
            }
            return sb.toString();
        }
    }

    private class SldbEntryImpl
    implements SldbEntry {
        private long _cookie;
        private int _blockPos;
        private int _bytePos;
        private int _bitPos;
        private int _recordPos;
        private long _filePos;

        SldbEntryImpl(long cookie) {
            this._cookie = cookie;
            this._blockPos = (int)(this._cookie / (long)Sldb.this._rpb);
            this._recordPos = (int)(this._cookie % (long)Sldb.this._rpb);
            this._bytePos = this._recordPos / 8;
            this._bitPos = this._recordPos % 8;
            this._filePos = 128 + this._blockPos * (Sldb.this._rpb / 8 + Sldb.this._rpb * Sldb.this._bpdr) + (Sldb.this._rpb / 8 + this._recordPos * Sldb.this._bpdr);
        }

        @Override
        public long getCookie() {
            return this._cookie;
        }

        @Override
        public SldbEntry getNextEntry() {
            return null;
        }

        public String toString() {
            return "" + this._cookie + ":" + this._blockPos + ":" + this._recordPos + ":" + this._bytePos + ":" + this._bitPos + ":" + this._filePos;
        }
    }
}

