/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.db;

import dmg.util.db.DbException;
import dmg.util.db.DbFileRecord;
import dmg.util.db.DbGLock;
import dmg.util.db.DbLockException;
import dmg.util.db.DbLockable;
import dmg.util.db.DbRecordable;
import dmg.util.db.DbResourceHandle;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public class DbResourceHandler
extends DbGLock {
    private final Hashtable<String, ResourceEntry> _table = new Hashtable();
    private File _dataSource;

    public DbResourceHandler(File source, boolean create) {
        this._dataSource = source;
        if (create && this._dataSource.isDirectory()) {
            throw new IllegalArgumentException("DataSource already exists");
        }
        if (create) {
            throw new IllegalArgumentException("create not yet implemented");
        }
    }

    public DbResourceHandler(DbLockable creator, File source, boolean create) {
        super(creator);
        this._dataSource = source;
        if (create && this._dataSource.isDirectory()) {
            throw new IllegalArgumentException("DataSource already exists");
        }
        if (create) {
            throw new IllegalArgumentException("create not yet implemented");
        }
    }

    public String[] getResourceNames() {
        return this._dataSource.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbResourceHandle createResource(String name) throws DbException, InterruptedException {
        DbFileRecord rec;
        this.open(2);
        File file = new File(this._dataSource, name);
        if (file.exists()) {
            this.close();
            throw new DbException("Record already exists " + file);
        }
        try {
            rec = new DbFileRecord(this, file, true);
        }
        catch (IOException ioe) {
            this.close();
            throw new DbException("Can't create " + name + " : " + ioe.toString());
        }
        DbResourceHandle handle = new DbResourceHandle(name, this, rec);
        Hashtable<String, ResourceEntry> hashtable = this._table;
        synchronized (hashtable) {
            this._table.put(name, new ResourceEntry(rec));
        }
        this.close();
        return handle;
    }

    public int getCacheSize() {
        return this._table.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbResourceHandle getResourceByName(String name) throws DbException, InterruptedException {
        DbFileRecord rec;
        this.open(1);
        ResourceEntry entry = this._table.get(name);
        if (entry != null) {
            entry.incrementRefCounter();
            this.close();
            return new DbResourceHandle(name, this, entry.getRecordable());
        }
        File file = new File(this._dataSource, name);
        if (!file.exists()) {
            this.close();
            throw new DbException("Record not found " + file);
        }
        try {
            rec = new DbFileRecord(this, file, false);
        }
        catch (IOException ioe) {
            this.close();
            throw new DbException("Can't create " + name + " : " + ioe.toString());
        }
        DbResourceHandle handle = new DbResourceHandle(name, this, rec);
        Hashtable<String, ResourceEntry> hashtable = this._table;
        synchronized (hashtable) {
            this._table.put(name, new ResourceEntry(rec));
        }
        this.close();
        return handle;
    }

    public void removeResource(DbResourceHandle handle) throws DbLockException, InterruptedException {
        this.open(2);
        handle.open(2);
        handle.remove();
        handle.close();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlinkResource(DbResourceHandle handle) throws DbLockException {
        Hashtable<String, ResourceEntry> hashtable = this._table;
        synchronized (hashtable) {
            ResourceEntry entry = this._table.get(handle.getName());
            if (entry == null) {
                throw new DbLockException("PANIC : entry to be removed not found : " + handle.getName());
            }
            entry.decrementRefCounter();
            if (entry.getRefCounter() <= 0) {
                this._table.remove(handle.getName());
                System.out.println("Removed from cache : " + handle.getName());
            }
        }
    }

    private class ResourceEntry {
        private DbRecordable _recordable;
        private int _refCounter;

        private ResourceEntry(DbRecordable recordable) {
            this._recordable = recordable;
            this._refCounter = 1;
        }

        private DbRecordable getRecordable() {
            return this._recordable;
        }

        private synchronized void incrementRefCounter() {
            ++this._refCounter;
        }

        private synchronized void decrementRefCounter() {
            --this._refCounter;
        }

        private int getRefCounter() {
            return this._refCounter;
        }
    }
}

