/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.db;

import dmg.util.db.DbLockException;
import dmg.util.db.DbLockable;
import dmg.util.db.DbRecordable;
import dmg.util.db.DbResourceHandler;
import java.util.Enumeration;

public class DbResourceHandle
implements DbLockable,
DbRecordable {
    private int _refCounter;
    private DbResourceHandler _creator;
    private DbRecordable _resource;
    private String _name;
    private boolean _isValid = true;

    public DbResourceHandle(String name, DbResourceHandler creator, DbRecordable resource) {
        this._name = name;
        this._creator = creator;
        this._resource = resource;
    }

    public String getName() {
        return this._name;
    }

    public void isValid(boolean isValid) {
        this._isValid = isValid;
    }

    public boolean isValid() {
        return this._isValid;
    }

    @Override
    public void open(int flags) throws DbLockException, InterruptedException {
        if (!this._isValid) {
            throw new DbLockException("Object no longer exists");
        }
        this._resource.open(flags);
    }

    @Override
    public void close() throws DbLockException {
        this._resource.close();
    }

    @Override
    public void setAttribute(String name, String attribute) {
        this._resource.setAttribute(name, attribute);
    }

    @Override
    public void setAttribute(String name, String[] attribute) {
        this._resource.setAttribute(name, attribute);
    }

    @Override
    public Object getAttribute(String name) {
        return this._resource.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributes() {
        return this._resource.getAttributes();
    }

    @Override
    public void remove() {
        this._resource.remove();
    }

    protected void finalize() throws Throwable {
        System.out.println("Decrementing " + this._name);
        this._creator.unlinkResource(this);
        super.finalize();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name : ").append(this.getName()).append("\n");
        sb.append(this._resource.toString());
        return sb.toString();
    }
}

