/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.command;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import dmg.util.command.Argument;
import dmg.util.command.Command;
import dmg.util.command.Option;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.dcache.commons.util.Strings;

public class HelpPrinter {
    private static final Function<Field, Integer> GET_ARGUMENT_INDEX = new Function<Field, Integer>(){

        public Integer apply(Field field) {
            return field.getAnnotation(Argument.class).index();
        }
    };
    private static final Function<Field, String> GET_OPTION_NAME = new Function<Field, String>(){

        public String apply(Field field) {
            return field.getAnnotation(Option.class).name();
        }
    };

    private static Multimap<String, Field> getOptions(Class<?> clazz) {
        TreeMultimap options = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)Ordering.natural().onResultOf(GET_OPTION_NAME));
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                Option option = field.getAnnotation(Option.class);
                if (option == null) continue;
                options.put((Object)option.category(), (Object)field);
            }
        }
        return options;
    }

    private static List<Field> getArguments(Class<?> clazz) {
        ArrayList arguments = Lists.newArrayList();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Argument.class)) continue;
                arguments.add(field);
            }
        }
        Collections.sort(arguments, Ordering.natural().onResultOf(GET_ARGUMENT_INDEX));
        return arguments;
    }

    private static String getMetaVar(Class<?> type, Option option) {
        if (!option.metaVar().isEmpty()) {
            return option.metaVar().toUpperCase();
        }
        if (!option.valueSpec().isEmpty()) {
            return option.valueSpec();
        }
        if (option.values().length > 0) {
            return Joiner.on((String)"|").join((Object[])option.values());
        }
        if (type.isEnum()) {
            return Joiner.on((String)"|").join((Object[])type.getEnumConstants());
        }
        return type.getSimpleName().toUpperCase();
    }

    private static String getMetaVar(Field field, Argument argument) {
        if (!argument.valueSpec().isEmpty()) {
            return argument.valueSpec();
        }
        if (!argument.metaVar().isEmpty()) {
            return argument.metaVar().toUpperCase();
        }
        return field.getName().toUpperCase();
    }

    private static String getSignature(Class<?> clazz) {
        StringBuilder signature = new StringBuilder();
        Multimap<String, Field> options = HelpPrinter.getOptions(clazz);
        for (Field field : options.values()) {
            Class<?> type = field.getType();
            Option option = field.getAnnotation(Option.class);
            if (option == null) continue;
            if (!type.isArray()) {
                if (!option.required()) {
                    signature.append("[");
                }
                signature.append("-").append(option.name());
                if (!Boolean.class.equals(type) && !Boolean.TYPE.equals(type)) {
                    signature.append("=").append(HelpPrinter.getMetaVar(type, option));
                }
                if (!option.required()) {
                    signature.append("]");
                }
            } else if (option.separator().isEmpty()) {
                if (!option.required()) {
                    signature.append("[");
                }
                signature.append("-").append(option.name());
                signature.append("=").append(HelpPrinter.getMetaVar(type.getComponentType(), option));
                if (!option.required()) {
                    signature.append("]");
                }
                signature.append("...");
            } else {
                if (!option.required()) {
                    signature.append("[");
                }
                String metaVar = HelpPrinter.getMetaVar(type.getComponentType(), option);
                signature.append("-").append(option.name());
                signature.append("=").append(metaVar);
                signature.append("[").append(option.separator()).append(metaVar).append("]...");
                if (!option.required()) {
                    signature.append("]...");
                }
            }
            signature.append(" ");
        }
        for (Field field : HelpPrinter.getArguments(clazz)) {
            Argument argument = field.getAnnotation(Argument.class);
            String metaVar = HelpPrinter.getMetaVar(field, argument);
            if (argument.required()) {
                signature.append(metaVar);
            } else {
                signature.append("[").append(metaVar).append("]");
            }
            if (field.getType().isArray()) {
                signature.append("...");
            }
            signature.append(" ");
        }
        return signature.toString();
    }

    private static String getShortSignature(Class<?> clazz) {
        StringBuilder signature = new StringBuilder();
        if (!HelpPrinter.getOptions(clazz).isEmpty()) {
            signature.append("[OPTIONS] ");
        }
        for (Field field : HelpPrinter.getArguments(clazz)) {
            Argument argument = field.getAnnotation(Argument.class);
            String metaVar = HelpPrinter.getMetaVar(field, argument);
            if (argument.required()) {
                signature.append(metaVar);
            } else {
                signature.append("[").append(metaVar).append("]");
            }
            if (field.getType().isArray()) {
                signature.append("...");
            }
            signature.append(" ");
        }
        return signature.toString();
    }

    static String getHelpHint(Command command, Class<?> clazz) {
        String hint = command.hint().isEmpty() ? "" : "# " + command.hint();
        String signature = HelpPrinter.getSignature(clazz);
        if (signature.length() + hint.length() > 78) {
            signature = HelpPrinter.getShortSignature(clazz);
        }
        return (signature.isEmpty() ? "" : signature + " ") + hint;
    }

    static String getHelp(Command command, Class<?> clazz) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("NAME");
        writer.append("       ").append(command.name());
        if (!command.hint().isEmpty()) {
            writer.append(" - ").append(command.hint());
        }
        writer.println();
        writer.println();
        writer.println("SYNOPSIS");
        writer.append(Strings.wrap((String)"       ", (String)(command.name() + " " + HelpPrinter.getSignature(clazz)), (int)72));
        writer.println();
        if (!command.usage().isEmpty()) {
            writer.println("DESCRIPTION");
            writer.append(Strings.wrap((String)"       ", (String)command.usage(), (int)72));
        }
        writer.println();
        Multimap<String, Field> options = HelpPrinter.getOptions(clazz);
        if (!options.isEmpty()) {
            writer.println("OPTIONS");
            for (Map.Entry e : options.asMap().entrySet()) {
                if (!((String)e.getKey()).isEmpty()) {
                    writer.append("       ").append((CharSequence)e.getKey()).println(":");
                }
                for (Field field : (Collection)e.getValue()) {
                    Class<?> type = field.getType();
                    Option option = field.getAnnotation(Option.class);
                    writer.append("       ");
                    if (!type.isArray()) {
                        writer.append("  -").append(option.name());
                        if (!Boolean.class.equals(type) && !Boolean.TYPE.equals(type)) {
                            writer.append("=").append(HelpPrinter.getMetaVar(type, option));
                        }
                    } else if (option.separator().isEmpty()) {
                        writer.append("  -").append(option.name());
                        writer.append("=").append(HelpPrinter.getMetaVar(type.getComponentType(), option));
                        writer.append("...");
                    } else {
                        String metaVar = HelpPrinter.getMetaVar(type.getComponentType(), option);
                        writer.append("  -").append(option.name());
                        writer.append("=").append(metaVar);
                        writer.append("[").append(option.separator()).append(metaVar).append("]");
                        writer.append("...");
                    }
                    writer.println();
                    if (option.usage().isEmpty()) continue;
                    writer.append(Strings.wrap((String)"              ", (String)option.usage(), (int)65));
                }
            }
        }
        writer.flush();
        return out.toString();
    }
}

