/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.command;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import dmg.util.command.AnnotatedCommandExecutor;
import dmg.util.command.Command;
import dmg.util.command.CommandExecutor;
import dmg.util.command.CommandScanner;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class AnnotatedCommandScanner
implements CommandScanner {
    private static final TypeToken<Callable<? extends Serializable>> EXPECTED_TYPE = new TypeToken<Callable<? extends Serializable>>(){};

    private Class<? extends Callable<? extends Serializable>> cast(Class<?> clazz) {
        if (EXPECTED_TYPE.isAssignableFrom(clazz)) {
            return clazz.asSubclass(Callable.class);
        }
        throw new RuntimeException("This is a bug. Please notify support@dcache.org (" + clazz + " does not implement Callable<? extends Serializable>).");
    }

    @Override
    public Map<List<String>, ? extends CommandExecutor> scan(Object obj) {
        Class<?>[] classes;
        HashMap commands = Maps.newHashMap();
        for (Class<?> clazz : classes = obj.getClass().getDeclaredClasses()) {
            Command command = clazz.getAnnotation(Command.class);
            if (command == null || clazz.isInterface() || !Callable.class.isAssignableFrom(clazz)) continue;
            try {
                Constructor<? extends Callable<? extends Serializable>> constructor = this.cast(clazz).getDeclaredConstructor(obj.getClass());
                constructor.setAccessible(true);
                commands.put(Arrays.asList(command.name().split(" ")), new AnnotatedCommandExecutor(obj, command, constructor));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("This is a bug. Please notify support@dcache.org.", e);
            }
        }
        return commands;
    }
}

