/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.command;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dmg.util.Args;
import dmg.util.CommandRequestable;
import dmg.util.command.AcCommandExecutor;
import dmg.util.command.CommandExecutor;
import dmg.util.command.CommandScanner;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AcCommandScanner
implements CommandScanner {
    private static final Class<?> ASCII_ARGS = Args.class;
    private static final Class<?> BINARY_ARGS = CommandRequestable.class;

    @Override
    public Map<List<String>, ? extends CommandExecutor> scan(Object obj) {
        HashMap commands = Maps.newHashMap();
        AcCommandScanner.scanMethods(obj, commands);
        AcCommandScanner.scanFields(obj, commands);
        return commands;
    }

    private static void scanFields(Object obj, Map<List<String>, AcCommandExecutor> commands) {
        block15: for (Field field : obj.getClass().getFields()) {
            FieldType helpMode;
            String helpType;
            Iterator i = Splitter.on((char)'_').split((CharSequence)field.getName()).iterator();
            switch (helpType = (String)i.next()) {
                case "hh": {
                    helpMode = FieldType.HELP_HINT;
                    break;
                }
                case "fh": {
                    helpMode = FieldType.FULL_HELP;
                    break;
                }
                case "acl": {
                    helpMode = FieldType.ACL;
                    break;
                }
                default: {
                    continue block15;
                }
            }
            if (!i.hasNext()) continue;
            ArrayList name = Lists.newArrayList(i);
            AcCommandExecutor command = AcCommandScanner.getCommandExecutor(obj, commands, name);
            switch (helpMode) {
                case FULL_HELP: {
                    command.setFullHelpField(field);
                    continue block15;
                }
                case HELP_HINT: {
                    command.setHelpHintField(field);
                    continue block15;
                }
                case ACL: {
                    command.setAclField(field);
                }
            }
        }
    }

    private static void scanMethods(Object obj, Map<List<String>, AcCommandExecutor> commands) {
        for (Method method : obj.getClass().getMethods()) {
            String comName;
            int methodType;
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 1) continue;
            if (params[0].equals(ASCII_ARGS)) {
                methodType = 0;
            } else {
                if (!params[0].equals(BINARY_ARGS)) continue;
                methodType = 1;
            }
            Iterator i = Splitter.on((char)'_').split((CharSequence)method.getName()).iterator();
            if (!((String)i.next()).equals("ac") || !i.hasNext() || (comName = (String)i.next()).equals("$")) continue;
            ArrayList name = Lists.newArrayList();
            name.add(comName);
            while (i.hasNext() && !(comName = (String)i.next()).equals("$")) {
                name.add(comName);
            }
            int minArgs = 0;
            int maxArgs = 0;
            try {
                if (i.hasNext()) {
                    minArgs = Integer.parseInt((String)i.next());
                    maxArgs = i.hasNext() ? Integer.parseInt((String)i.next()) : minArgs;
                }
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(method.getName() + ": " + e.getMessage());
            }
            AcCommandExecutor command = AcCommandScanner.getCommandExecutor(obj, commands, name);
            command.setMethod(methodType, method, minArgs, maxArgs);
        }
    }

    private static AcCommandExecutor getCommandExecutor(Object obj, Map<List<String>, AcCommandExecutor> commands, List<String> name) {
        AcCommandExecutor command = commands.get(name);
        if (command == null) {
            command = new AcCommandExecutor(obj);
            commands.put(name, command);
        }
        return command;
    }

    private static enum FieldType {
        HELP_HINT,
        FULL_HELP,
        ACL;

    }
}

