/*
 * Decompiled with CFR 0.152.
 */
package dmg.util.command;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import dmg.util.Args;
import dmg.util.CommandException;
import dmg.util.CommandPanicException;
import dmg.util.CommandRequestable;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.command.CommandExecutor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class AcCommandExecutor
implements CommandExecutor {
    private final Method[] _method = new Method[2];
    private final int[] _minArgs = new int[2];
    private final int[] _maxArgs = new int[2];
    private final Object _listener;
    private Field _fullHelp;
    private Field _helpHint;
    private Field _acls;

    public AcCommandExecutor(Object listener) {
        this._listener = listener;
    }

    public void setMethod(int methodType, Method m, int mn, int mx) {
        this._method[methodType] = m;
        this._minArgs[methodType] = mn;
        this._maxArgs[methodType] = mx;
    }

    public void setFullHelpField(Field f) {
        this._fullHelp = f;
    }

    public void setHelpHintField(Field f) {
        this._helpHint = f;
    }

    public void setAclField(Field f) {
        this._acls = f;
    }

    @Override
    public boolean hasACLs() {
        return this._acls != null;
    }

    @Override
    public String[] getACLs() {
        try {
            if (this._acls != null) {
                Object value = this._acls.get(this._listener);
                if (value instanceof String[]) {
                    return (String[])value;
                }
                if (value instanceof String) {
                    return new String[]{value.toString()};
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new String[0];
    }

    @Override
    public String getFullHelp() {
        try {
            Object help;
            if (this._fullHelp != null && (help = this._fullHelp.get(this._listener)) != null) {
                return help.toString();
            }
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return null;
    }

    @Override
    public String getHelpHint() {
        try {
            if (this._helpHint != null) {
                Object hint = this._helpHint.get(this._listener);
                if (hint != null) {
                    return hint.toString();
                }
            } else {
                int mt = 0;
                Method method = this._method[mt];
                if (method != null) {
                    int i;
                    StringBuilder sb = new StringBuilder();
                    for (i = 0; i < this._minArgs[mt]; ++i) {
                        sb.append(" <arg-").append(i).append(">");
                    }
                    if (this._maxArgs[mt] != this._minArgs[mt]) {
                        sb.append(" [ ");
                        for (i = this._minArgs[mt]; i < this._maxArgs[mt]; ++i) {
                            sb.append(" <arg-").append(i).append(">");
                        }
                        sb.append(" ] ");
                    }
                    return sb.toString();
                }
            }
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return null;
    }

    @Override
    public Serializable execute(Object arguments, int methodType) throws CommandException {
        Method method = this._method[methodType];
        if (method == null) {
            throw new CommandSyntaxException("Command not found");
        }
        int params = methodType == 0 ? ((Args)arguments).argc() : ((CommandRequestable)arguments).getArgc();
        if (params < this._minArgs[methodType] || params > this._maxArgs[methodType]) {
            throw new CommandSyntaxException("Invalid number of arguments");
        }
        try {
            return (Serializable)method.invoke(this._listener, arguments);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            Throwables.propagateIfInstanceOf((Throwable)te, CommandException.class);
            Throwables.propagateIfInstanceOf((Throwable)te, Error.class);
            if (te instanceof RuntimeException && !(te instanceof IllegalArgumentException) && !(te instanceof IllegalStateException)) {
                boolean declared = false;
                for (Class<?> clazz : method.getExceptionTypes()) {
                    if (!clazz.isAssignableFrom(te.getClass())) continue;
                    declared = true;
                }
                if (!declared) {
                    throw (RuntimeException)te;
                }
            }
            throw new CommandThrowableException(te.toString() + " from " + method.getName(), te);
        }
        catch (IllegalAccessException e) {
            throw new CommandPanicException("Exception while invoking " + method.getName(), e);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this._method[0]).addValue((Object)this._method[1]).addValue((Object)this._fullHelp).addValue((Object)this._helpHint).addValue((Object)this._acls).omitNullValues().toString();
    }
}

