/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class Pinboard {
    private final List<PinEntry> _pin = new Vector<PinEntry>();
    private final DateFormat _df = new SimpleDateFormat("hh.mm.ss ");
    private final int _size;

    public Pinboard() {
        this(20);
    }

    public Pinboard(int size) {
        this._size = size;
    }

    public synchronized void pin(String note) {
        this._pin.add(new PinEntry(note));
        if (this._pin.size() > this._size) {
            this._pin.remove(0);
        }
    }

    public synchronized void dump(StringBuffer sb) {
        this.dump(sb, this._size);
    }

    public synchronized void dump(StringBuffer sb, int last) {
        int i = this._pin.size() - last + 1;
        int n = i = i < 0 ? 0 : i;
        while (i < this._pin.size()) {
            sb.append(this._pin.get(i).toString()).append("\n");
            ++i;
        }
    }

    public synchronized void dump(File file) throws IOException {
        this.dump(file, this._size);
    }

    public synchronized void dump(File file, int last) throws IOException {
        int i = this._pin.size() - last + 1;
        PrintWriter pw = new PrintWriter(new FileWriter(file));
        int n = i = i < 0 ? 0 : i;
        while (i < this._pin.size()) {
            pw.println(this._pin.get(i).toString());
            ++i;
        }
        pw.close();
    }

    private class PinEntry {
        private String _message;
        private Date _date;

        public PinEntry(String message) {
            this._message = message;
            this._date = new Date();
        }

        public String toString() {
            return Pinboard.this._df.format(this._date) + " " + this._message;
        }
    }
}

