/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import dmg.util.Replaceable;
import java.util.Stack;

public class Formats {
    public static final int CENTER = 1;
    public static final int RIGHT = 4;
    public static final int LEFT = 2;
    public static final int CUT = 8;
    private static final int RP_IDLE = 0;
    private static final int RP_DOLLAR = 1;
    private static final int RP_OPENED = 2;

    public static String field(String in, int field) {
        return Formats.field(in, field, 2);
    }

    public static String field(String in, int field, int flags) {
        if (in.length() >= field) {
            if ((flags & 8) > 0) {
                return in.substring(0, field + 1);
            }
            return in;
        }
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) > 0) {
            int i;
            int diff = field - in.length();
            int left = diff / 2;
            int right = diff - left;
            for (i = 0; i < left; ++i) {
                sb.append(" ");
            }
            sb.append(in);
            for (i = 0; i < right; ++i) {
                sb.append(" ");
            }
        } else if ((flags & 4) > 0) {
            int diff = field - in.length();
            for (int i = 0; i < diff; ++i) {
                sb.append(" ");
            }
            sb.append(in);
        } else {
            sb.append(in);
            int diff = field - in.length();
            for (int i = 0; i < diff; ++i) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public static String cutClass(String c) {
        int lastDot = c.lastIndexOf(46);
        if (lastDot < 0 || lastDot >= c.length() - 1) {
            return c;
        }
        return c.substring(lastDot + 1);
    }

    private static String replaceKeywords(String in, Replaceable cb, Stack<String> replaced) {
        StringBuilder key = null;
        StringBuilder out = new StringBuilder();
        int state = 0;
        int len = in.length();
        int braceCount = 0;
        boolean startOfReference = false;
        block21: for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            switch (state) {
                case 0: {
                    switch (c) {
                        case '$': {
                            state = 1;
                            continue block21;
                        }
                    }
                    out.append(c);
                    continue block21;
                }
                case 1: {
                    switch (c) {
                        case '{': {
                            startOfReference = false;
                            state = 2;
                            braceCount = 0;
                            key = new StringBuilder();
                            continue block21;
                        }
                        case '$': {
                            out.append('$');
                            state = 0;
                            continue block21;
                        }
                    }
                    out.append('$').append(c);
                    state = 0;
                    continue block21;
                }
                case 2: {
                    switch (c) {
                        case '$': {
                            if (!startOfReference) {
                                key.append(c);
                            }
                            startOfReference = !startOfReference;
                            continue block21;
                        }
                        case '{': {
                            key.append(c);
                            if (!startOfReference) continue block21;
                            ++braceCount;
                            startOfReference = false;
                            continue block21;
                        }
                        case '}': {
                            startOfReference = false;
                            if (braceCount > 0) {
                                --braceCount;
                                key.append(c);
                                continue block21;
                            }
                            state = 0;
                            String keyName = Formats.replaceKeywords(key.toString(), cb, replaced);
                            String keyValue = cb.getReplacement(keyName);
                            if (keyValue == null || replaced.contains(keyName)) {
                                out.append("${").append(keyName).append("}");
                                continue block21;
                            }
                            replaced.push(keyName);
                            out.append(Formats.replaceKeywords(keyValue, cb, replaced));
                            replaced.pop();
                            continue block21;
                        }
                    }
                    key.append(c);
                }
            }
        }
        switch (state) {
            case 1: {
                out.append('$');
                break;
            }
            case 2: {
                out.append("${").append((CharSequence)key);
            }
        }
        return out.toString();
    }

    public static String replaceKeywords(String in, Replaceable cb) {
        return Formats.replaceKeywords(in, cb, new Stack<String>());
    }

    public static boolean smatch(String pattern, String text) {
        int i;
        int pl = pattern.length();
        int tl = text.length();
        for (i = 0; i < pl && i < tl && pattern.charAt(i) != '*' && pattern.charAt(i) == text.charAt(i); ++i) {
        }
        if (i == pl && i == tl) {
            return true;
        }
        if (i == pl || i == tl) {
            return false;
        }
        return pattern.charAt(i) == '*';
    }

    public static boolean match(String condition, String subject) {
        if (condition.startsWith("*")) {
            int nextJoker = (condition = condition.substring(1)).indexOf("*");
            if (nextJoker == -1) {
                return Formats.endsWith(subject, condition);
            }
            String firstPart = condition.substring(0, nextJoker);
            int position = Formats.indexOf(subject, firstPart);
            if (position == -1) {
                return false;
            }
            condition = condition.substring(firstPart.length());
            subject = subject.substring(position + firstPart.length());
            return Formats.match(condition, subject);
        }
        int nextJoker = condition.indexOf("*");
        if (nextJoker == -1) {
            return Formats.equals(subject, condition);
        }
        String firstPart = condition.substring(0, nextJoker);
        if (!Formats.startsWith(subject, firstPart)) {
            return false;
        }
        condition = condition.substring(firstPart.length());
        subject = subject.substring(firstPart.length());
        return Formats.match(condition, subject);
    }

    private static boolean startsWith(String subject, String term) {
        int riddle;
        subject = subject.substring(0, term.length());
        while ((riddle = term.indexOf("?")) != -1) {
            term = Formats.removeChar(term, riddle);
            subject = Formats.removeChar(subject, riddle);
        }
        return Formats.equals(subject, term);
    }

    private static boolean endsWith(String subject, String term) {
        int riddle;
        if (subject.length() < term.length()) {
            return false;
        }
        subject = subject.substring(subject.length() - term.length());
        while ((riddle = term.indexOf("?")) != -1) {
            term = Formats.removeChar(term, riddle);
            subject = Formats.removeChar(subject, riddle);
        }
        return Formats.equals(subject, term);
    }

    private static int indexOf(String subject, String term) {
        if (subject.length() < term.length()) {
            return -1;
        }
        block0: for (int i = 0; i < subject.length() - term.length() + 1; ++i) {
            for (int j = 0; j < term.length(); ++j) {
                if (term.charAt(j) != subject.charAt(j + i) && term.charAt(j) != '?') continue block0;
            }
            return i;
        }
        return -1;
    }

    private static String removeChar(String str, int i) {
        str = str.substring(0, i) + str.substring(i + 1, str.length());
        return str;
    }

    private static boolean equals(String subject, String term) {
        int riddle;
        while ((riddle = term.indexOf("?")) != -1) {
            term = Formats.removeChar(term, riddle);
            subject = Formats.removeChar(subject, riddle);
        }
        return subject.equals(term);
    }
}

