/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSortedMap;
import dmg.cells.nucleus.CellShell;
import dmg.util.Args;
import dmg.util.Authorizable;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandPanicException;
import dmg.util.CommandRequestable;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.Interpretable;
import dmg.util.command.AcCommandScanner;
import dmg.util.command.AnnotatedCommandScanner;
import dmg.util.command.CommandExecutor;
import dmg.util.command.CommandScanner;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class CommandInterpreter
implements Interpretable {
    public static final int ASCII = 0;
    public static final int BINARY = 1;
    private static final CommandScanner[] SCANNERS = new CommandScanner[]{new AcCommandScanner(), new AnnotatedCommandScanner()};
    private final CommandEntry _rootEntry = new CommandEntry("");

    public CommandInterpreter() {
        this.addCommandListener(this);
    }

    public CommandInterpreter(Object commandListener) {
        this.addCommandListener(commandListener);
    }

    public synchronized void addCommandListener(Object commandListener) {
        for (CommandScanner scanner : SCANNERS) {
            Map<List<String>, ? extends CommandExecutor> commands = scanner.scan(commandListener);
            for (Map.Entry<List<String>, ? extends CommandExecutor> entry : commands.entrySet()) {
                CommandEntry currentEntry = this._rootEntry.getOrCreate(entry.getKey());
                if (currentEntry.hasCommand() && !(this instanceof CellShell)) {
                    throw new IllegalArgumentException("Conflicting implementations of shell command '" + Joiner.on((String)" ").join((Iterable)entry.getKey()) + "': " + currentEntry.getCommand() + " and " + entry.getValue());
                }
                currentEntry.setCommand(entry.getValue());
            }
        }
    }

    private String runHelp(Args args) {
        CommandEntry ce;
        CommandEntry entry = this._rootEntry;
        StringBuilder path = new StringBuilder();
        while (args.argc() > 0 && (ce = entry.get(args.argv(0))) != null) {
            path.append(ce.getName()).append(" ");
            args.shift();
            entry = ce;
        }
        String help = entry.getFullHelp();
        if (help == null) {
            StringBuilder sb = new StringBuilder();
            entry.dumpHelpHint(path.toString(), sb);
            help = sb.toString();
        }
        return help;
    }

    public String command(String str) throws CommandExitException {
        try {
            Serializable o = this.command(new Args(str));
            if (o == null) {
                return "";
            }
            return (String)((Object)o);
        }
        catch (CommandSyntaxException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Syntax Error : ").append(e.getMessage()).append("\n");
            String help = e.getHelpText();
            if (help != null) {
                sb.append("Help : \n");
                sb.append(help);
            }
            return sb.toString();
        }
        catch (CommandExitException e) {
            throw e;
        }
        catch (CommandThrowableException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(e.getMessage()).append("\n");
            Throwable t = e.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
            return sb.toString();
        }
        catch (CommandPanicException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Panic : ").append(e.getMessage()).append("\n");
            Throwable t = e.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
            return sb.toString();
        }
        catch (CommandException e) {
            return "??? : " + e.toString();
        }
    }

    public Serializable command(Args args) throws CommandException {
        return this.execute(args, 0);
    }

    public Serializable command(CommandRequestable request) throws CommandException {
        return this.execute(request, 1);
    }

    public Serializable execute(Object command, int methodType) throws CommandException {
        CommandEntry ce;
        Args args = methodType == 0 ? (Args)command : new Args(((CommandRequestable)command).getRequestCommand());
        if (args.argc() == 0) {
            return "";
        }
        if (args.argc() > 0 && args.argv(0).equals("help")) {
            args.shift();
            return this.runHelp(args);
        }
        if (args.argc() > 0 && args.argv(0).equals("xyzzy")) {
            return "Nothing happens.";
        }
        CommandEntry entry = this._rootEntry;
        CommandEntry lastAcl = null;
        StringBuilder path = new StringBuilder();
        while (args.argc() > 0 && (ce = entry.get(args.argv(0))) != null) {
            if (ce.hasACLs()) {
                lastAcl = ce;
            }
            path.append(ce.getName()).append(' ');
            entry = ce;
            args.shift();
        }
        if (command instanceof Authorizable && lastAcl != null) {
            String[] acls = lastAcl.getACLs();
            this.checkAclPermission((Authorizable)command, command, acls);
        }
        try {
            return entry.execute(command, methodType);
        }
        catch (CommandSyntaxException e) {
            if (methodType == 0 && e.getHelpText() == null) {
                StringBuilder sb = new StringBuilder();
                entry.dumpHelpHint(path.toString(), sb);
                e.setHelpText(sb.toString());
            }
            throw e;
        }
    }

    protected void checkAclPermission(Authorizable auth, Object command, String[] acls) throws CommandException {
    }

    private static class CommandEntry {
        private ImmutableSortedMap<String, CommandEntry> _suffixes = ImmutableSortedMap.of();
        private final String _name;
        private CommandExecutor _commandExecutor;

        CommandEntry(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void put(String str, CommandEntry e) {
            this._suffixes = ImmutableSortedMap.naturalOrder().putAll(this._suffixes).put((Object)str, (Object)e).build();
        }

        public CommandEntry get(String str) {
            return (CommandEntry)this._suffixes.get((Object)str);
        }

        public CommandEntry getOrCreate(String name) {
            CommandEntry entry = (CommandEntry)this._suffixes.get((Object)name);
            if (entry == null) {
                entry = new CommandEntry(name);
                this.put(name, entry);
            }
            return entry;
        }

        public CommandEntry getOrCreate(List<String> names) {
            CommandEntry entry = this;
            for (String name : names) {
                entry = entry.getOrCreate(name);
            }
            return entry;
        }

        public void setCommand(CommandExecutor commandExecutor) {
            this._commandExecutor = commandExecutor;
        }

        public CommandExecutor getCommand() {
            return this._commandExecutor;
        }

        boolean hasCommand() {
            return this._commandExecutor != null;
        }

        public boolean hasACLs() {
            return this._commandExecutor != null && this._commandExecutor.hasACLs();
        }

        public void dumpHelpHint(String top, StringBuilder sb) {
            String hint;
            if (this._commandExecutor != null && (hint = this._commandExecutor.getHelpHint()) != null) {
                sb.append(top).append(hint).append("\n");
            }
            for (CommandEntry ce : this._suffixes.values()) {
                ce.dumpHelpHint(top + ce.getName() + " ", sb);
            }
        }

        public Serializable execute(Object arguments, int methodType) throws CommandException {
            if (this._commandExecutor == null) {
                throw new CommandSyntaxException("Command not found");
            }
            return this._commandExecutor.execute(arguments, methodType);
        }

        public String getFullHelp() {
            return this._commandExecutor == null ? null : this._commandExecutor.getFullHelp();
        }

        public String[] getACLs() {
            return this._commandExecutor == null ? new String[]{} : this._commandExecutor.getACLs();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Entry : ").append(this.getName());
            for (String key : this._suffixes.keySet()) {
                sb.append(" -> ").append(key).append("\n");
            }
            return sb.toString();
        }
    }
}

