/*
 * Decompiled with CFR 0.152.
 */
package dmg.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class AgingHash {
    private int _maxSize;
    private Node _first;
    private Node _last;
    private Hashtable<Object, Node> _hash = new Hashtable();

    public synchronized void clear() {
        this._first = null;
        this._last = null;
        this._hash.clear();
    }

    public AgingHash(int maxSize) {
        this._maxSize = maxSize;
    }

    public synchronized Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("Key == null");
        }
        Node node = this._hash.get(key);
        if (node == null) {
            return null;
        }
        node.unlink();
        node.link();
        return node._value;
    }

    public synchronized void put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException("Key/Value == null");
        }
        Node node = this._hash.get(key);
        if (node == null) {
            node = new Node(key, value);
            this._hash.put(key, node);
        } else {
            node._value = value;
            node.unlink();
        }
        node.link();
        if (this._hash.size() > this._maxSize) {
            this._hash.remove(this._last._key);
            this._last.unlink();
        }
    }

    public int size() {
        return this._hash.size();
    }

    public synchronized Object remove(Object key) {
        Node node = this._hash.remove(key);
        if (node == null) {
            return null;
        }
        node.unlink();
        return node._value;
    }

    public synchronized Iterator<Node> valuesIterator() {
        return new ArrayList<Node>(this._hash.values()).iterator();
    }

    public synchronized Iterator<Object> keysIterator() {
        return new ArrayList<Object>(this._hash.keySet()).iterator();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        Node node = this._first;
        while (node != null) {
            sb.append(node.toString()).append(";");
            node = node._next;
        }
        sb.append("[").append(this._first).append(";").append(this._last).append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        AgingHash hash = new AgingHash(3);
        System.out.println(hash.toString());
        hash.put("1", "1");
        System.out.println(hash.toString());
        hash.put("2", "2");
        System.out.println(hash.toString());
        hash.put("3", "3");
        System.out.println(hash.toString());
        hash.put("4", "4");
        System.out.println(hash.toString());
        hash.put("5", "5");
        System.out.println(hash.toString());
        hash.remove("4");
        System.out.println(hash.toString());
        hash.remove("3");
        System.out.println(hash.toString());
        hash.remove("5");
        System.out.println(hash.toString());
    }

    private class Node {
        private Object _value;
        private Object _key;
        private Node _next;
        private Node _previous;

        private Node(Object key, Object value) {
            this._value = value;
            this._key = key;
        }

        public String toString() {
            return "(" + this._key + ":" + this._value + ")";
        }

        private void link() {
            this._next = AgingHash.this._first;
            this._previous = null;
            if (AgingHash.this._first != null) {
                ((AgingHash)AgingHash.this)._first._previous = this;
            }
            AgingHash.this._first = this;
            if (AgingHash.this._last == null) {
                AgingHash.this._last = this;
            }
        }

        private void unlink() {
            if (this._next != null) {
                this._next._previous = this._previous;
            } else {
                AgingHash.this._last = this._previous;
            }
            if (this._previous != null) {
                this._previous._next = this._next;
            } else {
                AgingHash.this._first = this._next;
            }
        }
    }
}

