/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher.rsa;

import dmg.security.cipher.EncryptionKey;
import java.math.BigInteger;

public class RsaEncryptionKey
implements EncryptionKey {
    String[] _domainList;
    String _mode;
    BigInteger _n;
    BigInteger _e;

    public RsaEncryptionKey(String[] domainList, String e, String n) {
        this(domainList, "public", new BigInteger(e, 10), new BigInteger(n, 10));
    }

    public RsaEncryptionKey(String[] domainList, String mode, String e, String n) {
        this(domainList, mode, new BigInteger(e, 16), new BigInteger(n, 16));
    }

    public BigInteger getModulus() {
        return this._n;
    }

    public BigInteger getExponent() {
        return this._e;
    }

    public RsaEncryptionKey(String[] domainList, String mode, BigInteger e, BigInteger n) {
        this._e = e;
        this._n = n;
        this._mode = mode;
        this._domainList = new String[domainList.length];
        System.arraycopy(domainList, 0, this._domainList, 0, domainList.length);
    }

    @Override
    public String[] getDomainList() {
        return this._domainList;
    }

    @Override
    public String getKeyType() {
        return "rsa";
    }

    @Override
    public String getKeyMode() {
        return this._mode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._mode.equals("public")) {
            sb.append(" ---  Rsa Public Key -- for ");
            if (this._domainList != null) {
                for (String domain : this._domainList) {
                    sb.append(domain);
                }
            }
            sb.append("\n");
            sb.append(" bit length = ").append(this._n.bitLength()).append("\n");
            sb.append("          n = ").append(this._n.toString(16)).append("\n");
            sb.append("          e = ").append(this._e.toString(16)).append("\n");
        } else if (this._mode.equals("private")) {
            sb.append(" ---  Rsa Private Key -- for ");
            if (this._domainList != null) {
                for (String domain : this._domainList) {
                    sb.append(domain);
                }
            }
            sb.append("\n");
            sb.append(" bit length = ").append(this._n.bitLength()).append("\n");
            sb.append(" n = ").append(this._n.toString(16)).append("\n");
            sb.append(" d = ").append(this._e.toString(16)).append("\n");
        }
        return sb.toString();
    }
}

