/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher;

import dmg.security.cipher.EncryptionKey;
import dmg.security.cipher.EncryptionKeyContainer;
import dmg.security.cipher.EncryptionKeyNotFoundException;
import dmg.security.cipher.IllegalEncryptionException;
import dmg.security.cipher.MixedKeyInputStream;
import dmg.security.cipher.StreamEncryption;
import dmg.security.cipher.StreamSecurity;
import dmg.security.cipher.idea.IdeaEncryptionKey;
import dmg.security.cipher.idea.IdeaStreamEncryption;
import dmg.security.cipher.rsa.RsaEncryptionKey;
import dmg.security.cipher.rsa.RsaStreamEncryption;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class GenericStreamSecurity
implements StreamSecurity {
    private EncryptionKeyContainer _keys = new EncryptionKeyContainer();

    public GenericStreamSecurity(String keyFile) throws IOException {
        this._keys.readInputStream(new MixedKeyInputStream(new FileInputStream(keyFile)));
    }

    @Override
    public StreamEncryption getEncryption(String domain) throws EncryptionKeyNotFoundException {
        String cipher;
        StringTokenizer st = new StringTokenizer(domain, ":");
        int tokens = st.countTokens();
        if (tokens < 2) {
            throw new EncryptionKeyNotFoundException("Invalid domain desc: " + domain);
        }
        switch (cipher = st.nextToken()) {
            case "idea": {
                String name = st.nextToken();
                EncryptionKey key = this._keys.get("shared", name);
                try {
                    return new IdeaStreamEncryption((IdeaEncryptionKey)key);
                }
                catch (Exception e) {
                    throw new EncryptionKeyNotFoundException("not shared : " + name);
                }
            }
            case "rsa": {
                if (tokens < 3) {
                    throw new EncryptionKeyNotFoundException("Invalid domain desc: " + domain);
                }
                String pubName = st.nextToken();
                String priName = st.nextToken();
                EncryptionKey pub = this._keys.get("public", pubName);
                EncryptionKey pri = this._keys.get("private", priName);
                try {
                    return new RsaStreamEncryption((RsaEncryptionKey)pub, (RsaEncryptionKey)pri);
                }
                catch (Exception e) {
                    throw new EncryptionKeyNotFoundException("not rsa : " + domain);
                }
            }
        }
        throw new EncryptionKeyNotFoundException("Unknown cipher type : " + cipher);
    }

    @Override
    public StreamEncryption getSessionEncryption() {
        return new IdeaStreamEncryption();
    }

    @Override
    public StreamEncryption getSessionEncryption(byte[] keyDescriptor) throws IllegalEncryptionException {
        return new IdeaStreamEncryption(keyDescriptor);
    }
}

