/*
 * Decompiled with CFR 0.152.
 */
package dmg.security.cipher;

import dmg.security.cipher.EncryptionKey;
import dmg.security.cipher.EncryptionKeyInputStream;
import dmg.security.cipher.EncryptionKeyNotFoundException;
import dmg.security.cipher.MixedKeyInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;

public class EncryptionKeyContainer {
    private Hashtable<String, EncryptionKey> _publicList = new Hashtable();
    private Hashtable<String, EncryptionKey> _sharedList = new Hashtable();
    private Hashtable<String, EncryptionKey> _privateList = new Hashtable();

    public synchronized void addKey(EncryptionKey key) {
        Hashtable<String, EncryptionKey> hash;
        String[] domains = key.getDomainList();
        String mode = key.getKeyMode();
        Hashtable<String, EncryptionKey> hashtable = mode.equals("public") ? this._publicList : (mode.equals("private") ? this._privateList : (hash = mode.equals("shared") ? this._sharedList : null));
        if (hash == null) {
            return;
        }
        for (String domain : domains) {
            hash.put(domain, key);
        }
    }

    public synchronized void readInputStream(EncryptionKeyInputStream stream) throws IOException {
        EncryptionKey key;
        while ((key = stream.readEncryptionKey()) != null) {
            this.addKey(key);
        }
    }

    public synchronized EncryptionKey get(String mode, String name) throws EncryptionKeyNotFoundException {
        EncryptionKey key;
        Hashtable<String, EncryptionKey> hash;
        Hashtable<String, EncryptionKey> hashtable = mode.equals("public") ? this._publicList : (mode.equals("private") ? this._privateList : (hash = mode.equals("shared") ? this._sharedList : null));
        if (hash == null) {
            key = this._publicList.get(name);
            if (key == null && (key = this._privateList.get(name)) == null && (key = this._sharedList.get(name)) != null) {
                return key;
            }
        } else {
            key = hash.get(name);
        }
        if (key == null) {
            throw new EncryptionKeyNotFoundException(name + " : not found");
        }
        return key;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("USAGE : ... <keyfilename> ");
            System.exit(4);
        }
        try {
            MixedKeyInputStream in = new MixedKeyInputStream(new FileInputStream(args[0]));
            EncryptionKeyContainer encryptionKeyContainer = new EncryptionKeyContainer();
        }
        catch (IOException e) {
            System.err.println(" Exception : " + e);
            System.exit(4);
        }
    }
}

