/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshPacket;
import dmg.security.cipher.StreamCipher;

public class SshStringPacket
extends SshPacket {
    String _string;
    byte[] _load;
    byte[] _binary;

    public SshStringPacket(StreamCipher cipher, byte[] data, int len) {
        super(cipher, data, len);
        byte[] payload = this.getPayload();
        this.convertString(payload, 0, payload.length);
    }

    public SshStringPacket(byte[] data, int len) {
        super(null, data, len);
        byte[] payload = this.getPayload();
        this.convertString(payload, 0, payload.length);
    }

    public SshStringPacket(SshPacket packet) {
        byte[] payload = packet.getPayload();
        this.convertString(payload, 0, payload.length);
    }

    public SshStringPacket(StreamCipher cipher, String str) {
        super(cipher);
        this._string = str;
        byte[] data = str.getBytes();
        int len = data.length;
        this._load = new byte[len + 4];
        this.punchInt(this._load, 0, len);
        System.arraycopy(data, 0, this._load, 4, data.length);
    }

    public SshStringPacket(StreamCipher cipher, byte[] binString, int off, int len) {
        super(cipher);
        this._load = new byte[len + 4];
        this.punchInt(this._load, 0, len);
        System.arraycopy(binString, 0, this._load, 4, len);
    }

    public SshStringPacket(byte[] binString, int off, int len) {
        super(null);
        this._load = new byte[len + 4];
        this.punchInt(this._load, 0, len);
        System.arraycopy(binString, 0, this._load, 4, len);
    }

    @Override
    public byte[] toByteArray() {
        return this.makePacket(this._load);
    }

    @Override
    public byte[] toByteArray(StreamCipher cipher) {
        return this.makePacket(cipher, this._load);
    }

    private void convertString(byte[] payload, int off, int len) {
        if (len < 4) {
            throw new IllegalArgumentException("String arg. too short");
        }
        int l = (payload[off + 0] & 0xFF) << 24 | (payload[off + 1] & 0xFF) << 16 | (payload[off + 2] & 0xFF) << 8 | payload[off + 3] & 0xFF;
        if (l <= 0) {
            this._binary = new byte[0];
        } else {
            this._binary = new byte[l];
            System.arraycopy(payload, off + 4, this._binary, 0, l);
        }
    }

    public String getString() {
        return new String(this._binary);
    }

    public byte[] getBinary() {
        return this._binary;
    }

    public String toString() {
        return this.getString();
    }
}

