/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ssh;

import dmg.protocols.ssh.SshCmsgStdinData;
import dmg.protocols.ssh.SshPacket;
import dmg.protocols.ssh.SshProtocolException;
import dmg.protocols.ssh.SshSmsgExitStatus;
import dmg.protocols.ssh.SshSmsgStdoutData;
import dmg.security.cipher.StreamCipher;
import dmg.security.cipher.StreamFromBlockCipher;
import dmg.security.cipher.blowfish.Jblowfish;
import dmg.security.cipher.des.Jdes;
import dmg.security.cipher.idea.Jidea;
import dmg.util.DummyStreamEngine;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCoreEngine {
    private static final Logger _log = LoggerFactory.getLogger(SshCoreEngine.class);
    private DataInputStream _input;
    private OutputStream _output;
    private DummyStreamEngine _engine;
    private StreamCipher _inCipher;
    private StreamCipher _outCipher;
    protected static final int SSH_CIPHER_NONE = 0;
    protected static final int SSH_CIPHER_IDEA = 1;
    protected static final int SSH_CIPHER_DES = 2;
    protected static final int SSH_CIPHER_BLOWFISH = 6;
    protected static final int SSH_CIPHER_MASK_IDEA = 2;
    protected static final int SSH_CIPHER_MASK_DES = 4;
    protected static final int SSH_CIPHER_MASK_BLOWFISH = 64;
    protected static final int SSH_AUTH_RSA = 4;
    protected static final int SSH_AUTH_PASSWORD = 8;
    protected static final int SSH_AUTH_RHOSTS_RSA = 16;

    protected SshCoreEngine(Socket socket) {
        this._engine = new DummyStreamEngine(socket);
        this._input = new DataInputStream(new BufferedInputStream(this._engine.getInputStream()));
        this._output = this._engine.getOutputStream();
    }

    public void sendStdout(byte[] data, int off, int size) throws IOException {
        this.writePacket(new SshSmsgStdoutData(data, off, size));
    }

    public void sendStderr(byte[] data, int off, int size) throws IOException {
        this.writePacket(new SshSmsgStdoutData(data, off, size));
    }

    public void sendStdin(byte[] data, int off, int size) throws IOException {
        this.writePacket(new SshCmsgStdinData(data, off, size));
    }

    public void finish(int reason) throws IOException {
        _log.debug("Sending 'SshSmsgExitStatus' to client ");
        this.writePacket(new SshSmsgExitStatus(reason));
    }

    protected void setCiphers(StreamCipher inCipher, StreamCipher outCipher) {
        this._inCipher = inCipher;
        this._outCipher = outCipher;
    }

    synchronized void writePacket(SshPacket packet) throws IOException {
        this._output.write(packet.toByteArray(this._outCipher));
        this._output.flush();
    }

    protected void writeString(String str) throws IOException {
        this._output.write(str.getBytes());
        this._output.flush();
    }

    protected SshPacket readPacket() throws IOException {
        SshPacket sshPacket = null;
        try {
            int leng = this._input.readInt();
            if (leng > 131072) {
                throw new SshProtocolException("Packet size too large : " + leng);
            }
            byte[] data = new byte[leng + (8 - leng % 8)];
            this._input.readFully(data);
            sshPacket = new SshPacket(this._inCipher, data, leng);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return sshPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPacketAvailable() throws IOException {
        if (this._input.available() >= 4) {
            this._input.mark(4);
            try {
                int len = this._input.readInt();
                if (this._input.available() >= len + (8 - len % 8)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this._input.reset();
            }
        }
        return false;
    }

    protected String readVersionString() throws SshProtocolException {
        int i;
        byte[] inBytes = new byte[64];
        int c = 0;
        try {
            for (i = 0; i < inBytes.length && (c = this._input.read()) >= 0; ++i) {
                inBytes[i] = (byte)c;
                if (inBytes[i] != 10) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new SshProtocolException("IO : " + e);
        }
        if (i == inBytes.length || c < 0) {
            throw new SshProtocolException("Ssh Protocol violation in reading Version");
        }
        return new String(inBytes, 0, i);
    }

    protected boolean setEncryption(int cipherType, byte[] sessionKey) {
        StreamFromBlockCipher outCipher;
        StreamFromBlockCipher inCipher;
        if (cipherType == 1) {
            _log.debug("Cipher is idea");
            byte[] vector = new byte[8];
            byte[] ideakey = new byte[16];
            System.arraycopy(sessionKey, 0, ideakey, 0, 16);
            inCipher = new StreamFromBlockCipher(new Jidea(ideakey), vector, "cfb");
            outCipher = new StreamFromBlockCipher(new Jidea(ideakey), vector, "cfb");
            _log.debug("Cipher created");
        } else if (cipherType == 6) {
            _log.debug("Cipher is blowfish");
            byte[] vector = new byte[8];
            byte[] ideakey = new byte[32];
            System.arraycopy(sessionKey, 0, ideakey, 0, ideakey.length);
            _log.debug("key: {}", (Object)SshCoreEngine.byteToHexString(ideakey));
            inCipher = new StreamFromBlockCipher(new Jblowfish(ideakey), vector, "cbc");
            outCipher = new StreamFromBlockCipher(new Jblowfish(ideakey), vector, "cbc");
            _log.debug("Ciphers created");
        } else if (cipherType == 2) {
            _log.debug("Cipher is des");
            byte[] vector = new byte[8];
            byte[] ideakey = new byte[8];
            System.arraycopy(sessionKey, 0, ideakey, 0, ideakey.length);
            inCipher = new StreamFromBlockCipher(new Jdes(ideakey), vector, "cbc");
            outCipher = new StreamFromBlockCipher(new Jdes(ideakey), vector, "cbc");
            _log.debug("Ciphers created");
        } else {
            _log.error("Cipher not excepted (exit) {}", (Object)cipherType);
            return false;
        }
        this.setCiphers(inCipher, outCipher);
        return true;
    }

    public static String byteToHexString(byte b) {
        String s = Integer.toHexString(b < 0 ? 256 + b : b);
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    public static String byteToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length + 1);
        for (byte aByte : bytes) {
            sb.append(SshCoreEngine.byteToHexString(aByte)).append(" ");
        }
        return sb.toString();
    }
}

