/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpEvent;
import dmg.protocols.snmp.SnmpEventListener;
import dmg.protocols.snmp.SnmpInteger;
import dmg.protocols.snmp.SnmpOID;
import dmg.protocols.snmp.SnmpOctetString;
import dmg.protocols.snmp.SnmpRequest;
import dmg.protocols.snmp.SnmpServer;
import java.net.SocketException;

public class SnmpServerTest
implements SnmpEventListener {
    SnmpServerTest(int port) throws SocketException {
        SnmpServer server = new SnmpServer(port);
        server.addSnmpEventListener(this);
    }

    @Override
    public SnmpRequest snmpEventArrived(SnmpEvent event) {
        SnmpRequest request = event.getSnmpRequest();
        String communityString = request.getCommunity().toString();
        int count = request.varBindListSize();
        int type = request.getRequestType();
        this.say("Request from " + event.getSourceAddress());
        this.say("Community :  " + communityString);
        this.say("Count     :  " + count);
        this.say("Type      :  " + type);
        if (!communityString.equals("public")) {
            return null;
        }
        SnmpRequest response = new SnmpRequest(new SnmpOctetString("public"), new SnmpInteger(request.getRequestID().longValue()), new SnmpInteger(0L), new SnmpInteger(0L));
        this.say("response\n" + response);
        for (int i = 0; i < count; ++i) {
            SnmpOID oid = request.varBindOIDAt(i);
            if (type == 161) {
                int[] vector = oid.getVector();
                int n = vector.length - 1;
                vector[n] = vector[n] + 1;
                oid = new SnmpOID(vector);
            }
            response.addVarBind(oid, new SnmpOctetString("Cell OS 4.3 " + oid));
        }
        return response;
    }

    private void say(String str) {
        System.out.println(str);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println(" USAGE : SnmpServerTest <port>");
            System.exit(4);
        }
        try {
            new SnmpServerTest(new Integer(args[0]));
        }
        catch (Exception e) {
            System.err.println("Exception ; " + e);
            System.exit(4);
        }
    }
}

