/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.snmp;

import dmg.protocols.snmp.SnmpEvent;
import dmg.protocols.snmp.SnmpEventListener;
import dmg.protocols.snmp.SnmpObject;
import dmg.protocols.snmp.SnmpRequest;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Vector;

public class SnmpServer
implements Runnable {
    Vector<SnmpEventListener> _actionListener = new Vector();
    int _port;
    DatagramSocket _socket;
    Thread _listenThread;

    public SnmpServer(int port) throws SocketException {
        this._port = port;
        this._socket = new DatagramSocket(port);
        this._listenThread = new Thread(this);
        this._listenThread.start();
    }

    public void addSnmpEventListener(SnmpEventListener listener) {
        this._actionListener.addElement(listener);
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._listenThread) {
            while (true) {
                try {
                    block3: while (true) {
                        byte[] b = new byte[2048];
                        DatagramPacket p = new DatagramPacket(b, b.length);
                        this._socket.receive(p);
                        SnmpObject snmp = SnmpObject.generate(p.getData(), 0, p.getLength());
                        SnmpRequest request = new SnmpRequest(snmp);
                        SnmpEvent event = new SnmpEvent(p.getAddress(), request);
                        Iterator<SnmpEventListener> iterator = this._actionListener.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            SnmpEventListener listener = iterator.next();
                            SnmpRequest answer = listener.snmpEventArrived(event);
                            if (answer == null) {
                                System.out.println("Answer discarded");
                                continue;
                            }
                            byte[] x = answer.getSnmpBytes();
                            DatagramPacket dp = new DatagramPacket(x, x.length, p.getAddress(), p.getPort());
                            System.out.println("Sending " + x.length + " bytes to " + p.getAddress() + ":" + p.getPort());
                            this._socket.send(dp);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error while sending : " + e);
                    continue;
                }
                break;
            }
        }
    }
}

