/*
 * Decompiled with CFR 0.152.
 */
package dmg.protocols.ber;

import dmg.protocols.ber.BerContainer;
import dmg.protocols.ber.BerObject;

public class BerFrame {
    private BerObject _object;
    private int _headerSize;
    private int _payloadSize;
    private int _klass;
    private boolean _isPrimitive = true;
    private int _tag;
    private int _type;

    BerFrame(BerObject obj, int headerSize, int payloadSize) {
        this._object = obj;
        this._headerSize = headerSize;
        this._payloadSize = payloadSize;
    }

    public BerObject getObject() {
        return this._object;
    }

    public void setObject(BerObject obj) {
        this._object = obj;
    }

    public BerContainer getContainer() {
        return (BerContainer)this._object;
    }

    public int getHeaderSize() {
        return this._headerSize;
    }

    public int getPayloadSize() {
        return this._payloadSize;
    }

    public int getBerType() {
        return this._type;
    }

    public int getBerClass() {
        return this._klass;
    }

    public boolean isPrimitive() {
        return this._isPrimitive;
    }

    public int getBerTag() {
        return this._tag;
    }

    public BerFrame(byte[] data, int off, int maxSize) {
        this._type = data[off++];
        int meta = 0;
        this._type = this._type < 0 ? this._type + 256 : this._type;
        this._klass = this._type >> 6 & 3;
        this._isPrimitive = (this._type >> 5 & 1) == 0;
        this._tag = this._type & 0x1F;
        ++meta;
        int highSize = data[off++];
        ++meta;
        highSize = highSize < 0 ? highSize + 256 : highSize;
        int size = 0;
        if ((highSize & 0x80) != 0) {
            int octects = highSize & 0x7F;
            for (int i = 0; i < octects; ++i) {
                int d = data[off++];
                ++meta;
                d = d < 0 ? d + 256 : d;
                size <<= 8;
                size += d;
            }
        } else {
            size = highSize & 0x7F;
        }
        this._payloadSize = size;
        this._headerSize = meta;
    }
}

