/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.multicaster;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.multicaster.MulticastClose;
import dmg.cells.services.multicaster.MulticastMessage;
import dmg.cells.services.multicaster.MulticastOpen;
import dmg.cells.services.multicaster.MulticastRegister;
import dmg.cells.services.multicaster.MulticastUnregister;
import dmg.util.Args;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastCommander
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(MulticastCommander.class);
    private CellNucleus _nucleus;
    private Args _args;
    private CellPath _path = new CellPath("mc");
    public static final String hh_set_path = "<MulticastCell>";
    public static final String hh_register = "<className> <instanceName>";
    public static final String hh_send = "<className> <instanceName> <message>";
    public static final String hh_close = "<className> <instanceName>";
    public static final String hh_unregister = "<className> <instanceName>";
    public static final String hh_open = "<className> <instanceName> [<detail>] [-overwrite]";

    public MulticastCommander(String name, String args) {
        super(name, args, false);
        this._nucleus = this.getNucleus();
        this._args = this.getArgs();
        this.start();
    }

    @Override
    public void messageToForward(CellMessage msg) {
        CellPath source = msg.getSourcePath();
        msg.nextDestination();
        try {
            this.sendMessage(msg);
        }
        catch (NoRouteToCellException nrtc) {
            _log.warn("NoRouteToCell in messageToForward : " + nrtc);
            _log.warn("Sending NoRouteToCellt to : " + source);
            try {
                this.sendMessage(new CellMessage(source.revert(), nrtc));
            }
            catch (Exception ee) {
                _log.warn("can't return NoRouteToCell to : " + source);
            }
        }
        catch (Exception eee) {
            _log.warn("Exception in messageToForward : " + eee);
        }
    }

    public String ac_set_path_$_1(Args args) {
        this._path = new CellPath(args.argv(0));
        return "";
    }

    public String ac_register_$_2(Args args) throws Exception {
        String className = args.argv(0);
        String instanceName = args.argv(1);
        MulticastRegister register = new MulticastRegister(className, instanceName);
        CellMessage thisMsg = MulticastCommander.getThisMessage();
        thisMsg.getDestinationPath().add(this._path);
        thisMsg.nextDestination();
        thisMsg.setMessageObject(register);
        this.sendMessage(thisMsg);
        return "";
    }

    public String ac_send_$_3(Args args) throws Exception {
        String className = args.argv(0);
        String instanceName = args.argv(1);
        String info = args.argv(2);
        MulticastMessage message = new MulticastMessage(className, instanceName, (Serializable)((Object)info));
        CellMessage thisMsg = MulticastCommander.getThisMessage();
        thisMsg.getDestinationPath().add(this._path);
        thisMsg.nextDestination();
        thisMsg.setMessageObject(message);
        this.sendMessage(thisMsg);
        return "";
    }

    public String ac_close_$_2(Args args) throws Exception {
        String className = args.argv(0);
        String instanceName = args.argv(1);
        MulticastClose close = new MulticastClose(className, instanceName);
        this.sendMessage(new CellMessage(this._path, close));
        return "";
    }

    public String ac_unregister_$_2(Args args) throws Exception {
        String className = args.argv(0);
        String instanceName = args.argv(1);
        MulticastUnregister unreg = new MulticastUnregister(className, instanceName);
        this.sendMessage(new CellMessage(this._path, unreg));
        return "";
    }

    public String ac_open_$_2_3(Args args) throws Exception {
        String className = args.argv(0);
        String instanceName = args.argv(1);
        String detail = args.argc() == 2 ? null : args.argv(2);
        boolean overwrite = args.hasOption("overwrite");
        MulticastOpen open = new MulticastOpen(className, instanceName, (Serializable)((Object)detail));
        open.setOverwrite(overwrite);
        CellMessage thisMsg = MulticastCommander.getThisMessage();
        thisMsg.getDestinationPath().add(this._path);
        thisMsg.nextDestination();
        thisMsg.setMessageObject(open);
        CellMessage reply = this.sendAndWait(thisMsg, 5000L);
        if (reply == null) {
            return "Reply timed out";
        }
        return reply.getMessageObject().toString();
    }
}

