/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.util.AclException;
import dmg.util.Authorizable;
import dmg.util.PermissionCheckable;
import java.io.Serializable;

public class RemotePermission
implements PermissionCheckable {
    private CellAdapter _cell;
    private CellPath _path;
    private long _timeout = 5000L;

    public RemotePermission(CellAdapter cell, CellPath path) {
        this._cell = cell;
        this._path = path;
    }

    @Override
    public void checkPermission(Authorizable auth, String aclName) throws AclException {
        CellMessage reply;
        Object[] request = new Object[]{"request", "<nobody>", "check-permission", auth.getAuthorizedPrincipal(), aclName};
        try {
            reply = this._cell.sendAndWait(new CellMessage(this._path, (Serializable)request), this._timeout);
            if (reply == null) {
                throw new AclException("Request timed out (" + this._path + ")");
            }
        }
        catch (Exception ee) {
            throw new AclException("Problem : " + ee.getMessage());
        }
        Serializable r = reply.getMessageObject();
        if (r == null || !(r instanceof Object[]) || ((Object[])r).length < 6 || !(((Object[])r)[5] instanceof Boolean)) {
            throw new AclException("Protocol violation 4456");
        }
        if (!((Boolean)((Object[])r)[5]).booleanValue()) {
            throw new AclException(auth, aclName);
        }
    }
}

