/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellShell;
import dmg.cells.services.login.user.AclPermissionException;
import dmg.util.Args;
import dmg.util.AuthorizedString;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandInterpreter;
import dmg.util.CommandPanicException;
import dmg.util.CommandThrowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalAdminShell
extends CommandInterpreter {
    private static final Logger _log = LoggerFactory.getLogger(MinimalAdminShell.class);
    private CellNucleus _nucleus;
    private String _user;
    private CellPath _cellPath;
    private CellShell _cellShell;
    private String _destination;
    private String _prompt = " >> ";
    public static final String hh_show_all = "exception|null|object|string|exit";
    public static final String hh_send = "<destinationCell> <message>";
    public static final String hh_loadshell = "<fullShellClassName>|system";

    public MinimalAdminShell(String user, CellNucleus nucleus, Args args) {
        this._nucleus = nucleus;
        this._user = user;
        for (int i = 0; i < args.argc(); ++i) {
            _log.info("arg[" + i + "]=" + args.argv(i));
        }
        if (args.argc() > 0 && args.argv(0).equals("kill")) {
            throw new IllegalArgumentException("hallo du da");
        }
    }

    protected String getUser() {
        return this._user;
    }

    private void checkPrivileges(String user, String className, String instanceName, String action) throws AclPermissionException {
        String acl = className + "." + instanceName + "." + action;
        _log.info("requesting acl {" + acl + "} for user " + user);
        if (!user.equals("patrick")) {
            throw new AclPermissionException("Permission denied (" + acl + ") for " + user);
        }
    }

    public Object executeCommand(String str) throws Exception {
        _log.info("String command " + str);
        Object or = this.executeLocalCommand(new Args(str));
        if (or == null) {
            return this._prompt;
        }
        String r = or.toString();
        if (r.length() < 1) {
            return "";
        }
        if (r.substring(r.length() - 1).equals("\n")) {
            return r;
        }
        return r + "\n";
    }

    public String getPrompt() {
        return this._prompt;
    }

    public Object executeCommand(Object obj) throws Exception {
        _log.info("Object command " + obj);
        String command = obj.toString();
        Args args = new Args(command);
        if (args.argc() == 0) {
            return null;
        }
        return this.executeLocalCommand(args);
    }

    protected Object sendCommand(String destination, String command) throws Exception {
        CellPath cellPath = new CellPath(destination);
        CellMessage res = this._nucleus.sendAndWait(new CellMessage(cellPath, new AuthorizedString(this._user, command)), 10000L);
        if (res == null) {
            throw new Exception("Request timed out");
        }
        return res.getMessageObject();
    }

    protected Object executeLocalCommand(Args args) throws Exception {
        _log.info("Loacal command " + args);
        try {
            return this.command(args);
        }
        catch (CommandThrowableException cte) {
            throw (Exception)cte.getTargetException();
        }
        catch (CommandPanicException cpe) {
            throw (Exception)cpe.getTargetException();
        }
    }

    public Object ac_show_all_$_1(Args args) throws Exception {
        String command = args.argv(0);
        _log.info("show all : mode=" + command + ";user=" + this._user);
        if (command.equals("exception")) {
            throw new Exception("hallo otto");
        }
        if (command.equals("null")) {
            return null;
        }
        if (command.equals("object")) {
            return args;
        }
        if (command.equals("exit")) {
            throw new CommandExitException("$exit$");
        }
        return "Done";
    }

    public Object ac_logoff(Args args) throws CommandException {
        throw new CommandExitException("Done", 0);
    }

    public Object ac_send_$_2(Args args) throws Exception {
        return this.sendCommand(args.argv(0), args.argv(1));
    }

    public Object ac_loadshell_$_1(Args args) throws Exception {
        if (!args.argv(0).equals("system")) {
            throw new CommandException("Only system is currently supported");
        }
        this.checkPrivileges(this._user, "shells", "system", "execute");
        this._cellShell = new CellShell(this._nucleus);
        this.addCommandListener(this._cellShell);
        return "System Shell installed";
    }
}

