/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login.user;

import java.util.Hashtable;

public class AgingHash {
    private int _maxSize;
    private Node _first;
    private Node _last;
    private Hashtable<Object, Node> _hash = new Hashtable();

    public AgingHash(int maxSize) {
        this._maxSize = maxSize;
    }

    public synchronized Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key == null");
        }
        Node node = this._hash.get(key);
        if (node == null) {
            return null;
        }
        this.unlink(node);
        this.link(node);
        return node.value;
    }

    public synchronized void put(Object key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key/Value == null");
        }
        Node node = this._hash.get(key);
        if (node == null) {
            node = new Node(key, value);
            this._hash.put(key, node);
        } else {
            node.value = value;
            this.unlink(node);
        }
        this.link(node);
        if (this._hash.size() > this._maxSize) {
            this._hash.remove(this._last.key);
            this.unlink(this._last);
        }
    }

    public synchronized Object remove(Object key) {
        Node node = this._hash.remove(key);
        if (node == null) {
            return null;
        }
        this.unlink(node);
        return node.value;
    }

    private void link(Node node) {
        node.next = this._first;
        node.previous = null;
        if (this._first != null) {
            this._first.previous = node;
        }
        this._first = node;
        if (this._last == null) {
            this._last = node;
        }
    }

    private void unlink(Node node) {
        if (node.next != null) {
            node.next.previous = node.previous;
        } else {
            this._last = node.previous;
        }
        if (node.previous != null) {
            node.previous.next = node.next;
        } else {
            this._first = node.next;
        }
    }

    public String display() {
        StringBuilder sb = new StringBuilder();
        Node node = this._first;
        while (node != null) {
            sb.append(node.toString()).append(";");
            node = node.next;
        }
        sb.append("[").append(this._first).append(";").append(this._last).append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        AgingHash hash = new AgingHash(3);
        System.out.println(hash.display());
        hash.put("1", "1");
        System.out.println(hash.display());
        hash.put("2", "2");
        System.out.println(hash.display());
        hash.put("3", "3");
        System.out.println(hash.display());
        hash.put("4", "4");
        System.out.println(hash.display());
        hash.put("5", "5");
        System.out.println(hash.display());
        hash.remove("4");
        System.out.println(hash.display());
        hash.remove("3");
        System.out.println(hash.display());
        hash.remove("5");
        System.out.println(hash.display());
    }

    private class Node {
        private Object value;
        private Object key;
        private Node next;
        private Node previous;

        private Node(Object key, Object value) {
            this.value = value;
            this.key = key;
        }

        public String toString() {
            return "(" + this.key + ":" + this.value + ")";
        }
    }
}

