/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.services.login.UserHandle;
import dmg.cells.services.login.UserPrivileges;
import dmg.util.cdb.CdbDirectoryContainer;
import dmg.util.cdb.CdbException;
import dmg.util.cdb.CdbFileRecord;
import dmg.util.cdb.CdbGLock;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;

public class UserDb
extends CdbGLock {
    private CdbDirectoryContainer _userContainer;

    public static void main(String[] args) throws Exception {
        UserDb _db;
        try {
            _db = new UserDb(new File("."), true);
        }
        catch (Exception e) {
            _db = new UserDb(new File("."), false);
        }
        if (args.length < 2) {
            System.err.println("USAGE : ... create-user <user>");
            System.err.println("            destroy-user <user>");
            System.err.println("            add-user <group> <user>");
            System.err.println("            create-group <group>");
            System.err.println("            rm-user <group> <user>");
            System.err.println("            show-user <user>");
            System.err.println("            set-password <user> <password>");
            System.err.println("            add-priv p|n <user> <privilege>");
            System.err.println("            rm-priv  <user> <privilege>");
            System.err.println("            get-parents <user>");
            System.err.println("            isallowed <user> <privilege>");
            System.exit(4);
        }
        try {
            switch (args[0]) {
                case "create-user": {
                    _db.createUser(args[1]);
                    break;
                }
                case "create-group": {
                    _db.createGroup(args[1]);
                    break;
                }
                case "destroy-user": {
                    _db.destroyUser(args[1]);
                    break;
                }
                case "show-user": {
                    UserHandle user = _db.getUserByName(args[1]);
                    System.out.println(user.toString());
                    System.out.println("Global prives : ");
                    System.out.println(_db.getUserPrivileges(args[1]).toString());
                    break;
                }
                case "get-parents": {
                    long start = System.currentTimeMillis();
                    String[] parents = _db.getAllParents(args[1]);
                    long diff = System.currentTimeMillis() - start;
                    for (String parent : parents) {
                        System.out.println(parent);
                    }
                    System.out.println("(Time=" + diff + " millis)");
                    break;
                }
                case "add-user": {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("add-user <group> <user>");
                    }
                    _db.addUser(args[1], args[2]);
                    break;
                }
                case "rm-user": {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("add-user <group> <user>");
                    }
                    _db.addUser(args[1], args[2]);
                    break;
                }
                case "set-password": {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("set-password <user> <passwd>");
                    }
                    UserHandle user = _db.getUserByName(args[1]);
                    user.open(2);
                    user.setPassword(args[2]);
                    user.close(8);
                    break;
                }
                case "isallowed": {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("isallowed <user> <privileged>");
                    }
                    UserPrivileges priv = _db.getUserPrivileges(args[1]);
                    System.out.println("Result : " + priv.isAllowed(args[2]));
                    break;
                }
                case "add-priv": {
                    if (args.length < 4 || !args[1].equals("p") && !args[1].equals("n")) {
                        throw new IllegalArgumentException("add-priv p|n <user> <privilege>");
                    }
                    UserHandle user = _db.getUserByName(args[2]);
                    user.open(2);
                    if (args[1].equals("p")) {
                        user.addAllowed(args[3]);
                    } else {
                        user.addDenied(args[3]);
                    }
                    user.close(8);
                    break;
                }
                case "rm-priv": {
                    if (args.length < 3) {
                        throw new IllegalArgumentException("rm-priv <user> <privilege>");
                    }
                    UserHandle user = _db.getUserByName(args[1]);
                    user.open(2);
                    user.removeAllowed(args[2]);
                    user.removeDenied(args[2]);
                    user.close(8);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Command not known : " + args[0]);
                }
            }
        }
        catch (Exception eeee) {
            System.out.println(eeee.getMessage());
        }
    }

    public UserDb(File file, boolean create) throws CdbException {
        if (!file.isDirectory()) {
            throw new CdbException("Database doesn't exits : " + file);
        }
        this._userContainer = new CdbDirectoryContainer(this, CdbFileRecord.class, UserHandle.class, new File(file, "users"), create);
    }

    public void destroyUser(String userName) throws Exception {
        String[] parents;
        UserHandle user = this.getUserByName(userName);
        user.open(1);
        boolean isGroup = user.isGroup();
        String[] childs = user.getChilds();
        user.close(8);
        if (isGroup && childs.length > 0) {
            throw new IllegalArgumentException("group not empty : " + userName);
        }
        user.open(2);
        for (String parent : parents = user.getParents()) {
            UserHandle x = this.getUserByName(parent);
            x.open(2);
            x.removeChild(userName);
            x.close(8);
            user.removeParent(parent);
        }
        user.close(8);
        this._userContainer.removeElement(userName);
    }

    public void removeUser(String groupName, String userName) throws Exception {
        UserHandle user = this.getUserByName(userName);
        UserHandle group = this.getUserByName(groupName);
        group.open(1);
        boolean isGroup = group.isGroup();
        group.close(8);
        if (!isGroup) {
            throw new IllegalArgumentException("Not a group : " + groupName);
        }
        group.open(2);
        group.removeChild(userName);
        group.close(8);
        try {
            user.open(2);
            user.removeParent(groupName);
            user.close(8);
        }
        catch (Exception ee) {
            group.open(2);
            group.addChild(userName);
            group.close(8);
            throw ee;
        }
    }

    private String[] getAllParents(String userName) throws Exception {
        UserHandle user = this.getUserByName(userName);
        user.open(1);
        String[] parents = user.getParents();
        user.close(8);
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (String parent : parents) {
            String[] x;
            hash.put(parent, parent);
            for (String aX : x = this.getAllParents(parent)) {
                hash.put(aX, aX);
            }
        }
        String[] result = new String[hash.size()];
        Iterator iterator = hash.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            result[i] = (String)iterator.next();
            ++i;
        }
        return result;
    }

    public UserPrivileges getUserPrivileges(String userName) throws Exception {
        UserHandle user;
        try {
            user = this.getUserByName(userName);
        }
        catch (Exception ee) {
            return new UserPrivileges(userName);
        }
        user.open(1);
        String[] parents = user.getParents();
        UserPrivileges myPrivs = user.getUserPrivileges();
        user.close(8);
        UserPrivileges upper = new UserPrivileges();
        for (String parent : parents) {
            upper.mergeHorizontal(this.getUserPrivileges(parent));
        }
        myPrivs.mergeVertical(upper);
        return myPrivs;
    }

    public void addUser(String groupName, String userName) throws Exception {
        int i;
        UserHandle user = this.getUserByName(userName);
        UserHandle group = this.getUserByName(groupName);
        String[] parents = this.getAllParents(groupName);
        for (i = 0; i < parents.length && !parents[i].equals(userName); ++i) {
        }
        if (i < parents.length) {
            throw new IllegalArgumentException("would create loop >" + groupName + "-" + userName + "<");
        }
        group.open(1);
        boolean isGroup = group.isGroup();
        String[] childs = group.getChilds();
        group.close(8);
        if (!isGroup) {
            throw new IllegalArgumentException("Not a group : " + groupName);
        }
        group.open(2);
        try {
            group.addChild(userName);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        finally {
            group.close(8);
        }
        try {
            user.open(2);
            user.addParent(groupName);
            user.close(8);
        }
        catch (Exception ee) {
            group.open(2);
            group.removeChild(userName);
            group.close(8);
            throw ee;
        }
    }

    public UserHandle createUser(String name) throws CdbException, InterruptedException {
        return this.createUser(name, false);
    }

    public UserHandle createGroup(String name) throws CdbException, InterruptedException {
        return this.createUser(name, true);
    }

    public UserHandle createUser(String name, boolean isGroup) throws CdbException, InterruptedException {
        UserHandle user = (UserHandle)this._userContainer.createElement(name);
        user.open(2);
        user.setAttribute("e-mail", "unknown");
        user.setAttribute("password", "*");
        user.setAttribute("allowed", new String[0]);
        user.setAttribute("denied", new String[0]);
        user.setAttribute("parents", new String[0]);
        if (isGroup) {
            user.setAttribute("mode", "group");
            user.setAttribute("childs", new String[0]);
        } else {
            user.setAttribute("mode", "user");
        }
        user.close(8);
        return user;
    }

    public String[] getUserNames() {
        return this._userContainer.getElementNames();
    }

    public UserHandle getUserByName(String name) throws CdbException, InterruptedException {
        return (UserHandle)this._userContainer.getElementByName(name);
    }
}

