/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellShell;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandInterpreter;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAdminLoginCell
extends CommandInterpreter {
    private static final Logger _log = LoggerFactory.getLogger(UserAdminLoginCell.class);
    private CellNucleus _nucleus;
    private String _user;
    private CellPath _cellPath;
    private CellShell _cellShell;
    private String _prompt = " >> ";

    public UserAdminLoginCell(String user, CellNucleus nucleus, Args args) {
        this._nucleus = nucleus;
        this._user = user;
        for (int i = 0; i < args.argc(); ++i) {
            _log.info("arg[" + i + "]=" + args.argv(i));
        }
        if (args.argc() > 0 && args.argv(0).equals("kill")) {
            throw new IllegalArgumentException("hallo du da");
        }
        if (this.checkPrivileges(user, "exec-shell", "system", "*")) {
            this._cellShell = new CellShell(this._nucleus);
            this.addCommandListener(this._cellShell);
            _log.info("Shell installed");
        } else {
            _log.info("Installation of Shell not permitted");
        }
    }

    private boolean checkPrivileges(String user, String action, String className, String instanceName) {
        Object[] request = new Object[]{"request", this._user, "check-acl", user, action, className, instanceName};
        try {
            CellPath acm = new CellPath("acm");
            CellMessage msg = new CellMessage(acm, (Serializable)request);
            msg = this._nucleus.sendAndWait(msg, 4000L);
            if (msg == null) {
                return false;
            }
            Serializable r = msg.getMessageObject();
            if (!(r instanceof Object[]) || ((Object[])r).length < 8) {
                return false;
            }
            return (Boolean)((Object[])r)[7];
        }
        catch (NoRouteToCellException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public Object executeCommand(String str) {
        try {
            String r = this.command(str);
            if (r.length() < 1) {
                return this._prompt;
            }
            if (r.substring(r.length() - 1).equals("\n")) {
                return this.command(str) + this._prompt;
            }
            return this.command(str) + "\n" + this._prompt;
        }
        catch (CommandExitException cee) {
            return null;
        }
    }

    public Object ac_logoff(Args args) throws CommandException {
        throw new CommandExitException("Done", 0);
    }

    public Object executeCommand(Object obj) {
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            if (array.length < 2) {
                throw new IllegalArgumentException("not enough arguments");
            }
            try {
                obj = this.runCommand((String)array[0], array);
            }
            catch (NoRouteToCellException eee) {
                obj = eee;
            }
            catch (InterruptedException eee) {
                obj = eee;
            }
        }
        return obj;
    }

    private Object runCommand(String command, Object[] args) throws NoRouteToCellException, InterruptedException {
        switch (command) {
            case "set-dest": {
                this._cellPath = new CellPath((String)args[1]);
                return args;
            }
            case "request": 
            case "pvl-request": {
                if (args.length < 3) {
                    throw new IllegalArgumentException("not enough arguments");
                }
                this._cellPath = ((String)args[0]).startsWith("pvl") ? new CellPath("pvl") : new CellPath("acm");
                args[1] = this._user;
                CellMessage res = this._nucleus.sendAndWait(new CellMessage(this._cellPath, (Serializable)args), 10000L);
                if (res == null) {
                    return new Exception("Request timed out");
                }
                return res.getMessageObject();
            }
        }
        throw new IllegalArgumentException("Command not found : " + command);
    }
}

