/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import com.google.common.base.Objects;
import dmg.cells.applets.login.DomainObjectFrame;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellNucleus;
import dmg.util.Args;
import dmg.util.CommandExitException;
import dmg.util.CommandSyntaxException;
import dmg.util.StreamEngine;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.security.auth.Subject;
import jline.ANSIBuffer;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.Terminal;
import jline.UnixTerminal;
import org.dcache.auth.Subjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamObjectCell
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(StreamObjectCell.class);
    private static final int HISTORY_SIZE = 50;
    private static final String CONTROL_C_ANSWER = "Got interrupt. Please issue 'logoff' from within the admin cell to end this session.\n";
    private static final Class<?>[][] CONST_SIGNATURE = new Class[][]{{String.class, CellNucleus.class, Args.class}, {CellNucleus.class, Args.class}, {CellNucleus.class}, {Args.class}, new Class[0]};
    private static final Class<?>[][] COM_SIGNATURE = new Class[][]{{Object.class}, {String.class}, {String.class, Object.class}, {String.class, String.class}};
    private StreamEngine _engine;
    private Subject _subject;
    private Thread _workerThread;
    private CellNucleus _nucleus;
    private File _historyFile;
    private boolean _useColors;
    private Object _commandObject;
    private Method[] _commandMethod = new Method[COM_SIGNATURE.length];
    private Method _promptMethod;
    private Method _helloMethod;

    public StreamObjectCell(String name, StreamEngine engine, Args args) throws Exception {
        super(name, args, false);
        this._engine = engine;
        this._nucleus = this.getNucleus();
        this.setCommandExceptionEnabled(true);
        try {
            if (args.argc() < 1) {
                throw new IllegalArgumentException("Usage : ... <commandClassName>");
            }
            this.tryToSetHistoryFile(args.getOpt("history"));
            this._useColors = Boolean.valueOf(args.getOpt("useColors")) != false && this._engine.getTerminalType() != null;
            _log.info("StreamObjectCell " + this.getCellName() + "; arg0=" + args.argv(0));
            this._subject = engine.getSubject();
            this.prepareClass(args.argv(0));
        }
        catch (Exception e) {
            this.start();
            this.kill();
            throw e;
        }
        this.useInterpreter(false);
        this.start();
        this._workerThread = this._nucleus.newThread(this, "Worker");
        this._workerThread.start();
    }

    private void tryToSetHistoryFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            return;
        }
        try {
            this.setHistoryFile(filename);
        }
        catch (IllegalArgumentException e) {
            _log.error(e.getMessage());
        }
    }

    private void setHistoryFile(String filename) {
        File file = new File(filename);
        try {
            if (file.createNewFile()) {
                _log.info("History file " + file + " has been created.");
            } else {
                this.guardFileIsFile(file);
                this.guardFileIsWriteable(file);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("History file " + file + " does not exist and cannot be created.");
        }
        this._historyFile = file;
    }

    private void guardFileIsFile(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("History file " + file + " is not a simple file.");
        }
    }

    private void guardFileIsWriteable(File file) {
        if (!file.canWrite()) {
            throw new IllegalArgumentException("History file " + file + " is not writeable.");
        }
    }

    private void prepareClass(String className) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int commandConstMode = -1;
        Constructor<?> commandConst = null;
        Class<?> commandClass = Class.forName(className);
        NoSuchMethodException nsme = null;
        _log.info("Using class : " + commandClass);
        for (int i = 0; i < CONST_SIGNATURE.length; ++i) {
            nsme = null;
            Class<?>[] x = CONST_SIGNATURE[i];
            _log.info("Looking for constructor : " + i);
            for (int ix = 0; ix < x.length; ++ix) {
                _log.info("   arg[" + ix + "] " + x[ix]);
            }
            try {
                commandConst = commandClass.getConstructor(CONST_SIGNATURE[i]);
            }
            catch (NoSuchMethodException e) {
                _log.info("Constructor not found : " + CONST_SIGNATURE[i]);
                nsme = e;
                continue;
            }
            commandConstMode = i;
            break;
        }
        if (nsme != null) {
            throw nsme;
        }
        _log.info("Using constructor : " + commandConst);
        int validMethods = 0;
        for (int i = 0; i < COM_SIGNATURE.length; ++i) {
            try {
                this._commandMethod[i] = commandClass.getMethod("executeCommand", COM_SIGNATURE[i]);
                ++validMethods;
            }
            catch (Exception e) {
                this._commandMethod[i] = null;
                continue;
            }
            _log.info("Using method [" + i + "] " + this._commandMethod[i]);
        }
        if (validMethods == 0) {
            throw new IllegalArgumentException("no valid executeCommand found");
        }
        try {
            this._promptMethod = commandClass.getMethod("getPrompt", new Class[0]);
        }
        catch (Exception e) {
            this._promptMethod = null;
        }
        if (this._promptMethod != null) {
            _log.info("Using promptMethod : " + this._promptMethod);
        }
        try {
            this._helloMethod = commandClass.getMethod("getHello", new Class[0]);
        }
        catch (Exception ee) {
            this._helloMethod = null;
        }
        if (this._helloMethod != null) {
            _log.info("Using helloMethod : " + this._helloMethod);
        }
        Args extArgs = new Args(this.getArgs());
        Object[] args = null;
        extArgs.shift();
        switch (commandConstMode) {
            case 0: {
                args = new Object[]{Objects.firstNonNull((Object)Subjects.getUserName((Subject)this._subject), (Object)"<unknown>"), this.getNucleus(), extArgs};
                break;
            }
            case 1: {
                args = new Object[]{this.getNucleus(), extArgs};
                break;
            }
            case 2: {
                args = new Object[]{this.getNucleus()};
                break;
            }
            case 3: {
                args = new Object[]{extArgs};
                break;
            }
            case 4: {
                args = new Object[]{};
            }
        }
        this._commandObject = commandConst.newInstance(args);
    }

    private String getPrompt() {
        if (this._promptMethod == null) {
            return "";
        }
        try {
            String s = (String)this._promptMethod.invoke(this._commandObject, new Object[0]);
            return s == null ? "" : s;
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getHello() {
        if (this._helloMethod == null) {
            return null;
        }
        try {
            String s = (String)this._helloMethod.invoke(this._commandObject, new Object[0]);
            return s == null ? "" : s;
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            History history = this._historyFile != null ? new History(this._historyFile) : new History();
            try {
                final ConsoleReader console = new ConsoleReader(this._engine.getInputStream(), this._engine.getWriter(), null, (Terminal)new StreamObjectCellTerminal());
                history.setMaxSize(50);
                console.setHistory(history);
                console.setUseHistory(true);
                if (this._commandObject instanceof Completor) {
                    console.addCompletor((Completor)this._commandObject);
                }
                console.addTriggeredAction('\u0003', new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        try {
                            console.printString(StreamObjectCell.CONTROL_C_ANSWER);
                            console.flushConsole();
                        }
                        catch (IOException e) {
                            _log.warn("I/O failure: " + e);
                        }
                    }
                });
                String hello = this.getHello();
                if (hello != null) {
                    console.printString(hello);
                    console.flushConsole();
                }
                this.runAsciiMode(console);
                console.flushConsole();
            }
            finally {
                PrintWriter out = history.getOutput();
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IllegalAccessException e) {
            _log.error("Failed to execute command: " + e);
        }
        catch (ClassNotFoundException e) {
            _log.warn("Binary mode failure: " + e);
        }
        catch (IOException e) {
            _log.warn("I/O Failure: " + e);
        }
        finally {
            _log.debug("worker done, killing off cell");
            this.kill();
        }
    }

    private void runBinaryMode() throws IOException, ClassNotFoundException {
        Object obj;
        ObjectOutputStream out = new ObjectOutputStream(this._engine.getOutputStream());
        ObjectInputStream in = new ObjectInputStream(this._engine.getInputStream());
        while ((obj = in.readObject()) != null) {
            if (obj instanceof DomainObjectFrame) {
                new BinaryExec(out, (DomainObjectFrame)obj, Thread.currentThread());
                continue;
            }
            _log.error("Won't accept non DomainObjectFrame : " + obj.getClass());
        }
    }

    private void runAsciiMode(ConsoleReader console) throws IOException, ClassNotFoundException, IllegalAccessException {
        Method com = this._commandMethod[1] != null ? this._commandMethod[1] : this._commandMethod[0];
        boolean done = false;
        while (!done) {
            String s;
            Object result;
            block9: {
                String prompt = new ANSIBuffer().green(this.getPrompt()).toString(this._useColors);
                String str = console.readLine(prompt);
                if (str == null) {
                    _log.debug("\"null\" input (e.g., Ctrl-D) received.");
                    break;
                }
                _log.debug("received line: {}", (Object)str);
                if (str.equals("$BINARY$")) {
                    _log.info("Opening Object Streams");
                    console.printString(str);
                    console.printNewline();
                    console.flushConsole();
                    this.runBinaryMode();
                    break;
                }
                try {
                    result = com.invoke(this._commandObject, str);
                }
                catch (InvocationTargetException ite) {
                    result = ite.getTargetException();
                    if (!(result instanceof CommandExitException)) break block9;
                    _log.debug("User requested to logout.");
                    done = true;
                }
            }
            if (result == null) continue;
            if (result instanceof CommandSyntaxException) {
                CommandSyntaxException e = (CommandSyntaxException)result;
                ANSIBuffer sb = new ANSIBuffer();
                sb.red("Syntax error: " + e.getMessage() + "\n");
                String help = e.getHelpText();
                if (help != null) {
                    sb.cyan("Help : \n");
                    sb.cyan(help);
                }
                s = sb.toString(this._useColors);
            } else {
                s = result.toString();
            }
            if (s.isEmpty()) continue;
            console.printString(s);
            if (s.charAt(s.length() - 1) != '\n') {
                console.printNewline();
            }
            console.flushConsole();
        }
    }

    @Override
    public void cleanUp() {
        try {
            _log.debug("Shutting down the SSH connection");
            this._engine.getInputStream().close();
        }
        catch (IOException e) {
            _log.error("Failed to close socket: " + e);
        }
        if (this._workerThread != null) {
            this._workerThread.interrupt();
        }
    }

    private class StreamObjectCellTerminal
    extends UnixTerminal {
        private static final int DEFAULT_WIDTH = 80;
        private static final int DEFAULT_HEIGHT = 24;
        private boolean _swapNext;

        private StreamObjectCellTerminal() {
        }

        public void initializeTerminal() throws IOException, InterruptedException {
        }

        public int readCharacter(InputStream in) throws IOException {
            int c = super.readCharacter(in);
            if (this._swapNext) {
                if (c == 127) {
                    c = 8;
                }
                this._swapNext = false;
            }
            return c;
        }

        public int readVirtualKey(InputStream in) throws IOException {
            this._swapNext = true;
            return super.readVirtualKey(in);
        }

        public int getTerminalWidth() {
            int width = StreamObjectCell.this._engine.getTerminalWidth();
            return width == 0 ? 80 : width;
        }

        public int getTerminalHeight() {
            int height = StreamObjectCell.this._engine.getTerminalHeight();
            return height == 0 ? 24 : height;
        }
    }

    private class BinaryExec
    implements Runnable {
        private final ObjectOutputStream _out;
        private final DomainObjectFrame _frame;
        private final Thread _parent;

        BinaryExec(ObjectOutputStream out, DomainObjectFrame frame, Thread parent) {
            this._out = out;
            this._frame = frame;
            this._parent = parent;
            StreamObjectCell.this._nucleus.newThread(this).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object result;
            boolean done;
            block14: {
                done = false;
                _log.info("Frame id " + this._frame.getId() + " arrived");
                try {
                    Object[] array;
                    if (this._frame.getDestination() == null) {
                        array = new Object[]{this._frame.getPayload()};
                        if (StreamObjectCell.this._commandMethod[0] != null) {
                            _log.info("Choosing executeCommand(Object)");
                            result = StreamObjectCell.this._commandMethod[0].invoke(StreamObjectCell.this._commandObject, array);
                            break block14;
                        }
                        if (StreamObjectCell.this._commandMethod[1] != null) {
                            _log.info("Choosing executeCommand(String)");
                            array[0] = array[0].toString();
                            result = StreamObjectCell.this._commandMethod[1].invoke(StreamObjectCell.this._commandObject, array);
                            break block14;
                        }
                        throw new Exception("PANIC : not found : executeCommand(String or Object)");
                    }
                    array = new Object[]{this._frame.getDestination(), this._frame.getPayload()};
                    if (StreamObjectCell.this._commandMethod[2] != null) {
                        _log.info("Choosing executeCommand(String destination, Object)");
                        result = StreamObjectCell.this._commandMethod[2].invoke(StreamObjectCell.this._commandObject, array);
                        break block14;
                    }
                    if (StreamObjectCell.this._commandMethod[3] != null) {
                        _log.info("Choosing executeCommand(String destination, String)");
                        array[1] = array[1].toString();
                        result = StreamObjectCell.this._commandMethod[3].invoke(StreamObjectCell.this._commandObject, array);
                        break block14;
                    }
                    throw new Exception("PANIC : not found : executeCommand(String/String or Object/String)");
                }
                catch (InvocationTargetException ite) {
                    result = ite.getTargetException();
                    done = result instanceof CommandExitException;
                }
                catch (Exception ae) {
                    result = ae;
                }
            }
            this._frame.setPayload(result);
            try {
                ObjectOutputStream ae = this._out;
                synchronized (ae) {
                    this._out.writeObject(this._frame);
                    this._out.flush();
                    this._out.reset();
                }
            }
            catch (IOException e) {
                _log.error("Problem sending result : " + e);
            }
            if (done) {
                this._parent.interrupt();
            }
        }
    }
}

