/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.services.StreamLoginCell;
import dmg.protocols.ssh.SshRsaKey;
import dmg.protocols.ssh.SshRsaKeyContainer;
import dmg.protocols.ssh.SshServerAuthentication;
import dmg.protocols.ssh.SshSharedKey;
import dmg.protocols.ssh.SshStreamEngine;
import dmg.util.Args;
import dmg.util.StreamEngine;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshLoginManager
extends CellAdapter
implements Runnable,
SshServerAuthentication {
    private static final Logger _log = LoggerFactory.getLogger(SshLoginManager.class);
    private String _cellName;
    private CellNucleus _nucleus;
    private int _listenPort;
    private ServerSocket _serverSocket;
    private Thread _listenThread;
    private int _connectionRequestCounter;
    private int _connectionAcceptionCounter;
    private Hashtable<Thread, Socket> _connectionThreads = new Hashtable();
    private SshRsaKey _hostKey;
    private SshRsaKey _serverKey;
    private SshRsaKeyContainer _userKeys;
    private SshRsaKeyContainer _hostKeys;
    private int _keyUpdateInterval = 30;
    private int _loginCounter;
    private int _loginFailures;
    private Class<? extends StreamLoginCell> _loginClass = StreamLoginCell.class;
    private Constructor<? extends StreamLoginCell> _loginConstructor;
    private Class<?>[] _loginConSignature0 = new Class[]{String.class, StreamEngine.class};
    private Class<?>[] _loginConSignature1 = new Class[]{String.class, StreamEngine.class, Args.class};
    private Class<?>[] _loginPntSignature = new Class[]{Integer.TYPE};
    private int _loginConType = -1;

    public SshLoginManager(String name, String argString) throws Exception {
        super(name, argString, false);
        this._cellName = name;
        try {
            Args args = this.getArgs();
            if (args.argc() < 1) {
                throw new IllegalArgumentException("USAGE : ... <listenPort> [<loginClass> [...]]");
            }
            this._listenPort = Integer.parseInt(args.argv(0));
            args.shift();
            if (args.argc() > 0) {
                this._loginClass = Class.forName(args.argv(0)).asSubclass(StreamLoginCell.class);
                _log.info("Using login class : " + this._loginClass.getName());
                args.shift();
            }
            try {
                this._loginConstructor = this._loginClass.getConstructor(this._loginConSignature1);
                this._loginConType = 1;
            }
            catch (NoSuchMethodException nsme) {
                this._loginConstructor = this._loginClass.getConstructor(this._loginConSignature0);
                this._loginConType = 0;
            }
            _log.info("Using constructor : " + this._loginConstructor);
            this._serverSocket = new ServerSocket(this._listenPort);
            this._nucleus = this.getNucleus();
            this._listenThread = new Thread((Runnable)this, "listenThread");
            this._listenThread.start();
        }
        catch (Exception e) {
            _log.warn("SshLoginManger >" + this.getCellName() + "< got exception : " + e);
            this.start();
            this.kill();
            throw e;
        }
        this.start();
    }

    @Override
    public String toString() {
        return "p=" + this._listenPort + ";c=" + this._loginClass.getName();
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("  -- Ssh Login Manager");
        pw.println("  Listen Port    : " + this._listenPort);
        pw.println("  Login Class    : " + this._loginClass);
        pw.println("  Logins created : " + this._loginCounter);
        pw.println("  Logins failed  : " + this._loginFailures);
    }

    @Override
    public void cleanUp() {
        _log.info("cleanUp requested by nucleus, closing listen socket");
        if (this._serverSocket != null) {
            try {
                this._serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        _log.info("Bye Bye");
    }

    private void acceptConnections() {
        while (true) {
            Socket socket = null;
            try {
                socket = this._serverSocket.accept();
                ++this._connectionRequestCounter;
                _log.info("Connection request from " + socket.getInetAddress());
                Thread t = new Thread(this);
                this._connectionThreads.put(t, socket);
                t.start();
                continue;
            }
            catch (IOException ioe) {
                _log.warn("Got an IO Exception ( closing server ) : " + ioe);
            }
            catch (Exception ee) {
                _log.warn("Got an Exception in getting keys ( closing connection ) : " + ee);
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
    }

    public void acceptConnection(Socket socket) {
        Thread t = Thread.currentThread();
        try {
            _log.info("acceptThread (" + t + "): creating protocol engine");
            SshStreamEngine engine = new SshStreamEngine(socket, this);
            String userPrincipal = engine.getName();
            _log.info("acceptThread (" + t + "): connection created for user " + userPrincipal);
            Object[] args = this._loginConType == 0 ? new Object[]{this.getCellName() + "-" + userPrincipal + "*", engine} : new Object[]{this.getCellName() + "-" + userPrincipal + "*", engine, new Args(this.getArgs())};
            try {
                StreamLoginCell cell = this._loginConstructor.newInstance(args);
                ++this._loginCounter;
            }
            catch (Exception ie) {
                _log.warn("Can't create new instance of " + this._loginClass.getName() + " " + ie);
                engine.close();
                ++this._loginFailures;
            }
        }
        catch (Exception e) {
            _log.warn("Exception in secure protocol : " + e);
            ++this._loginFailures;
        }
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._listenThread) {
            this.acceptConnections();
        } else {
            Socket currentSocket = this._connectionThreads.remove(Thread.currentThread());
            if (currentSocket != null) {
                this.acceptConnection(currentSocket);
            }
        }
    }

    private SshRsaKey getIdentity(String keyName) {
        Map sshContext = (Map)this._nucleus.getDomainContext().get("Ssh");
        if (sshContext == null) {
            _log.warn("Auth (" + keyName + ") : Ssh Context unavailable");
            return null;
        }
        SshRsaKey key = (SshRsaKey)sshContext.get(keyName);
        _log.info("Auth : Request for " + keyName + (key == null ? " Failed" : " o.k."));
        return key;
    }

    @Override
    public SshRsaKey getHostRsaKey() {
        return this.getIdentity("hostIdentity");
    }

    @Override
    public SshRsaKey getServerRsaKey() {
        return this.getIdentity("serverIdentity");
    }

    @Override
    public SshSharedKey getSharedKey(InetAddress host, String keyName) {
        _log.info("Auth : Request for Shared Key denied");
        return null;
    }

    @Override
    public boolean authUser(InetAddress addr, String user) {
        _log.info("Auth : User Request for user " + user + " host " + addr + " denied");
        return false;
    }

    @Override
    public boolean authRhosts(InetAddress addr, String user) {
        _log.info("Auth : Rhost Request for user " + user + " host " + addr + " denied");
        return false;
    }

    @Override
    public boolean authPassword(InetAddress addr, String user, String password) {
        _log.info("Auth : Password Request for user " + user + " host " + addr);
        Map sshContext = (Map)this._nucleus.getDomainContext().get("Ssh");
        if (sshContext == null) {
            _log.warn("Auth authPassword : Ssh Context unavailable for request from User " + user + " Host " + addr);
            return false;
        }
        Object userObject = sshContext.get("userPasswords");
        if (userObject == null) {
            _log.warn("Auth authPassword : userPasswords not available");
            return false;
        }
        if (userObject instanceof Hashtable) {
            Hashtable passwords = (Hashtable)userObject;
            String realPassword = (String)passwords.get(user);
            if (realPassword != null) {
                if (password.equals(realPassword)) {
                    return true;
                }
                _log.warn("Auth authPassword : user " + user + " password mismatch ");
                return false;
            }
            _log.warn("Auth authPassword : user " + user + " not found ");
            return false;
        }
        if (userObject instanceof String) {
            CellPath path = new CellPath((String)userObject);
            _log.info("Auth passwd : using : " + path);
            Object[] request = new Object[]{"request", "unknown", "check-password", user, password};
            CellMessage msg = new CellMessage(path, (Serializable)request);
            try {
                msg = this.sendAndWait(msg, 4000L);
                if (msg == null) {
                    _log.warn("request for user >" + user + "< timed out");
                    return false;
                }
            }
            catch (NoRouteToCellException e) {
                _log.warn("Problem for user >" + user + "< : " + e);
                return false;
            }
            catch (InterruptedException e) {
                _log.warn("Problem for user >" + user + "< : " + e);
                return false;
            }
            Serializable obj = msg.getMessageObject();
            if (obj == null) {
                _log.warn("Request response is null");
                return false;
            }
            if (!(obj instanceof Object[])) {
                _log.warn("Response not Object[] : " + obj.getClass());
                return false;
            }
            request = (Object[])obj;
            if (request.length < 6) {
                _log.warn("Response length < 6");
                return false;
            }
            if (!(request[0] instanceof String && request[0].equals("response") && request[5] instanceof Boolean)) {
                _log.warn("Not a response");
                return false;
            }
            _log.info("Response for >" + user + "< : " + request[5]);
            return (Boolean)request[5];
        }
        return false;
    }

    private SshRsaKey getPublicKey(String domain, SshRsaKey modulusKey, InetAddress addr, String user) {
        Map sshContext = (Map)this._nucleus.getDomainContext().get("Ssh");
        _log.info("Serching Key in " + domain);
        _log.info("" + modulusKey);
        if (sshContext == null) {
            _log.warn("Auth (" + domain + ") : Ssh Context unavailable for request from User " + user + " Host " + addr);
            return null;
        }
        SshRsaKeyContainer container = (SshRsaKeyContainer)sshContext.get(domain);
        if (container == null) {
            _log.warn("Auth (" + domain + ") : Ssh " + domain + " unavailable for request from User " + user + " Host " + addr);
            return null;
        }
        SshRsaKey key = container.findByModulus(modulusKey);
        if (key == null) {
            _log.warn("Auth (" + domain + ") : Ssh key not found from User " + user + " Host " + addr);
            return null;
        }
        return key;
    }

    @Override
    public SshRsaKey authRsa(InetAddress addr, String user, SshRsaKey userKey) {
        SshRsaKey key = this.getPublicKey("knownUsers", userKey, addr, user);
        String domain = "knownUsers";
        if (key == null) {
            return null;
        }
        String keyUser = key.getComment();
        StringTokenizer st = new StringTokenizer(keyUser, "@");
        if ((keyUser = st.nextToken()).equals(user)) {
            _log.info("Auth (" + domain + ") : Ssh key (" + key.getComment() + ") found for user " + user + " Host " + addr);
            return key;
        }
        _log.info("Auth (" + domain + ") : Ssh key mismatch " + keyUser + " <> " + user);
        return null;
    }

    @Override
    public SshRsaKey authRhostsRsa(InetAddress addr, String user, String reqUser, SshRsaKey hostKey) {
        _log.info("Auth (authRhostsRsa) : host=" + addr + " user=" + user + " reqUser=" + reqUser);
        if (!user.equals(reqUser)) {
            _log.info("Auth : user mismatch , proxy user not allowed");
            return null;
        }
        return this.getPublicKey("knownHosts", hostKey, addr, user);
    }
}

