/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.protocols.ssh.SshRsaKey;
import dmg.protocols.ssh.SshRsaKeyContainer;
import dmg.util.Args;
import dmg.util.CollectionFactory;
import dmg.util.UserPasswords;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshKeyManager
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(SshKeyManager.class);
    private CellNucleus _nucleus = this.getNucleus();
    private String _knownHostsKeys;
    private String _knownUsersKeys;
    private String _hostIdentity;
    private String _serverIdentity;
    private String _userPasswords;
    private long _knownHostsKeysUpdate;
    private long _knownUsersKeysUpdate;
    private long _hostIdentityUpdate;
    private long _serverIdentityUpdate;
    private long _userPasswordsUpdate;
    private Date _knownHostsKeysDate;
    private Date _knownUsersKeysDate;
    private Date _hostIdentityDate;
    private Date _serverIdentityDate;
    private Date _userPasswordsDate;
    private int _updateTime = 30;
    private Thread _updateThread;
    private long _updateTimeUsed;
    private final Map<String, Object> _sshContext;
    private final Map<String, Object> _cellContext = this._nucleus.getDomainContext();

    public SshKeyManager(String name, String args) {
        super(name, args, false);
        this._hostIdentity = (String)this._cellContext.get("hostKeyFile");
        if (this._hostIdentity == null) {
            this._hostIdentity = "none";
        }
        if ((this._serverIdentity = (String)this._cellContext.get("serverKeyFile")) == null) {
            this._serverIdentity = "none";
        }
        if ((this._knownHostsKeys = (String)this._cellContext.get("knownHostsFile")) == null) {
            this._knownHostsKeys = "none";
        }
        if ((this._knownUsersKeys = (String)this._cellContext.get("knownUsersFile")) == null) {
            this._knownUsersKeys = "none";
        }
        if ((this._userPasswords = (String)this._cellContext.get("userPasswordFile")) == null) {
            this._userPasswords = "none";
        }
        this._sshContext = CollectionFactory.newConcurrentHashMap();
        this._cellContext.put("Ssh", this._sshContext);
        this._updateThread = this._nucleus.newThread(this, "update");
        this._updateThread.start();
        this.start();
    }

    public String ac_set_hostKeyFile_$_1(Args args) {
        this._hostIdentity = args.argv(0);
        this._hostIdentityUpdate = 0L;
        return "hostKeyFile=" + this._hostIdentity + "; use 'update' to update key";
    }

    public String ac_set_serverKeyFile_$_1(Args args) {
        this._serverIdentity = args.argv(0);
        this._serverIdentityUpdate = 0L;
        return "serverKeyFile=" + this._serverIdentity + "; use 'update' to update key";
    }

    public String ac_set_userPasswords_$_1(Args args) {
        this._userPasswords = args.argv(0);
        this._userPasswordsUpdate = 0L;
        return "userPasswords=" + this._userPasswords + "; use 'update' to update key";
    }

    public String ac_update(Args args) {
        this._hostIdentityUpdate = 0L;
        this._serverIdentityUpdate = 0L;
        this.updateKeys();
        return "Done";
    }

    private synchronized void updateKeys() {
        SshRsaKey key;
        SshRsaKeyContainer box;
        File f;
        boolean wasUpdated = false;
        long start = System.currentTimeMillis();
        if (!this._knownHostsKeys.equals("none") && (f = new File(this._knownHostsKeys)).canRead() && f.lastModified() > this._knownHostsKeysUpdate) {
            try {
                box = new SshRsaKeyContainer(new FileInputStream(f));
                if (box != null) {
                    this._sshContext.put("knownHosts", box);
                    this._knownHostsKeysDate = new Date();
                    this._knownHostsKeysUpdate = f.lastModified();
                    wasUpdated = true;
                    _log.info("updateKeys : knownHosts updated");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!this._knownUsersKeys.equals("none") && (f = new File(this._knownUsersKeys)).canRead() && f.lastModified() > this._knownUsersKeysUpdate) {
            try {
                box = new SshRsaKeyContainer(new FileInputStream(f));
                if (box != null) {
                    this._sshContext.put("knownUsers", box);
                    this._knownUsersKeysDate = new Date();
                    this._knownUsersKeysUpdate = f.lastModified();
                    wasUpdated = true;
                    _log.info("updateKeys : knownUsers updated");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!this._hostIdentity.equals("none") && (f = new File(this._hostIdentity)).canRead() && f.lastModified() > this._hostIdentityUpdate) {
            try {
                key = new SshRsaKey(new FileInputStream(f));
                if (key != null) {
                    this._sshContext.put("hostIdentity", key);
                    this._hostIdentityDate = new Date();
                    this._hostIdentityUpdate = f.lastModified();
                    wasUpdated = true;
                    _log.info("updateKeys : hostIdentity updated");
                }
            }
            catch (IOException e) {
                _log.warn("updateKeys : hostIdentity failed : " + e);
            }
        }
        if (!this._serverIdentity.equals("none") && (f = new File(this._serverIdentity)).canRead() && f.lastModified() > this._serverIdentityUpdate) {
            try {
                key = new SshRsaKey(new FileInputStream(f));
                if (key != null) {
                    this._sshContext.put("serverIdentity", key);
                    this._serverIdentityDate = new Date();
                    this._serverIdentityUpdate = f.lastModified();
                    wasUpdated = true;
                    _log.info("updateKeys : serverIdentity updated");
                }
            }
            catch (IOException e) {
                _log.warn("updateKeys : serverIdentity failed : " + e);
            }
        }
        if (this._userPasswords.startsWith("cell:")) {
            if (this._userPasswords.length() > 5) {
                this._sshContext.put("userPasswords", this._userPasswords.substring(5));
            } else {
                this._sshContext.remove("userPasswords");
            }
        } else if (!this._userPasswords.equals("none") && (f = new File(this._userPasswords)).canRead() && f.lastModified() > this._userPasswordsUpdate) {
            try {
                UserPasswords hash = new UserPasswords(new FileInputStream(f));
                if (hash != null) {
                    this._sshContext.put("userPasswords", hash);
                    this._userPasswordsDate = new Date();
                    this._userPasswordsUpdate = f.lastModified();
                    wasUpdated = true;
                    _log.info("updateKeys : userPasswords updated");
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (wasUpdated) {
            this._updateTimeUsed = System.currentTimeMillis() - start;
        }
    }

    @Override
    public void run() {
        if (Thread.currentThread() == this._updateThread) {
            while (true) {
                this.updateKeys();
                try {
                    Thread.sleep(this._updateTime * 1000);
                }
                catch (InterruptedException ie) {
                    _log.info("UpdateThreadInterrupted");
                    break;
                }
            }
        }
    }

    @Override
    public String toString() {
        return "Ssh Key Manager";
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("  -----   Ssh Key Manager  -------------- ");
        pw.println("    Host Key File : " + this._hostIdentity);
        pw.println("      Last Update : " + this._hostIdentityDate);
        pw.println("  Server Key File : " + this._serverIdentity);
        pw.println("      Last Update : " + this._serverIdentityDate);
        pw.println(" Known Users File : " + this._knownUsersKeys);
        pw.println("      Last Update : " + this._knownUsersKeysDate);
        pw.println(" Known Hosts File : " + this._knownHostsKeys);
        pw.println("      Last Update : " + this._knownHostsKeysDate);
        pw.println(" User Passwd File : " + this._userPasswords);
        pw.println("      Last Update : " + this._userPasswordsDate);
        pw.println(" Update Interval  : " + this._updateTime + " seconds");
        pw.println(" Update Time used : " + this._updateTimeUsed + " msec");
    }

    @Override
    public void messageArrived(CellMessage msg) {
        _log.info(" CellMessage From   : " + msg.getSourcePath());
        _log.info(" CellMessage To     : " + msg.getDestinationPath());
        _log.info(" CellMessage Object : " + msg.getMessageObject());
    }

    @Override
    public void cleanUp() {
        this._cellContext.remove("Ssh");
        _log.info("finished");
        this._updateThread.interrupt();
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
        _log.info(" exceptionArrived " + ce);
    }
}

