/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.CellNucleus;
import dmg.protocols.ssh.SshAuthMethod;
import dmg.protocols.ssh.SshAuthRsa;
import dmg.protocols.ssh.SshClientAuthentication;
import dmg.protocols.ssh.SshRsaKey;
import dmg.protocols.ssh.SshSharedKey;
import dmg.util.Args;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;

public class SshCAuth_Key
implements SshClientAuthentication {
    private SshAuthMethod _rsaAuth;
    private CellNucleus _nucleus;
    private Args _args;
    private String _userName = "admin";
    private int _requestCounter;

    public SshCAuth_Key(CellNucleus nucleus, Args args) throws Exception {
        this._nucleus = nucleus;
        this._args = args;
        String keyFile = args.getOpt("clientKey");
        if (keyFile == null) {
            throw new IllegalArgumentException("KeyFile 'clientKey' not defined");
        }
        File key = new File(keyFile);
        if (!key.exists()) {
            throw new IllegalArgumentException("KeyFile not found : " + keyFile);
        }
        this._userName = args.getOpt("clientUserName");
        this._userName = this._userName != null && this._userName.length() > 0 ? this._userName : "admin";
        this.setIdentityFile(key);
    }

    @Override
    public SshAuthMethod getAuthMethod() {
        if (this._requestCounter++ == 0) {
            return this._rsaAuth;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIdentityFile(File identityFile) throws Exception {
        FileInputStream in = new FileInputStream(identityFile);
        try {
            SshRsaKey key = new SshRsaKey(in);
            this._rsaAuth = new SshAuthRsa(key);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public SshSharedKey getSharedKey(InetAddress host) {
        return null;
    }

    @Override
    public boolean isHostKey(InetAddress host, SshRsaKey key) {
        return true;
    }

    @Override
    public String getUser() {
        this._requestCounter = 0;
        return this._userName;
    }
}

