/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.login;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellShell;
import dmg.util.Args;
import dmg.util.Gate;
import dmg.util.StreamEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginCell
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(LoginCell.class);
    private StreamEngine _engine;
    private BufferedReader _in;
    private PrintWriter _out;
    private InetAddress _host;
    private Subject _subject;
    private Thread _workerThread;
    private CellShell _shell;
    private String _prompt;
    private boolean _syncMode = true;
    private Gate _readyGate = new Gate(false);
    private int _syncTimeout = 10;
    private int _commandCounter;
    private String _lastCommand = "<init>";
    private Reader _reader;
    private static final Class<?>[][] _signature = new Class[][]{{String.class, CellNucleus.class, Args.class}, {CellNucleus.class}, new Class[0]};

    public LoginCell(String name, StreamEngine engine, Args args) throws Exception {
        super(name, args, false);
        this._engine = engine;
        try {
            this._reader = engine.getReader();
            this._in = new BufferedReader(this._reader);
            this._out = new PrintWriter(engine.getWriter());
            this._subject = engine.getSubject();
            this._host = engine.getInetAddress();
            this._loadShells(args);
        }
        catch (Exception e) {
            this.start();
            this.kill();
            throw e;
        }
        this.useInterpreter(false);
        this._prompt = this.getCellName();
        this._workerThread = new Thread(this);
        this._workerThread.start();
        this.start();
    }

    private void _loadShells(Args args) {
        Object[][] objList = new Object[_signature.length][];
        for (int i = 0; i < objList.length; ++i) {
            objList[i] = new Object[_signature[i].length];
        }
        objList[0][0] = this._subject;
        objList[0][1] = this.getNucleus();
        objList[0][2] = new Args(args);
        objList[1][0] = this.getNucleus();
        Constructor<?> con = null;
        for (int i = 0; i < args.argc(); ++i) {
            _log.info("Trying to load shell : " + args.argv(i));
            try {
                int j;
                Class<?> c = Class.forName(args.argv(i));
                for (j = 0; j < _signature.length; ++j) {
                    try {
                        con = c.getConstructor(_signature[j]);
                        break;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (j == _signature.length) {
                    throw new Exception("No constructor found");
                }
                Object o = con.newInstance(objList[j]);
                this.addCommandListener(o);
                _log.info("Added : " + args.argv(i));
                continue;
            }
            catch (Exception ee) {
                _log.warn("Failed to load shell : " + args.argv(i) + " : " + ee);
                if (!(ee instanceof InvocationTargetException)) continue;
                _log.warn("   -> Problem in constructor : " + ((InvocationTargetException)ee).getTargetException());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (Thread.currentThread() == this._workerThread) {
            this.print(this.prompt());
            try {
                while ((this._lastCommand = this._in.readLine()) != null) {
                    ++this._commandCounter;
                    if (this.execute(this._lastCommand) > 0) {
                        try {
                            this._out.close();
                            continue;
                        }
                        catch (Exception ee) {
                            continue;
                        }
                    }
                    this.print(this.prompt());
                }
            }
            catch (IOException e) {
                _log.info("EOF Exception in read line : " + e);
            }
            catch (Exception e) {
                _log.info("I/O Error in read line : " + e);
            }
            _log.info("EOS encountered");
            this._readyGate.open();
            this.kill();
        }
    }

    @Override
    public void cleanUp() {
        _log.info("Clean up called");
        this.println("");
        this._out.close();
        this._readyGate.check();
        _log.info("finished");
    }

    public void println(String str) {
        this._out.print(str);
        if (str.length() > 0 && !str.substring(str.length() - 1).equals("\n")) {
            this._out.println("");
        }
        this._out.flush();
    }

    public void print(String str) {
        this._out.print(str);
        this._out.flush();
    }

    public String prompt() {
        return this._prompt == null ? " .. > " : this._prompt + " > ";
    }

    public int execute(String command) throws Exception {
        if (command.equals("exit")) {
            return 1;
        }
        this.println(this.command(command));
        return 0;
    }

    @Override
    public String toString() {
        return Subjects.getDisplayName((Subject)this._subject) + "@" + this._host;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("            Generic Login Cell");
        pw.println("         User  : " + Subjects.getDisplayName((Subject)this._subject));
        pw.println("         Host  : " + this._host);
        pw.println(" Last Command  : " + this._lastCommand);
        pw.println(" Command Count : " + this._commandCounter);
    }

    @Override
    public void messageArrived(CellMessage msg) {
        Method[] methods;
        Serializable obj = msg.getMessageObject();
        this.println("");
        this.println(" CellMessage From   : " + msg.getSourcePath());
        this.println(" CellMessage To     : " + msg.getDestinationPath());
        this.println(" CellMessage Class  : " + obj.getClass().getName());
        Class<?> c = obj.getClass();
        for (Method method : methods = c.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class) || !method.getName().startsWith("get") || method.getParameterTypes().length > 0) continue;
            try {
                Object result = method.invoke((Object)obj, new Object[0]);
                this.println("    " + method.getName() + " -> " + result.toString());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.println("    " + method.getName() + " -> (???)");
            }
        }
        this.print(this.prompt());
    }
}

