/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui.realm;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.applets.login.DomainConnectionListener;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.services.gui.realm.JHistoryTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JCellPanel
extends JPanel
implements ActionListener,
DomainConnectionListener {
    private static final long serialVersionUID = -3612893682757173093L;
    private DomainConnection _connection;
    private String _address;
    private String _name;
    private CellInfo _cellInfo;
    private JLabel _label = new JLabel("Command");
    private JButton _button = new JButton("Info");
    private JTextField _text = new JHistoryTextField();
    private JTextArea _display = new JTextArea();
    private JLabel _cellName = new JLabel("<unknown>", 2);
    private JLabel _domainName = new JLabel("<unknown>", 2);

    public JCellPanel(DomainConnection connection) {
        this._connection = connection;
        BorderLayout l = new BorderLayout();
        l.setVgap(10);
        l.setHgap(10);
        this.setLayout(l);
        l = new BorderLayout();
        l.setVgap(10);
        l.setHgap(10);
        JPanel controller = new JPanel(l);
        l = new BorderLayout();
        l.setVgap(10);
        l.setHgap(10);
        JPanel tmp = new JPanel(l);
        tmp.add((Component)this._button, "West");
        tmp.add((Component)this._label, "Center");
        controller.add((Component)tmp, "West");
        controller.add((Component)this._text, "Center");
        this._text.addActionListener(this);
        JPanel titlePanel = new JPanel(new GridBagLayout());
        titlePanel.setOpaque(true);
        titlePanel.setBackground(Color.green);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 0;
        JLabel jl = new JLabel("Cell Name : ", 4);
        jl.setOpaque(true);
        jl.setBackground(Color.yellow);
        titlePanel.add((Component)jl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        this._cellName.setOpaque(true);
        this._cellName.setBackground(Color.blue);
        titlePanel.add((Component)this._cellName, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        jl = new JLabel("Domain Name : ", 4);
        jl.setOpaque(true);
        jl.setBackground(Color.yellow);
        titlePanel.add((Component)jl, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        this._domainName.setOpaque(true);
        this._domainName.setBackground(Color.blue);
        titlePanel.add((Component)this._domainName, gbc);
        this.add("North", titlePanel);
        this.add("Center", this._display);
        this.add("South", controller);
        this._button.addActionListener(this);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "Cell Controller", 1, 2), BorderFactory.createEmptyBorder(10, 10, 10, 10))));
    }

    public void setCell(String address, CellInfo info) {
        this._address = address;
        this._cellInfo = info;
        this._name = info.getCellName();
        this._cellName.setText(this._name);
        this._display.setText(info.getPrivatInfo());
        String tmp = this._address.substring(this._address.lastIndexOf(58) + 1);
        this._domainName.setText(tmp.substring(0, tmp.indexOf(64)));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._button) {
            this.updateCellInfo();
        } else if (source == this._text) {
            this.textArrived();
        }
    }

    private void textArrived() {
        String text = this._text.getText();
        this._text.setText("");
        try {
            this._connection.sendObject(this._address, (Serializable)((Object)text), this, 0);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void updateCellInfo() {
        try {
            this._connection.sendObject(this._address, (Serializable)((Object)("getcellinfo " + this._name)), this, 0);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    @Override
    public void domainAnswerArrived(Object obj, int subid) {
        this._display.setText(obj.toString());
    }
}

