/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui.realm;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.applets.login.DomainConnectionListener;
import dmg.cells.network.CellDomainNode;
import dmg.cells.nucleus.CellInfo;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class CellDomainTree
extends JTree {
    private static final long serialVersionUID = 8632929106052533043L;
    private DefaultMutableTreeNode _root = new DomainRootNode();
    private DefaultTreeModel _treeModel = new DefaultTreeModel(this._root);
    private DomainConnection _connection;
    private String _topoAddress = "topo@httpdDomain";

    public CellDomainTree(DomainConnection connection) {
        this._connection = connection;
        this.setModel(this._treeModel);
        this.collapseRow(0);
        this.addTreeExpansionListener(new DomainTreeExpansion());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "Cell Tree", 1, 2), BorderFactory.createEmptyBorder(10, 10, 10, 10))));
    }

    private class DomainTreeExpansion
    implements TreeExpansionListener {
        private DomainTreeExpansion() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            CellTreeNode node = (CellTreeNode)event.getPath().getLastPathComponent();
            node.expanded();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            System.out.println("Collapsed event : " + event.getPath());
        }
    }

    private class DomainRootNode
    extends CellTreeNode {
        private static final long serialVersionUID = -2017147296172009929L;
        private CellDomainNode[] _nodes;

        public DomainRootNode() {
            super("Realm", false);
        }

        @Override
        public void expanded() {
            if (!this.isValueSet()) {
                super.expanded();
                try {
                    CellDomainTree.this._connection.sendObject(CellDomainTree.this._topoAddress, (Serializable)((Object)"gettopomap"), this, 0);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.done();
                }
            }
        }

        @Override
        public void domainAnswerArrived(Object obj, int subid) {
            if (!(obj instanceof CellDomainNode[])) {
                return;
            }
            final DomainRootNode self = this;
            this._nodes = (CellDomainNode[])obj;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < DomainRootNode.this._nodes.length; ++i) {
                        CellDomainTree.this._treeModel.insertNodeInto(new CellDomainTreeNode(DomainRootNode.this._nodes[i]), self, i);
                    }
                    DomainRootNode.this.setValueSet(true);
                    DomainRootNode.this.done();
                }
            });
        }
    }

    private class CellContainerNode
    extends CellTreeNode {
        private static final long serialVersionUID = 3794317629384966493L;
        private CellDomainNode _node;
        private CellInfo[] _cellInfo;

        public CellContainerNode(String name, CellDomainNode node) {
            super(name, false);
            this._node = node;
        }

        @Override
        public void expanded() {
            if (!this.isValueSet()) {
                super.expanded();
                try {
                    CellDomainTree.this._connection.sendObject(this._node.getAddress(), (Serializable)((Object)"getcellinfos"), this, 0);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.done();
                }
            }
        }

        @Override
        public void domainAnswerArrived(Object obj, int subid) {
            System.out.println("CellContainerNode : " + obj.getClass().getName());
            if (!(obj instanceof CellInfo[])) {
                return;
            }
            final CellContainerNode self = this;
            this._cellInfo = (CellInfo[])obj;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int systemIndex = -1;
                    for (int i = 0; i < CellContainerNode.this._cellInfo.length; ++i) {
                        if (CellContainerNode.this._cellInfo[i].getCellName().equals("System")) {
                            systemIndex = i;
                            continue;
                        }
                        CellDomainTree.this._treeModel.insertNodeInto(new CellNode(CellContainerNode.this._node.getAddress(), CellContainerNode.this._cellInfo[i]), self, 0);
                    }
                    CellDomainTree.this._treeModel.insertNodeInto(new CellNode(CellContainerNode.this._node.getAddress(), CellContainerNode.this._cellInfo[systemIndex]), self, 0);
                    CellContainerNode.this.setValueSet(true);
                    CellContainerNode.this.done();
                }
            });
        }
    }

    private class ContextContainerNode
    extends CellTreeNode {
        private static final long serialVersionUID = 4649794381123797011L;
        private String[] _context;
        private CellDomainNode _node;

        public ContextContainerNode(String name, CellDomainNode node) {
            super(name, false);
            this._node = node;
        }

        @Override
        public void expanded() {
            if (!this.isValueSet()) {
                super.expanded();
                try {
                    CellDomainTree.this._connection.sendObject(this._node.getAddress(), (Serializable)((Object)"getcontext"), this, 0);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.done();
                }
            }
        }

        @Override
        public void domainAnswerArrived(Object obj, int subid) {
            if (!(obj instanceof String[])) {
                return;
            }
            final ContextContainerNode self = this;
            this._context = (String[])obj;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < ContextContainerNode.this._context.length; ++i) {
                        CellDomainTree.this._treeModel.insertNodeInto(new ContextNode(ContextContainerNode.this._context[i]), self, i);
                    }
                    ContextContainerNode.this.setValueSet(true);
                    ContextContainerNode.this.done();
                }
            });
        }
    }

    private class ContextNode
    extends CellTreeNode {
        private static final long serialVersionUID = 4917133149526146830L;

        public ContextNode(String name) {
            super(name, true);
        }
    }

    private class RouterNode
    extends CellTreeNode {
        private static final long serialVersionUID = -3709341083761440849L;

        public RouterNode(String name, CellDomainNode node) {
            super(name, true);
        }
    }

    public class CellNode
    extends CellTreeNode {
        private static final long serialVersionUID = 8523105175296824521L;
        private CellInfo _cellInfo;
        private String _address;

        private CellNode(String address, CellInfo info) {
            super(info.getCellName(), true);
            this._cellInfo = info;
            this._address = address;
        }

        public String getAddress() {
            return this._address;
        }

        public CellInfo getCellInfo() {
            return this._cellInfo;
        }
    }

    private class CellDomainTreeNode
    extends CellTreeNode {
        private static final long serialVersionUID = -4919824203352216297L;
        private CellDomainNode _node;

        public CellDomainTreeNode(CellDomainNode node) {
            super(node.getName(), false);
            this._node = node;
        }

        @Override
        public void expanded() {
            if (!this.isValueSet()) {
                super.expanded();
                CellDomainTree.this._treeModel.insertNodeInto(new CellContainerNode("CELLS", this._node), this, 0);
                CellDomainTree.this._treeModel.insertNodeInto(new ContextContainerNode("CONTEXT", this._node), this, 0);
                CellDomainTree.this._treeModel.insertNodeInto(new RouterNode("ROUTES", this._node), this, 0);
                this.done();
                this.setValueSet(true);
            }
        }
    }

    private class CellTreeNode
    extends DefaultMutableTreeNode
    implements DomainConnectionListener {
        private static final long serialVersionUID = -2869631713894791778L;
        private boolean _isLeaf;
        private boolean _valuesSet;
        private String _name;

        public CellTreeNode(String name, boolean isLeaf) {
            this._name = name;
            this._isLeaf = isLeaf;
            this.setUserObject(this);
        }

        @Override
        public void domainAnswerArrived(Object obj, int subid) {
        }

        public void expanded() {
            CellDomainTree.this.setEnabled(false);
            System.out.println("Expanded : " + this.toString());
        }

        public void done() {
            CellDomainTree.this.setEnabled(true);
        }

        @Override
        public boolean getAllowsChildren() {
            return !this._isLeaf;
        }

        @Override
        public boolean isLeaf() {
            return this._isLeaf;
        }

        @Override
        public String toString() {
            return this._name;
        }

        public boolean isValueSet() {
            return this._valuesSet;
        }

        public void setValueSet(boolean valueSet) {
            this._valuesSet = valueSet;
        }

        public void addDelayed(final CellTreeNode[] nodes) {
            final CellTreeNode self = this;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (CellTreeNode node : nodes) {
                                CellDomainTree.this._treeModel.insertNodeInto(node, self, 0);
                            }
                            CellTreeNode.this.setValueSet(true);
                            CellTreeNode.this.done();
                        }
                    });
                }
            }).start();
        }
    }
}

