/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.applets.login.DomainConnectionListener;
import dmg.cells.applets.login.DomainEventListener;
import dmg.cells.network.CellDomainNode;
import dmg.cells.services.gui.CanonicalTopology;
import dmg.cells.services.gui.MovingPigs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JPanel;

public class JSpyPanel
extends JPanel
implements DomainConnectionListener,
DomainEventListener {
    private static final long serialVersionUID = 1694178476101572170L;
    private DomainConnection _connection;
    private JButton _updateButton = new JButton("Update");
    private MovingPigs _canvas = new MovingPigs();
    private CanonicalTopology _topology;

    public JSpyPanel(DomainConnection connection) {
        this._connection = connection;
        BorderLayout l = new BorderLayout();
        l.setVgap(10);
        l.setHgap(10);
        this.setLayout(l);
        this._connection.addDomainEventListener(this);
        this._updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JSpyPanel.this.request();
            }
        });
        this.add((Component)this._updateButton, "North");
        this.add((Component)this._canvas, "Center");
    }

    private void request() {
        try {
            this._connection.sendObject("topo", (Serializable)((Object)"gettopomap"), this, 5);
        }
        catch (Exception ee) {
            System.err.println("Problem sending request : " + ee);
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    @Override
    public void connectionOpened(DomainConnection connection) {
        System.out.println("Connection opened");
        this.request();
    }

    @Override
    public void connectionClosed(DomainConnection connection) {
        System.out.println("Connection closed");
    }

    @Override
    public void connectionOutOfBand(DomainConnection connection, Object obj) {
        System.out.println("Connection connectionOutOfBand " + obj);
    }

    private void display() {
        for (int i = 0; i < this._topology.domains(); ++i) {
            String domain = this._topology.getDomain(i);
            System.out.println("New Domain : " + domain);
            this._canvas.getItem(domain, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void domainAnswerArrived(Object obj, int subid) {
        System.out.println("Answer (" + subid + ") : " + obj.toString());
        CellDomainNode[] cdn = (CellDomainNode[])obj;
        CanonicalTopology ct = new CanonicalTopology(cdn);
        JSpyPanel jSpyPanel = this;
        synchronized (jSpyPanel) {
            if (this._topology == null) {
                this._topology = ct;
                this.display();
                return;
            }
            if (this._topology.equals(ct)) {
                return;
            }
            this._topology = ct;
            this.display();
        }
    }
}

