/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services.gui;

import dmg.cells.applets.login.DomainConnection;
import dmg.cells.applets.login.DomainEventListener;
import dmg.cells.services.gui.JCommander;
import dmg.cells.services.gui.JSpyPanel;
import dmg.cells.services.gui.JSshLoginPanel;
import dmg.cells.services.gui.realm.JRealm;
import dmg.util.Args;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.Timer;

public class JLogin
extends JFrame {
    private static final long serialVersionUID = 1103652404120194380L;
    private Timer _timer;
    private JSshLoginPanel _login = new JSshLoginPanel();
    private DomainConnection _domain = this._login.getDomainConnection();
    private JTabbedPane _tab = new JTabbedPane();

    public JLogin(String title, String[] argvector) {
        super(title);
        this.setBackground(Color.blue);
        final Container c = this.getContentPane();
        Args args = new Args(argvector);
        String tmp = args.getOpt("host");
        this._login.setHostname(tmp == null ? "localhost" : tmp);
        tmp = args.getOpt("port");
        this._login.setPortnumber(tmp == null ? "24223" : tmp);
        Class[] classArgs = new Class[]{DomainConnection.class};
        Object[] objectArgs = new Object[]{this._domain};
        if (args.argc() > 0) {
            int j = args.argc();
            for (int i = 0; i < j; ++i) {
                try {
                    StringTokenizer st = new StringTokenizer(args.argv(i), "=");
                    String name = st.nextToken();
                    String className = st.nextToken();
                    Class<JPanel> cn = Class.forName(className).asSubclass(JPanel.class);
                    Constructor<JPanel> cc = cn.getConstructor(classArgs);
                    JPanel cp = cc.newInstance(objectArgs);
                    this._tab.addTab("   " + name + "   ", cp);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Can't init " + args.argv(i) + " : " + e);
                }
            }
        } else {
            this._tab.addTab("   Commander   ", new JCommander(this._domain));
            this._tab.addTab("   Spy   ", new JSpyPanel(this._domain));
            this._tab.addTab("   Realm   ", new JRealm(this._domain));
        }
        this._tab.setSelectedIndex(0);
        c.setLayout(new GridBagLayout());
        c.add(this._login);
        this._domain.addDomainEventListener(new DomainEventListener(){

            @Override
            public void connectionOpened(DomainConnection connection) {
                System.out.println("Connection opened");
                c.removeAll();
                c.setLayout(new BorderLayout());
                c.add((Component)JLogin.this._tab, "Center");
                c.invalidate();
                c.doLayout();
                JLogin.this.repaint();
            }

            @Override
            public void connectionClosed(DomainConnection connection) {
                System.out.println("Connection closed");
                c.removeAll();
                c.setLayout(new GridBagLayout());
                c.add(JLogin.this._login);
                c.invalidate();
                c.doLayout();
                JLogin.this.repaint();
            }

            @Override
            public void connectionOutOfBand(DomainConnection connection, Object obj) {
                System.out.println("Connection connectionOutOfBand");
            }
        });
    }

    public static void main(String[] argv) throws Exception {
        PrintStream devnull = new PrintStream(new FileOutputStream("/dev/null"));
        System.setErr(devnull);
        System.setOut(devnull);
        JLogin f = new JLogin("Cell Login", argv);
        f.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int w = 200;
        int h = 200;
        f.setLocation(100, 100);
        f.setSize(600, 400);
        f.setVisible(true);
    }
}

