/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.services.SetupInfoMessage;
import dmg.util.Args;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupManager
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(SetupManager.class);
    private String _cellName;
    private Args _args;
    private CellNucleus _nucleus;
    private String _defaultClass;
    private String _configDirectory;
    private File _config;
    public static final String hh_ls_setup = "<class> <name>";
    public static final String hh_ls_class = "[<className>]";

    public SetupManager(String cellName, String args) throws Exception {
        super(cellName, args, false);
        this._cellName = cellName;
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        try {
            if (this._args.argc() == 0) {
                throw new IllegalArgumentException("Config directory not specified");
            }
            this._configDirectory = this._args.argv(0);
            this._config = new File(this._configDirectory);
            if (!this._config.isDirectory()) {
                throw new IllegalArgumentException("Config directory not found : " + this._config);
            }
            this._defaultClass = this._args.getOpt("defaultClass");
            this._defaultClass = this._defaultClass == null ? "default" : this._defaultClass;
            _log.info("defaultClass set to '" + this._defaultClass + "'");
        }
        catch (Exception ee) {
            this.start();
            this.kill();
            throw ee;
        }
        this.useInterpreter(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSetup(SetupInfoMessage info) throws Exception {
        String className = info.getSetupClass();
        String name = info.getSetupName();
        if (name == null) {
            throw new IllegalArgumentException("No Setup name specified");
        }
        File classDir = new File(this._config, className = className == null ? "default" : className);
        if (!classDir.isDirectory()) {
            throw new NoSuchElementException("class:" + className);
        }
        File setupFile = new File(classDir, name);
        if (!setupFile.exists() && !(setupFile = new File(classDir, "default")).exists()) {
            throw new NoSuchElementException(classDir.getName() + ":" + name);
        }
        BufferedReader br = new BufferedReader(new FileReader(setupFile));
        StringBuilder sb = new StringBuilder();
        try {
            String buffer;
            while ((buffer = br.readLine()) != null) {
                sb.append(buffer).append("\n");
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ee) {}
        }
        info.setPayload(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putSetup(SetupInfoMessage info) throws IOException {
        String className = info.getSetupClass();
        String name = info.getSetupName();
        Serializable payload = info.getPayload();
        if (name == null) {
            throw new IllegalArgumentException("No Setup name specified");
        }
        if (payload == null) {
            throw new IllegalArgumentException("No payload");
        }
        File classDir = new File(this._config, className = className == null ? "default" : className);
        if (!classDir.isDirectory()) {
            classDir.mkdir();
            if (!classDir.isDirectory()) {
                throw new IOException("can't create class:" + className);
            }
        }
        File setupFile = new File(classDir, name);
        PrintWriter pw = new PrintWriter(new FileWriter(setupFile));
        try {
            pw.print(payload.toString());
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception ee) {}
        }
    }

    public String ac_test_$_2(Args args) throws Exception {
        String className = args.argv(0);
        String name = args.argv(1);
        SetupInfoMessage info = new SetupInfoMessage(name, className);
        CellMessage reply = this.sendAndWait(new CellMessage(new CellPath("setupManager"), info), 10000L);
        if (reply == null) {
            throw new Exception("Request timed out");
        }
        info = (SetupInfoMessage)reply.getMessageObject();
        Serializable obj = info.getPayload();
        if (obj == null) {
            throw new Exception("No payload");
        }
        if (obj instanceof Exception) {
            throw (Exception)obj;
        }
        return obj.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_ls_setup_$_2(Args args) throws Exception {
        String className = args.argv(0);
        String name = args.argv(1);
        File classDir = new File(this._config, className);
        if (!classDir.isDirectory()) {
            throw new IllegalArgumentException("Class not found : " + className);
        }
        File setupFile = new File(classDir, name);
        if (!setupFile.exists()) {
            throw new IllegalArgumentException("Setup not found in class >" + className + "< : " + name);
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(setupFile));
        try {
            String buffer;
            while ((buffer = br.readLine()) != null) {
                sb.append(buffer).append("\n");
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ee) {}
        }
        return sb.toString();
    }

    public String ac_ls_class_$_0_1(Args args) {
        File[] fileList;
        StringBuilder sb = new StringBuilder();
        if (args.argc() == 0) {
            File[] fileList2;
            for (File file : fileList2 = this._config.listFiles(new FileFilter(){

                @Override
                public boolean accept(File filepath) {
                    return filepath.isDirectory();
                }
            })) {
                sb.append(file.getName()).append("\n");
            }
            return sb.toString();
        }
        String className = args.argv(0);
        File classDir = new File(this._config, className);
        if (!classDir.isDirectory()) {
            throw new IllegalArgumentException("Class not found : " + className);
        }
        for (File file : fileList = classDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File filepath) {
                return filepath.isFile();
            }
        })) {
            sb.append(file.getName()).append("\n");
        }
        return sb.toString();
    }

    private void removeSetup(SetupInfoMessage info) {
    }

    @Override
    public void messageArrived(CellMessage message) {
        block8: {
            Serializable obj = message.getMessageObject();
            SetupInfoMessage info = null;
            try {
                if (!(obj instanceof SetupInfoMessage)) break block8;
                info = (SetupInfoMessage)obj;
                if (info.getAction() == null) {
                    throw new IllegalArgumentException("Action not defined");
                }
                if (info.getAction().equals("get")) {
                    this.getSetup(info);
                    break block8;
                }
                if (info.getAction().equals("put")) {
                    this.putSetup(info);
                    break block8;
                }
                if (info.getAction().equals("remove")) {
                    this.removeSetup(info);
                    break block8;
                }
                throw new IllegalArgumentException("Action not defined : " + info.getAction());
            }
            catch (Exception ee) {
                info.setPayload(ee);
            }
        }
        try {
            message.revertDirection();
            this.sendMessage(message);
        }
        catch (Exception ee) {
            _log.warn("Problems sending reply to " + message);
        }
    }
}

