/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellNucleus;
import dmg.util.Args;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryWatch
extends CellAdapter
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(MemoryWatch.class);
    private CellNucleus _nucleus;
    private Args _args;
    private long _update = 10L;
    private final Object _lock = new Object();
    private Thread _queryThread;
    private Runtime _runtime = Runtime.getRuntime();
    private boolean _output;
    private String _outputFile;
    private int _generations = 2;
    private int _current;
    private int _maxFileSize = 0x100000;
    public static final String hh_set_generations = "<outputfileGenerations(1...10)>";
    public static final String hh_set_maxFilesize = "<output filesize limit(>10k)>";
    public static final String hh_set_output = "off|on|<filename>";
    public static final String hh_set_update = "<updateTime/sec>";

    public MemoryWatch(String name, String args) throws Exception {
        super(name, args, false);
        this._nucleus = this.getNucleus();
        try {
            this._args = this.getArgs();
            String var = this._args.getOpt("update");
            if (var != null) {
                try {
                    this._update = Integer.parseInt(var);
                }
                catch (Exception ee) {
                    _log.warn("Update not accepted : " + var);
                }
            }
            if ((var = this._args.getOpt("maxFilesize")) != null) {
                try {
                    this._maxFileSize = Integer.parseInt(var);
                }
                catch (Exception ee) {
                    _log.warn("New 'maxFilesize' not accepted : " + var);
                }
            }
            if ((var = this._args.getOpt("generations")) != null) {
                try {
                    this._generations = Integer.parseInt(var);
                }
                catch (Exception ee) {
                    _log.warn("New 'generations' not accepted : " + var);
                }
            }
            if ((var = this._args.getOpt("output")) != null) {
                this._output = true;
                if (!var.equals("")) {
                    this._outputFile = var;
                }
            }
            this._queryThread = this._nucleus.newThread(this, "queryThread");
            this._queryThread.start();
        }
        catch (Exception eex) {
            this.start();
            this.kill();
            throw eex;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void say(String str) {
        if (this._output) {
            if (this._outputFile != null) {
                try {
                    PrintWriter pw;
                    String name = this._outputFile + "." + this._current % this._generations;
                    File f = new File(name);
                    if (f.exists() && f.length() > (long)this._maxFileSize) {
                        ++this._current;
                        name = this._outputFile + "." + this._current % this._generations;
                        pw = new PrintWriter(new FileWriter(name, false));
                    } else {
                        pw = new PrintWriter(new FileWriter(name, true));
                    }
                    try {
                        pw.println(str);
                    }
                    catch (Exception ee) {
                    }
                    finally {
                        try {
                            pw.close();
                        }
                        catch (Exception eeee) {}
                    }
                }
                catch (Exception exception) {}
            } else {
                _log.info(str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"DM_GC"}, justification="Although bad practice, the GC call is part of the design of the cell")
    public void run() {
        while (!Thread.interrupted()) {
            this._runtime.gc();
            long fm = this._runtime.freeMemory();
            long tm = this._runtime.totalMemory();
            this.say(" free " + fm + " total " + tm + " used " + (tm - fm) + " " + new Date().toString());
            try {
                long update;
                Object object = this._lock;
                synchronized (object) {
                    update = this._update * 1000L;
                }
                Thread.sleep(update);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.say("Update thread finished");
    }

    @Override
    public void getInfo(PrintWriter pw) {
        super.getInfo(pw);
        pw.println("Output  : " + (this._output ? "" + (this._outputFile == null ? "<stdout>" : this._outputFile) : "disabled"));
        pw.println("Update  : " + this._update + " seconds");
    }

    public String ac_set_generations_$_1(Args args) {
        int g = Integer.parseInt(args.argv(0));
        if (g < 1 || g > 10) {
            throw new IllegalArgumentException("Generations not in range (1...10)");
        }
        this._generations = g;
        return "OutputFile generations = " + this._generations;
    }

    public String ac_set_maxFilesize_$_1(Args args) {
        int g = Integer.parseInt(args.argv(0));
        if (g < 1024) {
            throw new IllegalArgumentException("maxFilesize not in range (>1k)");
        }
        this._maxFileSize = g;
        return "Maximum output filesize = " + this._maxFileSize;
    }

    public String ac_set_output_$_1(Args args) {
        String what;
        switch (what = args.argv(0)) {
            case "off": {
                this._output = false;
                this._outputFile = null;
                break;
            }
            case "on": {
                this._output = true;
                this._outputFile = null;
                break;
            }
            default: {
                this._outputFile = what;
                this._output = true;
            }
        }
        return "Output " + (this._output ? "set to " + (this._outputFile == null ? "stdout" : this._outputFile) : "disabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ac_set_update_$_1(Args args) throws NumberFormatException {
        Object object = this._lock;
        synchronized (object) {
            this._update = Integer.parseInt(args.argv(0));
        }
        return "Update time set to " + this._update + " seconds";
    }

    public String ac_gc(Args args) {
        this._runtime.gc();
        return "";
    }
}

