/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellRoute;
import dmg.util.Args;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationManager
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(LocationManager.class);
    private DatagramSocket _socket;
    private Server _server;
    private Client _client;
    private Args _args = this.getArgs();
    private CellNucleus _nucleus = this.getNucleus();

    public LocationManager(String name, String args) throws Exception {
        super(name, "System", args, false);
        try {
            InetAddress host;
            int port;
            if (this._args.argc() < 1) {
                throw new IllegalArgumentException("Usage : ... [<host>] <port> [-noclient] [-clientPort=<UDP port number>]");
            }
            if (this._args.argc() == 1) {
                port = Integer.parseInt(this._args.argv(0));
                host = InetAddress.getByName("localhost");
                this._server = new Server(port, this._args);
                _log.info("Server Setup Done");
            } else {
                port = Integer.parseInt(this._args.argv(1));
                host = InetAddress.getByName(this._args.argv(0));
            }
            if (!this._args.hasOption("noclient")) {
                this._client = new Client(host, port, this._args);
                _log.info("Client started");
            }
        }
        catch (IOException | IllegalArgumentException e) {
            this.start();
            this.kill();
            throw e;
        }
        catch (RuntimeException e) {
            _log.warn(e.toString(), (Throwable)e);
            this.start();
            this.kill();
            throw e;
        }
        this.start();
        if (this._server != null) {
            this._server.start();
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        if (this._client != null) {
            pw.println("Client\n--------");
            this._client.getInfo(pw);
        }
        if (this._server != null) {
            pw.println("Server\n--------");
            this._server.getInfo(pw);
        }
    }

    @Override
    public void cleanUp() {
        if (this._server != null) {
            this._server.shutdown();
        }
        if (this._client != null) {
            this._client.shutdown();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._client != null) {
            sb.append(this._client.toString()).append(this._server != null ? ";" : "");
        }
        if (this._server != null) {
            sb.append(this._server.toString());
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            throw new IllegalArgumentException("Usage : ... <host> <port> <message>");
        }
        InetAddress address = InetAddress.getByName(args[0]);
        int port = Integer.parseInt(args[1]);
        String message = args[2];
        new XXClient(address, port, message);
        System.exit(0);
    }

    static class XXClient {
        XXClient(InetAddress address, int port, String message) throws Exception {
            byte[] data = message.getBytes();
            DatagramPacket packet = new DatagramPacket(data, data.length, address, port);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            packet = new DatagramPacket(new byte[1024], 1024);
            socket.receive(packet);
            data = packet.getData();
            System.out.println(new String(data, 0, data.length));
        }
    }

    public class Client
    implements Runnable {
        private Thread _receiver;
        private Thread _whatToDo;
        private String _toDo;
        private String _registered;
        private int _state;
        private int _requestsReceived;
        private int _repliesSent;
        private int _totalExceptions;
        private LocationManagerHandler _lmHandler;

        private Client(InetAddress address, int port, Args args) throws SocketException {
            LocationManager.this.addCommandListener(this);
            int clientPort = 0;
            if (args.hasOption("clientPort")) {
                clientPort = Integer.parseInt(args.getOption("clientPort"));
            }
            this._lmHandler = new LocationManagerHandler(clientPort, address, port);
            this._lmHandler.start();
            if (!args.hasOption("noboot")) {
                this._whatToDo = LocationManager.this._nucleus.newThread(this, "WhatToDo");
                this._whatToDo.start();
            }
        }

        public void getInfo(PrintWriter pw) {
            pw.println("            ToDo : " + (this._state > -1 ? "Still Busy (" + this._state + ")" : this._toDo));
            pw.println("      Registered : " + (this._registered == null ? "no" : this._registered));
            pw.println("RequestsReceived : " + this._requestsReceived);
            pw.println("    RequestsSent : " + this._lmHandler.getRequestsSent());
            pw.println(" RepliesReceived : " + this._lmHandler.getRepliesReceived());
            pw.println("     RepliesSent : " + this._repliesSent);
            pw.println("     Exceptions  : " + this._totalExceptions);
        }

        public String toString() {
            return "" + (this._state > -1 ? "Client<init>(" + this._state + ")" : "ClientReady");
        }

        public String ac_where_is_$_1(Args args) {
            ++this._requestsReceived;
            String domainName = args.argv(0);
            LocationManager.this._nucleus.newThread(new BackgroundServerRequest("whereIs " + domainName, CellAdapter.getThisMessage()), "where-is").start();
            return null;
        }

        public String ac_listening_on_$_2(Args args) {
            CellMessage msg = CellAdapter.getThisMessage();
            String portString = args.argv(1);
            try {
                this._registered = InetAddress.getLocalHost().getHostName() + ":" + portString;
            }
            catch (UnknownHostException uhe) {
                _log.warn("Couldn't resolve hostname : " + uhe);
                return null;
            }
            String request = "listeningOn " + LocationManager.this.getCellDomainName() + " " + this._registered;
            ++this._requestsReceived;
            LocationManager.this._nucleus.newThread(new BackgroundServerRequest(request, msg)).start();
            return null;
        }

        private void startListener(int port, String securityContext) throws Exception {
            String cellName = "l*";
            String inetClass = "dmg.cells.services.login.LoginManager";
            String cellClass = "dmg.cells.network.LocationMgrTunnel";
            String protocol = securityContext == null || securityContext.length() == 0 || securityContext.equalsIgnoreCase("none") ? "-prot=raw" : (securityContext.equalsIgnoreCase("ssh") || securityContext.equalsIgnoreCase("ssh1") ? "-prot=ssh -auth=dmg.cells.services.login.SshSAuth_A" : securityContext);
            String cellArgs = "" + port + " " + cellClass + " " + protocol + " -lm=" + LocationManager.this.getCellName();
            _log.info(" LocationManager starting acceptor with " + cellArgs);
            Cell c = LocationManager.this._nucleus.createNewCell(inetClass, cellName, cellArgs, true);
            _log.info("Created : " + c);
        }

        private void startConnector(String remoteDomain) throws Exception {
            String cellName = "c-" + remoteDomain + "*";
            String cellClass = "dmg.cells.network.LocationManagerConnector";
            String clientKey = LocationManager.this._args.getOpt("clientKey");
            clientKey = clientKey != null && clientKey.length() > 0 ? "-clientKey=" + clientKey : "";
            String clientName = LocationManager.this._args.getOpt("clientUserName");
            clientName = clientName != null && clientName.length() > 0 ? "-clientUserName=" + clientName : "";
            String cellArgs = "-domain=" + remoteDomain + " " + "-lm=" + LocationManager.this.getCellName() + " " + clientKey + " " + clientName;
            _log.info("LocationManager starting connector with " + cellArgs);
            Cell c = LocationManager.this._nucleus.createNewCell(cellClass, cellName, cellArgs, true);
            _log.info("Created : " + c);
        }

        private void setDefaultRoute(String domain) {
            LocationManager.this._nucleus.routeAdd(new CellRoute(null, "*@" + domain, 4));
        }

        @Override
        public void run() {
            if (Thread.currentThread() == this._whatToDo) {
                this.runWhatToDo();
            }
        }

        private void runWhatToDo() {
            String request = "whatToDo " + LocationManager.this.getCellDomainName();
            while (true) {
                ++this._state;
                try {
                    String reply = this._lmHandler.askServer(request, 5000L);
                    _log.info("whatToDo got : " + reply);
                    Args args = new Args(reply);
                    if (args.argc() < 2) {
                        throw new IllegalArgumentException("No enough arg. : " + reply);
                    }
                    if (!args.argv(0).equals("do") || !args.argv(1).equals(LocationManager.this.getCellDomainName()) && !args.argv(1).equals("*")) {
                        throw new IllegalArgumentException("Not a 'do' or not for us : " + reply);
                    }
                    if (args.argc() == 2) {
                        _log.info("Nothing to do for us");
                        return;
                    }
                    this.executeToDoList(args);
                    this._toDo = reply;
                    this._state = -1;
                    return;
                }
                catch (InterruptedException ie) {
                    this._toDo = "whatToDo : interrupted";
                    _log.warn("whatToDo : interrupted");
                    break;
                }
                catch (InterruptedIOException ie) {
                    this._toDo = "whatToDo : interrupted(io)";
                    _log.warn("whatToDo : interrupted(io)");
                    break;
                }
                catch (Exception ee) {
                    this._toDo = "whatToDo : exception : " + ee;
                    _log.warn(this._toDo);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException iie) {
                        this._toDo = "whatToDo : interrupted sleep";
                        _log.warn("whatToDo : interrupted sleep");
                        break;
                    }
                }
            }
            _log.info("whatToDo finished");
        }

        private void executeToDoList(Args args) throws Exception {
            for (int i = 2; i < args.argc(); ++i) {
                String arg = args.argv(i);
                try {
                    if (arg.startsWith("l")) {
                        String tmp;
                        int port = 0;
                        StringTokenizer st = new StringTokenizer(arg, ":");
                        st.nextToken();
                        if (st.hasMoreTokens() && (tmp = st.nextToken()).length() > 0) {
                            try {
                                port = Integer.parseInt(tmp);
                            }
                            catch (Exception e) {
                                _log.warn("Got illegal port numnber <" + arg + ">, using random");
                            }
                        }
                        String securityContext = null;
                        if (st.hasMoreTokens()) {
                            securityContext = st.nextToken();
                        }
                        this.startListener(port, securityContext);
                        continue;
                    }
                    if (arg.length() > 2 && arg.startsWith("c:")) {
                        this.startConnector(arg.substring(2));
                        continue;
                    }
                    if (arg.length() <= 2 || !arg.startsWith("d:")) continue;
                    this.setDefaultRoute(arg.substring(2));
                    continue;
                }
                catch (InterruptedIOException | InterruptedException ioee) {
                    throw ioee;
                }
                catch (Exception ee) {
                    _log.warn("Command >" + arg + "< received : " + ee);
                }
            }
        }

        public void shutdown() {
            this._lmHandler.shutdown();
        }

        private class BackgroundServerRequest
        implements Runnable {
            private String _request;
            private CellMessage _message;

            private BackgroundServerRequest(String request, CellMessage message) {
                this._request = request;
                this._message = message;
            }

            @Override
            public void run() {
                try {
                    String reply = Client.this._lmHandler.askServer(this._request, 4000L);
                    this._message.setMessageObject((Serializable)((Object)reply));
                    this._message.revertDirection();
                    LocationManager.this.sendMessage(this._message);
                    Client.this._repliesSent++;
                }
                catch (Exception ee) {
                    _log.warn("Problem in 'whereIs' request : " + ee);
                    Client.this._totalExceptions++;
                }
            }
        }
    }

    private class LocationManagerHandler
    implements Runnable {
        private DatagramSocket _socket;
        private Map<Integer, StringBuffer> _map = new HashMap<Integer, StringBuffer>();
        private int _serial;
        private InetAddress _address;
        private int _port;
        private Thread _thread;
        private int _requestsSent;
        private int _repliesReceived;

        private LocationManagerHandler(int localPort, InetAddress address, int port) throws SocketException {
            this._port = port;
            this._socket = new DatagramSocket(localPort);
            this._address = address;
            this._thread = LocationManager.this._nucleus.newThread(this, "LocationManagerHandler");
        }

        public void start() {
            this._thread.start();
        }

        public int getRequestsSent() {
            return this._requestsSent;
        }

        public int getRepliesReceived() {
            return this._repliesReceived;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    DatagramPacket packet = new DatagramPacket(new byte[1024], 1024);
                    this._socket.receive(packet);
                    byte[] data = packet.getData();
                    int packLen = packet.getLength();
                    if (data == null || packLen == 0) {
                        _log.warn("Zero packet received");
                        continue;
                    }
                    Args a = new Args(new String(data, 0, packLen));
                    String tmp = a.getOpt("serial");
                    if (tmp == null) {
                        _log.warn("Packet didn't provide a serial number");
                        continue;
                    }
                    Integer s = Integer.valueOf(tmp);
                    StringBuffer b = this._map.get(s);
                    if (b == null) {
                        _log.warn("Not waiting for " + s);
                        continue;
                    }
                    _log.info("Reasonable reply arrived (" + s + ") : " + b);
                    StringBuffer stringBuffer = b;
                    synchronized (stringBuffer) {
                        b.append(a.toString());
                        b.notifyAll();
                    }
                }
                catch (InterruptedIOException e) {
                    Thread.currentThread().interrupt();
                }
                catch (SocketException e) {
                    if (Thread.currentThread().isInterrupted()) continue;
                    _log.warn("Receiver socket problem : " + e.getMessage());
                }
                catch (IOException e) {
                    _log.warn("Receiver IO problem : " + e.getMessage());
                }
            }
            _log.info("Receiver thread finished");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String askServer(String message, long waitTime) throws IOException, InterruptedException {
            int serial;
            ++this._requestsSent;
            LocationManagerHandler locationManagerHandler = this;
            synchronized (locationManagerHandler) {
                serial = this._serial++;
            }
            byte[] data = (message + " -serial=" + serial).getBytes();
            StringBuffer b = new StringBuffer();
            Integer s = serial;
            long start = System.currentTimeMillis();
            _log.info("Sending to " + this._address + ":" + this._port + " : " + new String(data, 0, data.length));
            StringBuffer stringBuffer = b;
            synchronized (stringBuffer) {
                long now;
                DatagramPacket packet = new DatagramPacket(data, data.length, this._address, this._port);
                this._map.put(s, b);
                this._socket.send(packet);
                for (long rest = waitTime; rest > 0L; rest -= now - start) {
                    b.wait(rest);
                    if (b.length() > 0) {
                        ++this._repliesReceived;
                        this._map.remove(s);
                        return b.toString();
                    }
                    now = System.currentTimeMillis();
                    start = now;
                }
                this._map.remove(s);
            }
            throw new IOException("Request timed out");
        }

        public void shutdown() {
            this._thread.interrupt();
            this._socket.close();
        }
    }

    public class Server
    implements Runnable {
        private final Map<String, NodeInfo> _nodeDb = new HashMap<String, NodeInfo>();
        private int _port;
        private DatagramSocket _socket;
        private Thread _worker;
        private boolean _strict = true;
        private int _requestsReceived;
        private int _repliesSent;
        private int _totalExceptions;
        private static final int SETUP_NONE = -2;
        private static final int SETUP_ERROR = -1;
        private static final int SETUP_AUTO = 0;
        private static final int SETUP_WRITE = 1;
        private static final int SETUP_RDONLY = 2;
        private int _setupMode = -2;
        private String _setupFileName;
        private File _setupFile;
        private File _permFile;
        private final String[] __mode2string = new String[]{"none", "error", "auto", "rw", "rdonly"};
        public static final String hh_ls_perm = " # list permanent file";
        public static final String hh_setup_define = "<filename> [-mode=rw|rdonly|auto]";
        public static final String hh_setup_read = "";
        public static final String hh_setup_write = "";
        public static final String hh_define = "<domainName>";
        public static final String hh_undefine = "<domainName>";
        public static final String hh_nodefaultroute = "<sourceDomainName>";
        public static final String hh_defaultroute = "<sourceDomainName> <destinationDomainName>";
        public static final String hh_connect = "<sourceDomainName> <destinationDomainName>";
        public static final String hh_disconnect = "<sourceDomainName> <destinationDomainName>";
        public static final String hh_listen = "<listenDomainName> [...] [-port=<portNumber>] [-security=<security>]";
        public static final String hh_unlisten = "<listenDomainName> [...]";
        public static final String hh_ls_setup = "";
        public static final String hh_ls_node = "[<domainName>]";
        public static final String hh_set_address = "<domainname> <address>";
        public static final String hh_unset_address = "<domainname>";
        public static final String hh_clear_server = "";
        public static final String hh_whatToDo = "<domainName>";
        public static final String hh_whereIs = "<domainName>";
        public static final String hh_listeningOn = "<domainName> <address>";

        private Server(int port, Args args) throws Exception {
            this._port = port;
            LocationManager.this.addCommandListener(this);
            String strict = args.getOpt("strict");
            if (strict == null) {
                this._strict = true;
            } else if (strict.equals("off") || strict.equals("no")) {
                this._strict = false;
            }
            this.prepareSetup(args.getOpt("setup"), args.getOpt("setupmode"));
            if (this._setupMode == 1 || this._setupMode == 2) {
                this.execSetupFile(this._setupFile);
            }
            this.preparePersistentMap(args.getOpt("perm"));
            try {
                this.loadPersistentMap();
            }
            catch (Exception dd) {
                // empty catch block
            }
            this._socket = new DatagramSocket(this._port);
            this._worker = LocationManager.this._nucleus.newThread(this, "Server");
        }

        private void preparePersistentMap(String permFileName) throws Exception {
            if (permFileName == null || permFileName.length() < 1) {
                return;
            }
            File permFile = new File(permFileName);
            if (permFile.exists()) {
                if (!permFile.canWrite()) {
                    throw new IllegalArgumentException("Can't write to : " + permFileName);
                }
                this._permFile = permFile;
            } else {
                if (!permFile.createNewFile()) {
                    throw new IllegalArgumentException("Can't create : " + permFileName);
                }
                this._permFile = permFile;
            }
            _log.info("Persistent map file set to : " + this._permFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void loadPersistentMap() throws Exception {
            if (this._permFile == null) {
                return;
            }
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this._permFile));
            _log.info("Loading persistent map file");
            try {
                HashMap hm = (HashMap)in.readObject();
                _log.info("Persistent map : " + hm);
                for (Map.Entry node_and_address : hm.entrySet()) {
                    String node = (String)node_and_address.getKey();
                    String address = (String)node_and_address.getValue();
                    NodeInfo info = this.getInfo(node, true);
                    if (info == null) continue;
                    info.setAddress(node);
                    _log.info("Updated : <" + node + "> -> " + address);
                }
            }
            catch (Exception ee) {
                _log.warn("Problem reading persistent map " + ee.getMessage());
                this._permFile.delete();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void savePersistentMap() {
            if (this._permFile == null) {
                return;
            }
            HashMap<String, String> hm = new HashMap<String, String>();
            for (NodeInfo info : this._nodeDb.values()) {
                String address = info.getAddress();
                if (address == null || !info.mustListen()) continue;
                hm.put(info.getDomainName(), info.getAddress());
            }
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new FileOutputStream(this._permFile));
                out.writeObject(hm);
            }
            catch (Exception e) {
                _log.warn("Problem writing persistent map " + e.getMessage());
                this._permFile.delete();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void prepareSetup(String setupFile, String setupMode) throws Exception {
            this._setupFileName = setupFile;
            if (this._setupFileName == null) {
                this._setupMode = -2;
                return;
            }
            String tmp = setupMode;
            int n = tmp == null ? 0 : (tmp.equals("rw") ? 1 : (tmp.equals("rdonly") ? 2 : (this._setupMode = tmp.equals("auto") ? 0 : -1)));
            if (this._setupMode == -1) {
                throw new IllegalArgumentException("Setup error, don't understand : " + this._setupMode);
            }
            this._setupFile = new File(this._setupFileName);
            boolean fileExists = this._setupFile.exists();
            boolean canWrite = this._setupFile.canWrite();
            boolean canRead = this._setupFile.canRead();
            if (fileExists && !this._setupFile.isFile()) {
                throw new IllegalArgumentException("Not a file: " + this._setupFileName);
            }
            if (this._setupMode == 0) {
                if (fileExists) {
                    this._setupMode = canWrite ? 1 : 2;
                } else {
                    try {
                        this._setupFile.createNewFile();
                        this._setupMode = 1;
                    }
                    catch (IOException e) {
                        _log.debug("Failed to create {}: {}", (Object)this._setupFile, (Object)e);
                        this._setupMode = -2;
                    }
                }
            }
            switch (this._setupMode) {
                case 1: {
                    if (fileExists) {
                        if (canWrite) break;
                        throw new IllegalArgumentException("File not writeable: " + this._setupFileName);
                    }
                    this._setupFile.createNewFile();
                    break;
                }
                case 2: {
                    if (!fileExists) {
                        this._setupMode = -2;
                        break;
                    }
                    if (canRead) break;
                    throw new IllegalArgumentException("Setup file not readable: " + this._setupFileName);
                }
            }
            if (this._setupMode == -2) {
                this._setupFileName = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execSetupFile(File setupFile) throws Exception {
            BufferedReader br = new BufferedReader(new FileReader(setupFile));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.length() < 1 || line.charAt(0) == '#') continue;
                    _log.info("Exec : " + line);
                    LocationManager.this.command(new Args(line));
                }
            }
            catch (EOFException eof) {
            }
            catch (Exception ef) {
                _log.warn("Ups : " + ef);
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception ce) {}
            }
        }

        public void getInfo(PrintWriter pw) {
            pw.println("         Version : $Id: LocationManager.java,v 1.15 2007-10-22 12:30:38 behrmann Exp $");
            pw.println("      # of nodes : " + this._nodeDb.size());
            pw.println("RequestsReceived : " + this._requestsReceived);
            pw.println("     RepliesSent : " + this._repliesSent);
            pw.println("     Exceptions  : " + this._totalExceptions);
        }

        public String toString() {
            return "Server:Nodes=" + this._nodeDb.size() + ";Reqs=" + this._requestsReceived;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                DatagramPacket packet;
                try {
                    packet = new DatagramPacket(new byte[1024], 1024);
                    this._socket.receive(packet);
                }
                catch (SocketException e) {
                    if (Thread.currentThread().isInterrupted()) break;
                    _log.warn("Exception in Server receive loop (exiting)", (Throwable)e);
                    break;
                }
                catch (Exception ie) {
                    _log.warn("Exception in Server receive loop (exiting)", (Throwable)ie);
                    break;
                }
                try {
                    this.process(packet);
                    this._socket.send(packet);
                }
                catch (Exception se) {
                    _log.warn("Exception in send ", (Throwable)se);
                }
            }
            this._socket.close();
        }

        public void process(DatagramPacket packet) throws Exception {
            byte[] data = packet.getData();
            int datalen = packet.getLength();
            InetAddress address = packet.getAddress();
            if (datalen <= 0) {
                _log.warn("Empty Packet arrived from " + packet.getAddress());
                return;
            }
            String message = new String(data, 0, datalen);
            _log.info("server query : [" + address + "] " + "(" + message.length() + ") " + message);
            message = (String)((Object)LocationManager.this.command(new Args(message)));
            _log.info("server reply : " + message);
            data = message.getBytes();
            packet.setData(data);
            packet.setLength(data.length);
        }

        private void createSetup(PrintWriter pw) {
            pw.println("#");
            pw.println("# This setup was created by the LocationManager at " + new Date().toString());
            pw.println("#");
            for (NodeInfo info : this._nodeDb.values()) {
                String def;
                pw.println("define " + info.getDomainName());
                if (info.mustListen()) {
                    pw.println("listen " + info.getDomainName());
                }
                if ((def = info.getDefault()) != null) {
                    pw.println("defaultroute " + info.getDomainName() + " " + def);
                }
                Iterator j = info.connections();
                while (j.hasNext()) {
                    pw.println("connect " + info.getDomainName() + " " + (String)j.next());
                }
            }
        }

        private String setupToString(int mode) {
            if (mode < -2 || mode > 2) {
                return "?(" + mode + ")";
            }
            return this.__mode2string[mode + 2];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String ac_ls_perm(Args args) throws Exception {
            if (this._permFile == null) {
                throw new IllegalArgumentException("Permamanet file not defined");
            }
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this._permFile));
            HashMap hm = null;
            try {
                hm = (HashMap)in.readObject();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ee) {}
                }
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry node_and_address : hm.entrySet()) {
                String node = (String)node_and_address.getKey();
                String address = (String)node_and_address.getValue();
                sb.append(node).append(" -> ").append(address).append("\n");
            }
            return sb.toString();
        }

        public String ac_setup_define_$_1(Args args) throws Exception {
            String filename = args.argv(0);
            this.prepareSetup(filename, args.getOpt("mode"));
            return "setupfile (mode=" + this.setupToString(this._setupMode) + ") : " + filename;
        }

        public String ac_setup_read(Args args) throws Exception {
            if (this._setupFileName == null) {
                throw new IllegalArgumentException("Setupfile not defined");
            }
            try {
                this.execSetupFile(this._setupFile);
            }
            catch (Exception ee) {
                throw new Exception("Problem in setupFile : " + ee.getMessage());
            }
            return "";
        }

        public String ac_setup_write(Args args) throws Exception {
            if (this._setupMode != 1) {
                throw new IllegalArgumentException("Setupfile not in write mode");
            }
            File tmpFile = new File(this._setupFile.getParent(), "$-" + this._setupFile.getName());
            PrintWriter pw = new PrintWriter(new FileWriter(tmpFile));
            try {
                this.createSetup(pw);
            }
            catch (Exception ee) {
                throw ee;
            }
            finally {
                try {
                    pw.close();
                }
                catch (Exception eee) {}
            }
            if (!tmpFile.renameTo(this._setupFile)) {
                throw new IOException("Failed to replace setupFile");
            }
            return "";
        }

        private synchronized NodeInfo getInfo(String nodeName, boolean create) {
            NodeInfo info = this._nodeDb.get(nodeName);
            if (info != null || !create) {
                return info;
            }
            info = new NodeInfo(nodeName);
            this._nodeDb.put(nodeName, info);
            return info;
        }

        public String ac_define_$_1(Args args) {
            this.getInfo(args.argv(0), true);
            return "";
        }

        public String ac_undefine_$_1(Args args) {
            String nodeName = args.argv(0);
            this._nodeDb.remove(nodeName);
            for (NodeInfo nodeInfo : this._nodeDb.values()) {
                nodeInfo.remove(nodeName);
            }
            return "";
        }

        public String ac_nodefaultroute_$_1(Args args) {
            NodeInfo info = this.getInfo(args.argv(0), false);
            if (info == null) {
                return "";
            }
            info.setDefault(null);
            return "";
        }

        public String ac_defaultroute_$_2(Args args) {
            this.getInfo(args.argv(1), true);
            this.getInfo(args.argv(0), true).setDefault(args.argv(1));
            return "";
        }

        public String ac_connect_$_2(Args args) {
            NodeInfo dest = this.getInfo(args.argv(1), true);
            dest.setListen(true);
            this.getInfo(args.argv(0), true).add(args.argv(1));
            return "";
        }

        public String ac_disconnect_$_2(Args args) {
            NodeInfo info = this.getInfo(args.argv(0), false);
            if (info == null) {
                return "";
            }
            info.remove(args.argv(1));
            return "";
        }

        public String ac_listen_$_1_99(Args args) {
            int port = 0;
            String portString = args.getOpt("port");
            if (portString != null) {
                port = Integer.parseInt(portString);
            }
            String secString = args.getOpt("security");
            for (int i = 0; i < args.argc(); ++i) {
                NodeInfo info = this.getInfo(args.argv(i), true);
                info.setListen(true);
                if (port > 0) {
                    info.setListenPort(port);
                }
                if (secString == null || secString.length() <= 0 || secString.equalsIgnoreCase("none")) continue;
                info.setSecurity(secString);
            }
            return "";
        }

        public String ac_unlisten_$_1_99(Args args) {
            for (int i = 0; i < args.argc(); ++i) {
                NodeInfo info = this.getInfo(args.argv(i), false);
                if (info == null) continue;
                info.setListen(false);
            }
            return "";
        }

        public String ac_ls_setup(Args args) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.createSetup(pw);
            pw.flush();
            sw.flush();
            return sw.getBuffer().toString();
        }

        public String ac_ls_node_$_0_1(Args args) {
            if (args.argc() == 0) {
                Iterator<NodeInfo> i = this._nodeDb.values().iterator();
                StringBuilder sb = new StringBuilder();
                while (i.hasNext()) {
                    sb.append(i.next().toString()).append("\n");
                }
                return sb.toString();
            }
            NodeInfo info = this.getInfo(args.argv(0), false);
            if (info == null) {
                throw new IllegalArgumentException("Node not found : " + args.argv(0));
            }
            return info.toString();
        }

        public String ac_set_address_$_2(Args args) {
            NodeInfo info = this.getInfo(args.argv(0), false);
            if (info == null) {
                throw new IllegalArgumentException("Domain not defined : " + args.argv(0));
            }
            if (!info.mustListen()) {
                throw new IllegalArgumentException("Domain won't listen : " + args.argv(0));
            }
            info.setAddress(args.argv(1));
            try {
                this.savePersistentMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return info.toString();
        }

        public String ac_unset_address_$_1(Args args) {
            NodeInfo info = this.getInfo(args.argv(0), false);
            if (info == null) {
                throw new IllegalArgumentException("Domain not defined : " + args.argv(0));
            }
            info.setAddress(null);
            try {
                this.savePersistentMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return info.toString();
        }

        public String ac_clear_server(Args args) {
            this._nodeDb.clear();
            return "";
        }

        public String ac_whatToDo_$_1(Args args) {
            NodeInfo info = this.getInfo(args.argv(0), false);
            if (info == null && (this._strict || (info = this.getInfo("*", false)) == null)) {
                throw new IllegalArgumentException("Domain not defined : " + args.argv(0));
            }
            String tmp = args.getOpt("serial");
            String serial = tmp != null ? "-serial=" + tmp : "";
            return "do " + serial + " " + info.toWhatToDoReply(true);
        }

        public String ac_whereIs_$_1(Args args) {
            NodeInfo info = this.getInfo(args.argv(0), false);
            if (info == null) {
                throw new IllegalArgumentException("Domain not defined : " + args.argv(0));
            }
            String tmp = args.getOpt("serial");
            String serial = tmp != null ? "-serial=" + tmp : "";
            StringBuilder sb = new StringBuilder();
            sb.append("location ").append(serial).append(" ").append(info.getDomainName());
            String out = info.getAddress();
            sb.append(" ").append(out == null ? "none" : out);
            out = info.getSecurity();
            if (out != null) {
                sb.append(" -security=\"").append(out).append("\"");
            }
            return sb.toString();
        }

        public String ac_listeningOn_$_2(Args args) {
            String nodeName = args.argv(0);
            NodeInfo info = this.getInfo(nodeName, false);
            if (info == null) {
                if (this._strict) {
                    throw new IllegalArgumentException("Domain not defined : " + nodeName);
                }
                info = new NodeInfo(nodeName, false);
                this._nodeDb.put(nodeName, info);
            }
            info.setAddress(args.argv(1).equals("none") ? null : args.argv(1));
            try {
                this.savePersistentMap();
            }
            catch (Exception eee) {
                // empty catch block
            }
            String tmp = args.getOpt("serial");
            String serial = tmp != null ? "-serial=" + tmp : "";
            return "listenOn " + serial + " " + info.getDomainName() + " " + (info.getAddress() == null ? "none" : info.getAddress());
        }

        public void start() {
            this._worker.start();
        }

        public void shutdown() {
            this._worker.interrupt();
            this._socket.close();
        }

        private class NodeInfo {
            private String _domainName;
            private HashSet<String> _list = new HashSet();
            private String _default;
            private boolean _listen;
            private String _address;
            private boolean _defined = true;
            private int _port;
            private String _sec;

            private NodeInfo(String domainName) {
                this._domainName = domainName;
            }

            private NodeInfo(String domainName, boolean defined) {
                this._domainName = domainName;
                this._defined = defined;
            }

            private boolean isDefined() {
                return this._defined;
            }

            private String getDomainName() {
                return this._domainName;
            }

            private synchronized void setDefault(String defaultNode) {
                this._default = defaultNode;
            }

            private int getConnectionCount() {
                return this._list.size();
            }

            private synchronized void add(String nodeName) {
                this._list.add(nodeName);
            }

            private synchronized void remove(String nodeName) {
                this._list.remove(nodeName);
            }

            private void setListenPort(int port) {
                this._port = port;
            }

            private void setSecurity(String sec) {
                this._sec = sec;
            }

            private void setListen(boolean listen) {
                this._listen = listen;
            }

            private void setAddress(String address) {
                this._listen = true;
                this._address = address;
            }

            private String getAddress() {
                return this._address;
            }

            private String getDefault() {
                return this._default;
            }

            private Iterator<String> connections() {
                return this._list.iterator();
            }

            private boolean mustListen() {
                return this._listen;
            }

            private String getSecurity() {
                return this._sec;
            }

            public String toWhatToDoReply(boolean strict) {
                StringBuilder sb = new StringBuilder();
                sb.append(this._domainName).append(" ");
                if (this._listen) {
                    sb.append("\"l:");
                    if (this._port > 0) {
                        sb.append(this._port);
                    }
                    sb.append(":");
                    if (this._sec != null) {
                        sb.append(this._sec);
                    }
                    sb.append(":");
                    sb.append('\"');
                    if (!strict && this._address != null) {
                        sb.append(" (").append(this._address).append(")");
                    }
                } else {
                    sb.append("nl");
                }
                if (this._default != null) {
                    sb.append(" d:").append(this._default);
                }
                Iterator<String> i = this.connections();
                while (i.hasNext()) {
                    sb.append(" c:").append(i.next());
                }
                return sb.toString();
            }

            public String toString() {
                return this.toWhatToDoReply(false);
            }
        }
    }
}

