/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.services;

import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.util.Args;
import dmg.util.CommandException;
import dmg.util.CommandInterpreter;
import dmg.util.CommandSyntaxException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandTaskCell
extends CellAdapter {
    private static final Logger _log = LoggerFactory.getLogger(CommandTaskCell.class);
    private String _cellName;
    private Args _args;
    private CellNucleus _nucleus;
    private ClientHandler _clientHandler = new ClientHandler();
    private HashMap<String, CellCommandTaskCore> _cores = new HashMap();
    private Map<String, ModuleInfo> _modules = new HashMap<String, ModuleInfo>();
    public static final String hh_set_logout_time = "<timeInSeconds>";
    public static final String hh_ls_task = "[-l]";
    public static final String hh_ls_module = "";
    public static final String hh_ls_client = "";
    public static final String hh_create_task = "<taskName> <moduleName>";
    public static final String hh_attach = "<sessionName>";
    public static final String hh_detach = "[<clientKey>]";
    public static final String hh_do = "<module specific commands>";
    public static final String hh_task = "<module specific commands>";
    private Class<?>[] _classSignature = new Class[]{CellCommandTaskCore.class};
    public static final String hh_define_module = "<moduleName> <moduleClass>";
    public static final String hh_undefine_module = "<moduleName>";

    public CommandTaskCell(String cellName, String args) throws Exception {
        super(cellName, args, false);
        this._cellName = cellName;
        this._args = this.getArgs();
        this._nucleus = this.getNucleus();
        this.useInterpreter(true);
        try {
            new Scheduler();
        }
        catch (Exception ee) {
            this.start();
            this.kill();
            throw ee;
        }
        this.start();
    }

    private void doTiming() {
        this._nucleus.updateWaitQueue();
        ArrayList<CellCommandTaskCore> cores = new ArrayList<CellCommandTaskCore>(this._cores.values());
        for (CellCommandTaskCore core : cores) {
            try {
                core._task.timer();
            }
            catch (Throwable t) {
                _log.warn("Throwable in task : " + core.getName() + " : " + t, t);
            }
        }
        this._clientHandler.cleanUp();
    }

    private String getClientKey() {
        CellMessage commandMessage = CommandTaskCell.getThisMessage();
        CellPath source = commandMessage.getSourcePath();
        return "" + source.getCellName() + "@" + source.getCellDomainName();
    }

    public String ac_set_logout_time_$_1(Args args) {
        long interval = Long.parseLong(args.argv(0)) * 1000L;
        if (interval <= 0L) {
            throw new IllegalArgumentException("Time must be > 0");
        }
        this._clientHandler.setLogoutTimer(interval);
        return "";
    }

    public String ac_ls_task(Args args) {
        ClientInfo client = this._clientHandler.getThisClient();
        boolean extended = args.hasOption("l");
        StringBuilder sb = new StringBuilder();
        Iterator<CellCommandTaskCore> i$ = this._cores.values().iterator();
        while (i$.hasNext()) {
            CellCommandTaskCore value;
            CellCommandTaskCore core = value = i$.next();
            sb.append(core.getName());
            if (extended) {
                sb.append(" ").append(core._moduleInfo.getName()).append(" {").append(core._task.toString()).append("}");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String ac_ls_module(Args args) {
        ClientInfo client = this._clientHandler.getThisClient();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ModuleInfo> entry : this._modules.entrySet()) {
            sb.append(entry.getKey()).append(" -> ").append(entry.getValue()._constructor.getName()).append("\n");
        }
        return sb.toString();
    }

    public String ac_ls_client(Args args) {
        ClientInfo client = this._clientHandler.getThisClient();
        StringBuilder sb = new StringBuilder();
        String ourClientKey = client.getClientKey();
        Iterator<ClientInfo> i$ = this._clientHandler.clients().iterator();
        while (i$.hasNext()) {
            ClientInfo o;
            ClientInfo info = o = i$.next();
            String clientKey = info.getClientKey();
            sb.append(info.getClientKey()).append(" ").append(ourClientKey.equals(clientKey) ? "*" : " ").append(" [").append((System.currentTimeMillis() - info._time) / 1000L).append("] -> ");
            if (!info.isAttached()) {
                sb.append("not attached\n");
                continue;
            }
            sb.append(info.getCore().getName()).append("\n");
        }
        return sb.toString();
    }

    public String ac_create_task_$_2(Args args) throws Throwable {
        String taskName = args.argv(0);
        String moduleName = args.argv(1);
        try {
            ClientInfo client = this._clientHandler.getThisClient();
            if (client.isAttached()) {
                throw new IllegalArgumentException("Already attached to " + client.getCore().getName());
            }
            CellCommandTaskCore core = this._cores.get(taskName);
            if (core != null) {
                throw new IllegalArgumentException("Task already exists : " + taskName);
            }
            ModuleInfo moduleInfo = this._modules.get(moduleName);
            if (moduleInfo == null) {
                throw new NoSuchElementException("Module not found : " + moduleName);
            }
            core = new CellCommandTaskCore(taskName, moduleInfo, args);
            Constructor cons = moduleInfo._constructor;
            Object obj = cons.newInstance(core);
            if (!(obj instanceof CellCommandTaskable)) {
                throw new Exception("PANIC : module doesn't interface CellCommandTaskable");
            }
            core.setCellCommandTaskable((CellCommandTaskable)obj);
            this._cores.put(taskName, core);
            client.setCore(core);
            return "Task <" + taskName + "> created and attached to (us) [" + client.getClientKey() + "]";
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            _log.warn("Problem creating " + moduleName + " InvocationTargetException cause : " + cause, cause);
            if (cause != null) {
                throw cause;
            }
            throw ite;
        }
        catch (Exception ee) {
            _log.warn("Problem creating " + moduleName + " " + ee, (Throwable)ee);
            throw ee;
        }
    }

    public String ac_attach_$_1(Args args) {
        ClientInfo client = this._clientHandler.getThisClient();
        if (client.isAttached()) {
            throw new IllegalArgumentException("Already attached to " + client.getCore().getName());
        }
        String taskName = args.argv(0);
        CellCommandTaskCore core = this._cores.get(taskName);
        if (core == null) {
            throw new NoSuchElementException("Task not found : " + taskName);
        }
        client.setCore(core);
        return "Task <" + taskName + "> attached to (us) [" + client.getClientKey() + "]";
    }

    public String ac_detach_$_0_1(Args args) {
        if (args.argc() == 0) {
            CellCommandTaskCore core = this._clientHandler.detach();
            if (core == null) {
                return "Wasn't attached";
            }
            return "Detached from : " + core.getName();
        }
        String clientKey = args.argv(0);
        CellCommandTaskCore core = this._clientHandler.detach(clientKey);
        if (core == null) {
            return "Wasn't attached";
        }
        return "Detached from : " + core.getName();
    }

    public Object ac_do_$_1_999(Args args) throws Exception {
        return this.executeLocalCommand(args);
    }

    public Serializable ac_task_$_1_999(Args args) throws Exception {
        return this.executeLocalCommand(args);
    }

    @Override
    public Serializable command(Args args) throws CommandException {
        Args copyArgs = new Args(args);
        try {
            return super.command(args);
        }
        catch (CommandSyntaxException ee) {
            return this.executeLocalCommand(copyArgs);
        }
    }

    private Serializable executeLocalCommand(Args args) throws CommandException {
        ClientInfo client = this._clientHandler.getThisClient();
        if (!client.isAttached()) {
            throw new IllegalArgumentException("Not attached");
        }
        CellCommandTaskCore core = client.getCore();
        Serializable obj = core.command(args);
        if (obj == null) {
            throw new CommandException("Command returned null");
        }
        return obj;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        ClientInfo client = this._clientHandler.getThisClient();
        pw.println("      Logout Time : " + this._clientHandler.getLogoutTimer() / 1000L + " seconds");
        pw.println("  Number of Tasks : " + this._cores.size());
        pw.println("Number of Clients : " + this._clientHandler.clients().size());
        pw.println("    Our Client Id : " + this._clientHandler.getThisClient().getClientKey());
        CellCommandTaskCore core = client.getCore();
        pw.println("         Attached : " + (core == null ? "false" : core.getName()));
        if (core != null) {
            core._task.getInfo(pw);
        }
    }

    public String ac_define_module_$_2(Args args) throws Exception {
        String moduleName = args.argv(0);
        String moduleClass = args.argv(1);
        Class<?> mc = Class.forName(moduleClass);
        Constructor<?> mcc = mc.getConstructor(this._classSignature);
        this._modules.put(moduleName, new ModuleInfo(moduleName, mcc, args));
        return "";
    }

    public String ac_undefine_module_$_1(Args args) {
        this._modules.remove(args.argv(0));
        return "";
    }

    @Override
    public void messageArrived(CellMessage msg) {
    }

    public static class ModuleExample
    implements CellCommandTaskable {
        private CellAdapter _cell;
        private CellCommandTaskCore _core;
        public static final String hh_send = "<destination> <message>";
        public static final String hh_test = "<whatever>";

        public ModuleExample(CellCommandTaskCore core) {
            this._cell = core.getParentCell();
            this._core = core;
            _log.info("Started : " + core.getName());
        }

        public String ac_send_$_2(Args args) {
            CellMessage msg = new CellMessage(new CellPath(args.argv(0)), (Serializable)((Object)args.argv(1)));
            this._core.sendMessage(msg);
            return "";
        }

        public String ac_test_$_0_99(Args args) {
            StringBuilder sb = new StringBuilder();
            sb.append(" Module Args : ").append(this._core.getModuleArgs().toString()).append("\n");
            sb.append("   Task Args : ").append(this._core.getTaskArgs().toString()).append("\n");
            sb.append("Command Args : ").append(args.toString()).append("\n");
            return sb.toString();
        }

        @Override
        public void answerArrived(CellMessage request, CellMessage answer) {
            _log.info("Answer arrived for task : " + this._core.getName() + " : " + answer.getMessageObject().toString());
        }

        @Override
        public void exceptionArrived(CellMessage request, Exception exception) {
        }

        @Override
        public void answerTimedOut(CellMessage request) {
        }

        @Override
        public void getInfo(PrintWriter pw) {
            pw.println(" Module Args : " + this._core.getModuleArgs());
            pw.println("   Task Args : " + this._core.getTaskArgs());
        }

        @Override
        public void timer() {
        }

        public String toString() {
            return "I'm " + this._core.getName();
        }
    }

    private class Scheduler
    implements Runnable {
        private long _sleepInterval = 60000L;
        private Thread _worker;

        private Scheduler() {
            this._worker = CommandTaskCell.this._nucleus.newThread(this, "Scheduler");
            this._worker.start();
        }

        @Override
        public void run() {
            _log.info("Scheduler worker started");
            while (!Thread.interrupted()) {
                try {
                    Thread.sleep(this._sleepInterval);
                }
                catch (InterruptedException ee) {
                    _log.info("Worker Thread interrupted");
                    break;
                }
                try {
                    CommandTaskCell.this.doTiming();
                }
                catch (Throwable t) {
                    _log.warn("Problem in 'doTiming' : " + t, t);
                }
            }
        }
    }

    private class ClientHandler {
        private HashMap<String, ClientInfo> _clientHash = new HashMap();
        private long _maxSessionLogin = 600000L;

        private ClientHandler() {
        }

        public Collection<ClientInfo> clients() {
            return this._clientHash.values();
        }

        public ClientInfo getThisClient() {
            String key = CommandTaskCell.this.getClientKey();
            ClientInfo info = this._clientHash.get(key);
            if (info == null) {
                info = new ClientInfo(key);
                this._clientHash.put(key, info);
            }
            info.touch();
            return info;
        }

        public CellCommandTaskCore detach() {
            return this.getThisClient().detach();
        }

        public CellCommandTaskCore detach(String clientKey) {
            ClientInfo info = this._clientHash.get(clientKey);
            if (info == null) {
                return null;
            }
            return info.detach();
        }

        public void setLogoutTimer(long interval) {
            this._maxSessionLogin = interval;
        }

        public long getLogoutTimer() {
            return this._maxSessionLogin;
        }

        public void cleanUp() {
            long now = System.currentTimeMillis();
            for (ClientInfo client : new ArrayList<ClientInfo>(this.clients())) {
                ClientInfo info = client;
                if (now - info._time <= this._maxSessionLogin) continue;
                String key = info.getClientKey();
                _log.info("Timer : " + key + " idle time exceeded");
                this._clientHash.remove(key);
            }
        }
    }

    private class ClientInfo {
        private long _time = System.currentTimeMillis();
        private String _clientKey;
        private CellCommandTaskCore _session;

        private ClientInfo(String key) {
            this._clientKey = key;
        }

        public boolean isAttached() {
            return this._session != null;
        }

        public CellCommandTaskCore getCore() {
            return this._session;
        }

        public void setCore(CellCommandTaskCore core) {
            this._session = core;
        }

        public String toString() {
            return this._clientKey + " = " + (this._session == null ? "not attached" : this._session.getName());
        }

        public String getClientKey() {
            return this._clientKey;
        }

        public void touch() {
            this._time = System.currentTimeMillis();
        }

        public CellCommandTaskCore detach() {
            CellCommandTaskCore session = this._session;
            this._session = null;
            return session;
        }
    }

    private class ModuleInfo {
        private Constructor<?> _constructor;
        private Args _args;
        private String _name;

        private ModuleInfo(String name, Constructor<?> constructor, Args args) {
            this._constructor = constructor;
            this._args = args;
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public String toString() {
            return this._name + " " + this._constructor.getName();
        }
    }

    public static interface CellCommandTaskable
    extends CellMessageAnswerable {
        public void timer();

        public void getInfo(PrintWriter var1);
    }

    public class CellCommandTaskCore
    extends CommandInterpreter {
        private CellAdapter _cell;
        private String _name;
        private Args _classArgs;
        private Args _taskArgs;
        private ModuleInfo _moduleInfo;
        private CellCommandTaskable _task;

        private CellCommandTaskCore(String name, ModuleInfo moduleInfo, Args args) {
            this._name = name;
            this._moduleInfo = moduleInfo;
            this._classArgs = moduleInfo._args;
            this._taskArgs = args;
        }

        public void setCellCommandTaskable(CellCommandTaskable task) {
            this.addCommandListener(task);
            this._task = task;
        }

        public Args getModuleArgs() {
            return this._classArgs;
        }

        public Args getTaskArgs() {
            return this._taskArgs;
        }

        public CellCommandTaskable getTaskable() {
            return this._task;
        }

        public String getName() {
            return this._name;
        }

        public CellAdapter getParentCell() {
            return CommandTaskCell.this;
        }

        public void sendMessage(CellMessage message) {
            CommandTaskCell.this.sendMessage(message, true, true, this._task, 999999999L);
        }

        public void sendMessage(CellMessage message, long timeout) {
            CommandTaskCell.this.sendMessage(message, true, true, this._task, timeout);
        }

        public String getModuleName() {
            return this._moduleInfo.getName();
        }
    }
}

