/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellGlue;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandlerFactory;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellUrl {
    private static final Logger _log = LoggerFactory.getLogger(CellUrl.class);
    private CellGlue _glue;
    private URLStreamHandlerFactory _others;

    public CellUrl(CellGlue glue) {
        Properties p = System.getProperties();
        String s = p.getProperty("java.protocol.handler.pkgs");
        s = s != null ? s + "|dmg.cells.nucleus.protocols" : "dmg.cells.nucleus.protocols";
        p.setProperty("java.protocol.handler.pkgs", s);
        System.setProperties(p);
    }

    public static void main(String[] args) throws Exception {
        new CellUrl(null);
        System.out.println("checking the creation of context url");
        URL url1 = new URL("context://localhost:1111//sfs");
        System.out.println("checking the creation of cell url");
        URL url2 = new URL("cell://localhost:1111//sfs");
        System.out.println("checking the creation of env url");
        URL url3 = new URL("env://localhost:1111//sfs");
        System.out.println("done");
    }

    public static class DomainUrlConnection
    extends URLConnection {
        private String _protocol;
        private CellNucleus _nucleus;
        private Map<String, Object> _environment;

        public DomainUrlConnection(URL url, String protocol) {
            super(url);
            this._protocol = protocol;
        }

        @Override
        public void connect() {
            _log.info("DomainUrlConnection : Connect called");
        }

        public void setNucleus(CellNucleus nucleus) {
            this._nucleus = nucleus;
        }

        public void setEnvironment(Map<String, Object> environment) {
            this._environment = environment;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this._nucleus == null) {
                throw new IOException("Nucleus not defined");
            }
            throw new IOException("getInputStream not supported on : " + this._protocol);
        }

        public Reader getReader() throws IOException {
            if (this._nucleus == null) {
                throw new IOException("Nucleus not defined");
            }
            switch (this._protocol) {
                case "context": {
                    if (this.url.getHost().equals("")) {
                        String filePart = this.url.getFile();
                        filePart = filePart.length() > 0 && filePart.charAt(0) == '/' ? filePart.substring(1) : filePart;
                        return this._nucleus.getDomainContextReader(filePart);
                    }
                    return this.getRemoteContextReader(this._nucleus, this.url);
                }
                case "env": {
                    if (this._environment == null) {
                        throw new IOException("Nucleus not defined");
                    }
                    String filePart = this.url.getFile();
                    filePart = filePart.length() > 0 && filePart.charAt(0) == '/' ? filePart.substring(1) : filePart;
                    return this.getDictionaryReader(this._environment, filePart);
                }
                case "cell": {
                    return this.getRemoteCellReader(this._nucleus, this.url);
                }
            }
            throw new IOException("Protocol not supported : " + this._protocol);
        }

        @Override
        public String getContentType() {
            return "text/context";
        }

        @Override
        public String toString() {
            return "DomainUrlConnection of : " + this._protocol;
        }

        private Reader getRemoteCellReader(CellNucleus nucleus, URL url) throws IOException {
            Object o = this.getRemoteData(nucleus, url.getHost(), url.getFile().substring(1), 4000L);
            if (o instanceof Exception) {
                throw new IOException(o.toString());
            }
            return new StringReader(o.toString());
        }

        private Reader getRemoteContextReader(CellNucleus nucleus, URL url) throws IOException {
            Object o = this.getRemoteData(nucleus, "System@" + url.getHost(), "show context " + url.getFile().substring(1), 4000L);
            if (o instanceof Exception) {
                throw new IOException(o.toString());
            }
            return new StringReader(o.toString());
        }

        private Object getRemoteData(CellNucleus nucleus, String path, String command, long timeout) throws IOException {
            CellMessage answer;
            try {
                answer = nucleus.sendAndWait(new CellMessage(new CellPath(path), (Serializable)((Object)command)), timeout);
            }
            catch (Exception e) {
                throw new IOException("sendAndWait : " + e.toString());
            }
            if (answer == null) {
                throw new IOException("Request timed out");
            }
            return answer.getMessageObject();
        }

        private Reader getDictionaryReader(Map<String, Object> env, String name) throws IOException {
            Object o = env.get(name);
            if (o == null) {
                throw new IOException("Not found : " + name);
            }
            return new StringReader(o.toString());
        }

        private Reader getDictionaryReaderx(Cell cell, String name) throws IOException {
            Class<?> cellClass = cell.getClass();
            _log.info("DomainUrlConnection : Cell Class is : " + cellClass);
            Class[] argsClasses = new Class[]{};
            try {
                Method method = cellClass.getDeclaredMethod("getEnvironmentDictionary", argsClasses);
                Object[] args = new Object[]{};
                Dictionary dir = (Dictionary)method.invoke((Object)cell, args);
                Object o = dir.get(name);
                if (o == null) {
                    throw new IOException("Not found : " + name);
                }
                return new StringReader(o.toString());
            }
            catch (Exception e) {
                throw new IOException("Problem : " + e);
            }
        }
    }
}

