/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.network.PingMessage;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.EnvironmentAware;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.Reply;
import dmg.cells.nucleus.SerializationException;
import dmg.util.Args;
import dmg.util.BufferedLineWriter;
import dmg.util.ClassDataProvider;
import dmg.util.ClassLoaderFactory;
import dmg.util.CollectionFactory;
import dmg.util.CommandEvaluationException;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandInterpreter;
import dmg.util.CommandPanicException;
import dmg.util.CommandRequestable;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.Exceptions;
import dmg.util.Formats;
import dmg.util.PropertiesBackedReplaceable;
import dmg.util.Replaceable;
import dmg.util.ReplaceableBackedProperties;
import dmg.util.Slf4jErrorWriter;
import dmg.util.Slf4jInfoWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellShell
extends CommandInterpreter
implements Replaceable,
ClassDataProvider {
    private static final Logger _log = LoggerFactory.getLogger(CellShell.class);
    private static final Logger _logNucleus = LoggerFactory.getLogger(CellNucleus.class);
    private final CellNucleus _nucleus;
    private StringBuilder _contextString;
    private String _contextName;
    private String _contextDelimiter;
    private StringBuilder _envString;
    private String _envName;
    private String _envDelimiter;
    private int _helpMode = 1;
    private int _errorCode;
    private String _errorMsg;
    private String _doOnExit;
    private final Map<String, Object> _environment = CollectionFactory.newConcurrentHashMap();
    private final ClassLoaderFactory _classLoaderFactory = new ClassLoaderFactory();
    private CommandInterpreter _externalInterpreter;
    private String _classProvider;
    private List<String> _argumentVector = new Vector<String>();
    private static long __sequenceNumber = 1000000L;
    public static final String hh_version = "[<package>] ; package info of dmg/cells/nucleus";
    public static final String hh_waitfor = "context|cell|domain <objectName> [<domain>] [-i=<checkInterval>] [-wait=<maxTime>]";
    public static final String fh_waitfor = "waitfor [options]  context  <contextName> [<domainName]\nwaitfor [options]  cell     <cellPath>\nwaitfor [options]  domain   <domainName>\n    Options : -i=<probeInterval   -wait=<maxWaitSeconds>\n";
    public static final String fh_route = " Syntax : route      # show all routes\n          route add|delete [options] <source> <destination>\n";
    public static final String hh_route_add = "-options <source> <destination>";
    public static final String fh_route_add = " Syntax : route      # show all routes\n          route add|delete [options] <source> <destination>\n";
    public static final String hh_route_delete = "-options <source> <destination>";
    public static final String fh_route_delete = " Syntax : route      # show all routes\n          route add|delete [options] <source> <destination>\n";
    public static final String hh_route_find = "<address>";
    public static final String hh_ps = "[-f] [<cellName> ...]";
    public static final String fh_ps = " Syntax : ps [-f] [<cellName> ...]\n          ps displays various attibutes of active cells\n          or the full attributes of a particular cell\n          Options :  -f   displays a one line comment if\n                          <cellName> is specified, otherwise\n                          all available informations (theads,...\n                          will be shown\n";
    public static final String hh_kill = "<cellName>  # kill the named cell";
    public static final String fh_kill = "NAME\n\tkill\n\nSYNOPSIS\n\tkill CELL\n\nDESCRIPTION\n\tKills the cell CELL.  If CELL is 'System' then, in addition to killing\n\tthe System cell, the domain shutdown sequence is triggered.  This will\n\tresult in the JVM process ending.\n\nOPTIONS\n\tnone\n";
    public static final String hh_send = "[-w] <cellAddress> <message>";
    public static final String fh_send = "  Syntax : send [options] <cellAddress> <message>\n           Sends the message <message> to the specified\n           <cellAddress>.\n           -w        :  wait 10 second for the answer to arrive\n           -nolocal  :  don't deliver locally\n           -noremote :  don't deliver remotely\n";
    public static final String hh_sleep = "<secondsToSleep>";
    public static final String hh_ping = "<destinationCell>  [<packetSize>] [-count=numOfPackets]";
    public static final String hh_create = "<cellClass> <cellName> [<Arguments>]";
    public static final String fh_set_classloader = "  set classloader <packageSelection> <provider>\n     <packageSelection> : e.g. java.lang.*\n     <provider>         :   \n          cell:class@domain \n          dir:/../.../../   \n          system, none\n";
    public static final String hh_set_classloader = "<packageSelection> <provider>";
    public static final String hh_load_cellprinter = "<cellprinterClassName> # Obsolete";
    public static final String hh_load_interpreter = "<interpreterClassName>";
    public static final String hh_onerror = "shutdown|exit|continue";
    private static final int PRINT_CELL = 1;
    private static final int PRINT_ERROR_CELL = 2;
    private static final int PRINT_NUCLEUS = 4;
    private static final int PRINT_ERROR_NUCLEUS = 8;
    private static final int PRINT_FATAL = 16;
    public static final String hh_say = "<things to echo ...> [-level=<level>]";
    public static final String fh_say = "<things to echo ...> [-level=<level>]\n Levels :\n   say,esay,fsay\n   PRINT_CELL          =    1\n   PRINT_ERROR_CELL    =    2\n   PRINT_NUCLEUS       =    4\n   PRINT_ERROR_NUCLEUS =    8\n   PRINT_FATAL         = 0x10";
    public static final String hh_echo = "<things to echo ...>";
    public static final String hh_show_error = "   # shows last errorCode and Message ";
    public static final String hh_set_helpmode = "none|full";
    public static final String fh_check = " check [-strong] <var1> [<var2> [] ... ]\n        checks if all of the specified variables are set.\n        Returns an error it not.\n        The -strong option requires that all variables must not be\n        the zero string and must not only contain blanks\n";
    public static final String hh_check = "[-strong] <var1> [<var2> [] ... ]";
    public static final String fh_import_context = "  import  context|env  [options] <variableName>\n           options :\n               -c                  : don't overwrite\n               -source=env|context : only check the specifed\n                                     source for the variableName\n               -nr                 : don't run the variable resolver\n\n      The source is interpreted as a set of lines separated by\n      newlines. Each line is assumed to contain a key value pair\n      separated by the '=' sign.\n      The context/environment variables are set according to\n      the assignment.\n";
    public static final String fh_import_env = "  import  context|env  [options] <variableName>\n           options :\n               -c                  : don't overwrite\n               -source=env|context : only check the specifed\n                                     source for the variableName\n               -nr                 : don't run the variable resolver\n\n      The source is interpreted as a set of lines separated by\n      newlines. Each line is assumed to contain a key value pair\n      separated by the '=' sign.\n      The context/environment variables are set according to\n      the assignment.\n";
    public static final String hh_import_context = "[-source=context|env] [-nr]<contextVariableName>";
    public static final String hh_import_env = "[-source=context|env] [-nr]<environmentVariableName>";
    public static final String fh_set_context = "set context|env  [options]  <variableName>  <value>\n        options :\n          -c   :  do not overwrite the variable if it's already set\n          -s   :  run the value through the interpreter and\n                  convert  '\\n' to a real newline";
    public static final String fh_set_env = "set context|env  [options]  <variableName>  <value>\n        options :\n          -c   :  do not overwrite the variable if it's already set\n          -s   :  run the value through the interpreter and\n                  convert  '\\n' to a real newline";
    public static final String hh_set_context = "[-c][-s] <contextName> <value>";
    public static final String hh_set_env = "[-c][-s] <environmentName> <value>";
    public static final String hh_unset_context = "<contextName>";
    public static final String hh_unset_env = "<environmentName>";
    public static final String hh_ls = "[-l] [-ll] [-e] [-list]";
    public static final String fh_ls = " ls [options]\n        Prints context/environment\n    Options\n       -l adds class name\n       -ll adds first 40 chars of content\n       -e  list environment instead of context\n       -list  prints simple list instead of formatted one\n\n";
    public static final String hh_show_context = "[<contextName>]";
    public static final String hh_show_env = "[<environmentName>]";
    public static final String hh_test_context = "[<contextName>]";
    public static final String hh_test_env = "[<environmentName>]";
    public static final String fh_test = "test <kind> <target>\n\n  Check whether <target>, of type <kind>, is available in the current environment.\n  If <target> is present then the return-code is zero, if not then a non-zero\n  return-code is returned.\n\n  Possible invocations are:\n     -i <cell>   test if <cell> is running,\n     -e <file>   test if <file> exists,\n     -f <file>   test if <file> exists and is a normal file,\n     -d <file>   test if <file> exists and is a directory";
    public static final String hh_test = "-i <cell> | -e <file> | -f <file> | -d <file>";
    public static final String fh_exec = "exec [<options>] <url> [<args>]\nexec context [<options>] <contextName> [<args>]\nexec env [<options>] <envName> [<args>]\n\n   Executes the content of an env or context variable or the\n   resource identified by the URL.\n     -shell : opens a new shell for the execution\n     -nooutput : discard the output of the executed commands\n     -loop=<variableContextName> : \n        Executes the block for each line in <varContextName> as arg\n     -ifok[=<varName>] : run the context/env ONLY if the \n                         specified value of <varName> is '0'\n                         The default <varName> is 'rc'\n     -ifnotok[=<varName>]  : negation of -ifok\n\n";
    public static final String hh_exec = "[-shell] [-nooutput] [-loop=<variable>] [-ifok[=<variable>]|-ifnotok[=<variable>}] <url> [<args>]";
    public static final String fh_exec_env = "exec [<options>] <url> [<args>]\nexec context [<options>] <contextName> [<args>]\nexec env [<options>] <envName> [<args>]\n\n   Executes the content of an env or context variable or the\n   resource identified by the URL.\n     -shell : opens a new shell for the execution\n     -nooutput : discard the output of the executed commands\n     -loop=<variableContextName> : \n        Executes the block for each line in <varContextName> as arg\n     -ifok[=<varName>] : run the context/env ONLY if the \n                         specified value of <varName> is '0'\n                         The default <varName> is 'rc'\n     -ifnotok[=<varName>]  : negation of -ifok\n\n";
    public static final String hh_exec_env = "[-shell] [-nooutput] [-loop=<variable>] [-ifok[=<variable>]|-ifnotok[=<variable>}] <envName> [<args>]";
    public static final String fh_exec_context = "exec [<options>] <url> [<args>]\nexec context [<options>] <contextName> [<args>]\nexec env [<options>] <envName> [<args>]\n\n   Executes the content of an env or context variable or the\n   resource identified by the URL.\n     -shell : opens a new shell for the execution\n     -nooutput : discard the output of the executed commands\n     -loop=<variableContextName> : \n        Executes the block for each line in <varContextName> as arg\n     -ifok[=<varName>] : run the context/env ONLY if the \n                         specified value of <varName> is '0'\n                         The default <varName> is 'rc'\n     -ifnotok[=<varName>]  : negation of -ifok\n\n";
    public static final String hh_exec_context = "[-shell] [-nooutput] [-loop=<variable>] [-ifok[=<variable>]|-ifnotok[=<variable>}] <contextName> [<args>]";
    public static final String hh_eval = "upn expression";
    public static final String hh_define_context = "<contextName> [<delimiter>]";
    public static final String hh_define_env = "<environmentName>";
    public static final String hh_load_context = "[-b] <contextName> <fileName>";
    public static final String fh_copy = "   copy  <fromCellURL>  <toCellURL>\n       <fromCellURL> : <extendedCellURL>\n                        Protocols : env/context/cell/http/file/ftp\n       <toCellURL>   : <env/context CellURL>\n                        Protocols : env/context\n\n       Protocols :\n          env:<environmentVariable>\n          context:<contextVariable>\n          context://<cellPath>/<contextVariable>\n          cell://<cellPath>/<requestString>\n";
    public static final String hh_copy = "<fromCellURL> <toCellURL>";
    public static final String hh_exit = "[<exitCode> [<exitMessage>]]";

    public CellShell(CellNucleus nucleus) {
        this._nucleus = nucleus;
        try {
            this.objectCommand("exec context shellProfile");
        }
        catch (CommandExitException commandExitException) {
            // empty catch block
        }
    }

    public CellShell(CellAdapter cell) {
        this(cell.getNucleus());
        this._externalInterpreter = cell;
    }

    public Map<String, Object> environment() {
        return this._environment;
    }

    @Override
    public String getReplacement(String name) {
        Object o = this.getDictionaryEntry(name);
        return o == null ? null : o.toString();
    }

    private static synchronized long nextSequenceNumber() {
        return __sequenceNumber++;
    }

    public Object getDictionaryEntry(String name) {
        switch (name) {
            case "rc": {
                return "" + this._errorCode;
            }
            case "rmsg": {
                return this._errorMsg == null ? "(0)" : this._errorMsg;
            }
            case "thisDomain": {
                return this._nucleus.getCellDomainName();
            }
            case "thisCell": {
                return this._nucleus.getCellName();
            }
            case "nextSequenceNumber": {
                return "" + CellShell.nextSequenceNumber();
            }
            case "thisHostname": {
                try {
                    String xname = InetAddress.getLocalHost().getHostName();
                    return new StringTokenizer(xname, ".").nextToken();
                }
                catch (UnknownHostException e) {
                    return "UnknownHostname";
                }
            }
            case "thisFqHostname": {
                try {
                    return InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    return "UnknownHostname";
                }
            }
        }
        try {
            int position = Integer.parseInt(name);
            if (position >= 0 && position < this._argumentVector.size()) {
                String o = this._argumentVector.get(position);
                if (o == null) {
                    throw new IllegalArgumentException("");
                }
                return o;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        Object o = this._environment.get(name);
        if (o == null) {
            o = this._nucleus.getDomainContext().get(name);
        }
        return o;
    }

    private String prepareCommand(String string) {
        String str = Formats.replaceKeywords(string, this);
        if (this._contextString != null) {
            if (str.length() > 0 && str.equals(this._contextDelimiter)) {
                this._nucleus.getDomainContext().put(this._contextName, this._contextString.toString());
                this._contextString = null;
                return null;
            }
            this._contextString.append(str).append("\n");
            return null;
        }
        if (this._envString != null) {
            if (str.length() > 0 && str.equals(this._envDelimiter)) {
                this._environment.put(this._envName, this._envString.toString());
                this._envString = null;
                return null;
            }
            this._envString.append(str).append("\n");
            return null;
        }
        return str;
    }

    public Serializable objectCommand2(String strin) {
        String str = this.prepareCommand(strin);
        if (str == null) {
            return "";
        }
        try {
            Serializable o = this._externalInterpreter != null ? this._externalInterpreter.command(new Args(str)) : this.command(new Args(str));
            this._errorCode = 0;
            this._errorMsg = null;
            if (o == null) {
                return "";
            }
            return o;
        }
        catch (CommandException ce) {
            this._errorCode = ce.getErrorCode();
            this._errorMsg = ce.getErrorMessage();
            return ce;
        }
    }

    public Object objectCommand(String strin) throws CommandExitException {
        String str = this.prepareCommand(strin);
        if (str == null) {
            return "";
        }
        try {
            Serializable o = this._externalInterpreter != null ? this._externalInterpreter.command(new Args(str)) : this.command(new Args(str));
            this._errorCode = 0;
            this._errorMsg = null;
            if (o == null) {
                return "";
            }
            return o;
        }
        catch (CommandException ce) {
            this._errorCode = ce.getErrorCode();
            this._errorMsg = ce.getErrorMessage();
            if (this._doOnExit != null) {
                if (this._doOnExit.equals("shutdown")) {
                    throw new CommandExitException(ce.toString(), 666);
                }
                throw new CommandExitException(ce.getErrorMessage(), ce.getErrorCode());
            }
            if (ce instanceof CommandSyntaxException) {
                String help;
                CommandSyntaxException cse = (CommandSyntaxException)ce;
                StringBuilder sb = new StringBuilder();
                sb.append("Syntax Error : ").append(cse.getMessage());
                if (this._helpMode == 1) {
                    sb.append("\nUse 'help' for more information\n");
                } else if (this._helpMode == 2 && (help = cse.getHelpText()) != null) {
                    sb.append("\n").append(help).append("\n");
                }
                return sb.toString();
            }
            if (ce instanceof CommandExitException) {
                if (this._externalInterpreter != null) {
                    this._externalInterpreter = null;
                    return "external shell exited ... ";
                }
                throw (CommandExitException)ce;
            }
            if (ce instanceof CommandThrowableException) {
                CommandThrowableException cte = (CommandThrowableException)ce;
                StringBuilder sb = new StringBuilder();
                sb.append(cte.getMessage()).append(" -> ");
                Throwable t = cte.getTargetException();
                sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
                return sb.toString();
            }
            if (ce instanceof CommandPanicException) {
                CommandPanicException cpe = (CommandPanicException)ce;
                StringBuilder sb = new StringBuilder();
                sb.append("Panic : ").append(cpe.getMessage()).append("\n");
                Throwable t = cpe.getTargetException();
                sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
                return sb.toString();
            }
            return "CommandException  :" + ce.getMessage();
        }
    }

    @Override
    public String command(String c) throws CommandExitException {
        StringTokenizer st = new StringTokenizer(c, "\n");
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            sb.append(this.commandLine(st.nextToken()));
        }
        return sb.toString();
    }

    private String commandLine(String c) throws CommandExitException {
        if (this._contextString != null) {
            this._contextString.append(c).append("\n");
            return "";
        }
        return super.command(c);
    }

    public Object ac_version_$_0_1(Args args) {
        Package p = Package.getPackage(args.argc() == 0 ? "dmg.cells.nucleus" : args.argv(0));
        StringBuilder sb = new StringBuilder();
        if (p != null) {
            String tmp = p.getSpecificationTitle();
            sb.append("SpecificationTitle:   ").append(tmp == null ? "(Unknown)" : tmp).append("\n");
            tmp = p.getSpecificationVendor();
            sb.append("SpecificationVendor:  ").append(tmp == null ? "(Unknown)" : tmp).append("\n");
            tmp = p.getSpecificationVersion();
            sb.append("SpecificationVersion: ").append(tmp == null ? "(Unknown)" : tmp).append("\n");
        } else {
            sb.append("No version version found");
        }
        return sb.toString();
    }

    public Object ac_getroutes(Args args) {
        return this._nucleus.getRoutingList();
    }

    public CellTunnelInfo[] ac_getcelltunnelinfos(Args args) {
        List<CellTunnelInfo> cellTunnelInfos = this._nucleus.getCellTunnelInfos();
        return cellTunnelInfos.toArray(new CellTunnelInfo[cellTunnelInfos.size()]);
    }

    public Object ac_getcellinfo_$_1(Args args) throws CommandException {
        CellInfo info = this._nucleus.getCellInfo(args.argv(0));
        if (info == null) {
            throw new CommandException(68, "not found : " + args.argv(0));
        }
        return info;
    }

    public Object ac_getcellinfos(Args args) {
        List<String> names = this._nucleus.getCellNames();
        ArrayList<CellInfo> infoList = new ArrayList<CellInfo>(names.size());
        for (String name : names) {
            CellInfo info = this._nucleus.getCellInfo(name);
            if (info == null) continue;
            infoList.add(info);
        }
        return infoList.toArray(new CellInfo[infoList.size()]);
    }

    public Object ac_getcontext_$_0_1(Args args) throws CommandException {
        if (args.argc() == 0) {
            return this._nucleus.getDomainContext().keySet().toArray();
        }
        Object o = this._nucleus.getDomainContext(args.argv(0));
        if (o == null) {
            throw new CommandException("Context not found : " + args.argv(0));
        }
        return o;
    }

    public String ac_waitfor_$_2_3(Args args) throws CommandException {
        int waitTime = 0;
        int check = 1;
        for (int i = 0; i < args.optc(); ++i) {
            if (args.optv(i).startsWith("-i=")) {
                check = Integer.parseInt(args.optv(i).substring(3));
                continue;
            }
            if (!args.optv(i).startsWith("-wait=")) continue;
            waitTime = Integer.parseInt(args.optv(i).substring(6));
        }
        if (waitTime < 0) {
            waitTime = 0;
        }
        String what = args.argv(0);
        String name = args.argv(1);
        switch (what) {
            case "cell": {
                return this._waitForCell(name, waitTime, check, null);
            }
            case "domain": {
                return this._waitForCell("System@" + name, waitTime, check, null);
            }
            case "context": {
                if (args.argc() > 2) {
                    return this._waitForCell("System@" + args.argv(2), waitTime, check, "test context " + name);
                }
                return this._waitForContext(name, waitTime, check);
            }
        }
        throw new CommandException("Unknown Observable : " + what);
    }

    private String _waitForContext(String contextName, int waitTime, int check) throws CommandException {
        Object o;
        if (check <= 0) {
            check = 1;
        }
        long finish = System.currentTimeMillis() + (long)(waitTime * 1000);
        while ((o = this._nucleus.getDomainContext(contextName)) == null) {
            if (waitTime == 0 || finish > System.currentTimeMillis()) {
                try {
                    Thread.sleep((long)check * 1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new CommandException(2, "Command Was interrupted");
                }
            }
            throw new CommandException(1, "Command Timed Out");
        }
        return "";
    }

    private String _waitForCell(String cellName, int waitTime, int check, String command) throws CommandException {
        block7: {
            if (check <= 4) {
                check = 5;
            }
            CellPath destination = new CellPath(cellName);
            long finish = System.currentTimeMillis() + (long)(waitTime * 1000);
            CellMessage answer = null;
            CellMessage request = new CellMessage(destination, (Serializable)(command == null ? new PingMessage() : command));
            while (true) {
                Serializable o;
                boolean noRoute;
                try {
                    noRoute = false;
                    answer = null;
                    _log.warn("waitForCell : Sending request");
                    answer = this._nucleus.sendAndWait(request, (long)check * 1000L);
                    _log.warn("waitForCell : got " + answer);
                }
                catch (NoRouteToCellException nrtce) {
                    noRoute = true;
                }
                catch (InterruptedException e) {
                    throw new CommandException(66, "sendAndWait problem : " + e.toString());
                }
                if (answer != null && (o = answer.getMessageObject()) != null && (o instanceof PingMessage || o instanceof String)) break block7;
                if (waitTime != 0 && finish <= System.currentTimeMillis()) break;
                if (!noRoute && answer == null) continue;
                try {
                    Thread.sleep((long)check * 1000L);
                }
                catch (InterruptedException ie) {
                    throw new CommandException(2, "Command Was interrupted");
                }
            }
            throw new CommandException(1, "Command Timed Out");
        }
        return "";
    }

    public String ac_route_$_0(Args args) {
        return this._nucleus.getRoutingTable().toString();
    }

    public String ac_route_add_$_1_2(Args args) throws IllegalArgumentException {
        this._nucleus.routeAdd(new CellRoute(args));
        return "Done\n";
    }

    public String ac_route_delete_$_1_2(Args args) throws IllegalArgumentException {
        this._nucleus.routeDelete(new CellRoute(args));
        return "Done\n";
    }

    public String ac_route_find_$_1(Args args) throws IllegalArgumentException {
        CellAddressCore addr = new CellAddressCore(args.argv(0));
        CellRoute route = this._nucleus.routeFind(addr);
        if (route != null) {
            return route.toString() + "\n";
        }
        return "No Route To cell : " + addr.toString() + "\n";
    }

    public String ac_ps_$_0_99(Args args) {
        StringBuilder sb = new StringBuilder();
        if (args.argc() == 0) {
            sb.append("  Cell List\n------------------\n");
            List<String> list = this._nucleus.getCellNames();
            if (args.optc() > 0) {
                for (String name : list) {
                    CellInfo info = this._nucleus.getCellInfo(name);
                    if (info == null) {
                        sb.append(name).append(" (defunc)\n");
                        continue;
                    }
                    sb.append(info).append("\n");
                }
            } else {
                for (String name : list) {
                    sb.append(name).append("\n");
                }
            }
        } else {
            boolean full = args.optc() > 0 && args.optv(0).indexOf(102) > -1;
            for (int i = 0; i < args.argc(); ++i) {
                String cellName = args.argv(i);
                CellInfo info = this._nucleus.getCellInfo(cellName);
                if (info == null) {
                    sb.append(cellName).append(" Not found\n");
                    continue;
                }
                if (full) {
                    sb.append("  -- Short Info about Cell ").append(cellName).append(" --\n");
                    sb.append(info.toString()).append("\n");
                    CellVersion version = info.getCellVersion();
                    if (version != null) {
                        sb.append("  -- Version : ").append(version.toString()).append("\n");
                    }
                    sb.append("  -- Threads --\n");
                    Thread[] threads = this._nucleus.getThreads(cellName);
                    for (int j = 0; j < threads.length && threads[j] != null; ++j) {
                        boolean isAlive = threads[j].isAlive();
                        sb.append(CellInfo.f(threads[j].getName(), 20)).append(CellInfo.f("" + threads[j].getPriority(), 2)).append(isAlive ? "  Alive" : "  Dead").append("\n");
                    }
                    sb.append("  -- Private Infos --\n");
                }
                sb.append(info.getPrivatInfo()).append("\n");
            }
        }
        return sb.toString();
    }

    public Reply ac_kill_$_1(Args args) throws IllegalArgumentException, InterruptedException {
        final DelayedReply future = new DelayedReply();
        final String cell = args.argv(0);
        Thread thread = new Thread("kill " + cell + " command"){

            @Override
            public void run() {
                Object response = "";
                try {
                    try {
                        CellShell.this._nucleus.kill(cell);
                        CellShell.this._nucleus.join(cell, 0L);
                    }
                    catch (IllegalArgumentException e) {
                        response = e;
                    }
                    try {
                        future.send((Serializable)response);
                    }
                    catch (NoRouteToCellException | SerializationException e) {
                        _log.error("problem sending result of 'kill {}' command: {}", (Object)cell, (Object)e.getMessage());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        return future;
    }

    public String ac_send_$_2(Args args) throws IllegalArgumentException, InterruptedException, NoRouteToCellException {
        CellMessage msg = new CellMessage(new CellPath(args.argv(0)), (Serializable)((Object)args.argv(1)));
        boolean wait = false;
        boolean locally = true;
        boolean remotely = true;
        for (int i = 0; i < args.optc(); ++i) {
            if (args.optv(i).equals("-w")) {
                wait = true;
                continue;
            }
            if (args.optv(i).equals("-nolocal")) {
                locally = false;
                continue;
            }
            if (!args.optv(i).equals("-noremote")) continue;
            remotely = false;
        }
        if (wait) {
            if ((msg = this._nucleus.sendAndWait(msg, locally, remotely, 10000L)) == null) {
                return "Timeout ... \n";
            }
            Serializable obj = msg.getMessageObject();
            if (obj == null) {
                return msg.toString() + "\n";
            }
            String output = obj.toString();
            if (output.charAt(output.length() - 1) == '\n') {
                return output;
            }
            return output + "\n";
        }
        this._nucleus.sendMessage(msg, locally, remotely);
        return "Msg UOID =" + msg.getUOID().toString() + "\n";
    }

    public String ac_sleep_$_1(Args args) throws InterruptedException {
        int s = Integer.valueOf(args.argv(0));
        Thread.sleep(s * 1000);
        return "Ready\n";
    }

    public String ac_ping_$_1_2(Args args) throws NoRouteToCellException {
        String countString = args.getOpt("count");
        int count = 1;
        int size = 0;
        if (countString != null) {
            try {
                count = Integer.parseInt(countString);
            }
            catch (NumberFormatException ee) {
                // empty catch block
            }
        }
        if (args.argc() > 1) {
            try {
                size = Integer.parseInt(args.argv(1));
            }
            catch (NumberFormatException ee) {
                // empty catch block
            }
        }
        CellPath path = new CellPath(args.argv(0));
        for (int i = 0; i < count; ++i) {
            this._nucleus.sendMessage(new CellMessage(path, new PingMessage(size)));
        }
        return "Done\n";
    }

    public String ac_create_$_2_3(Args args) throws Throwable {
        try {
            Cell cell;
            if (args.optc() > 0 && args.optv(0).equals("-c")) {
                String[] argClasses = new String[1];
                Object[] argObjects = new Object[1];
                argClasses[0] = "java.lang.String";
                argObjects[0] = args.argc() > 2 ? args.argv(2) : "";
                cell = this._nucleus.createNewCell(args.argv(0), args.argv(1), argClasses, argObjects);
            } else {
                cell = this._nucleus.createNewCell(args.argv(0), args.argv(1), args.argc() > 2 ? args.argv(2) : "", true);
            }
            if (cell instanceof EnvironmentAware) {
                ((EnvironmentAware)((Object)cell)).setEnvironment(Collections.unmodifiableMap(this._environment));
            }
            return "created : " + cell;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public String ac_set_classloader_$_2(Args args) {
        this._nucleus.setClassProvider(args.argv(0), args.argv(1));
        return "";
    }

    public String ac_show_classloader(Args args) {
        StringBuilder sb = new StringBuilder();
        for (String[] classProvider : this._nucleus.getClassProviders()) {
            sb.append(Formats.field(classProvider[0], 20, 2)).append(classProvider[1]).append("\n");
        }
        return sb.toString();
    }

    public String ac_load_cellprinter_$_1(Args args) {
        return "Obsolete; use log4j instead.";
    }

    public String ac_load_interpreter_$_1(Args args) throws CommandException {
        Object interObject;
        Object[] paras;
        Class<?> c;
        String providerType;
        Object o = this.getDictionaryEntry("classProvider");
        if (o == null || !(o instanceof String)) {
            throw new CommandException(34, "<classProvider> not set, or not a String");
        }
        String className = args.argv(0);
        String classProvider = (String)o;
        int pos = classProvider.indexOf(58);
        if (pos < 0) {
            providerType = "file";
        } else {
            providerType = classProvider.substring(0, pos);
            classProvider = classProvider.substring(pos + 1);
        }
        switch (providerType) {
            case "file": {
                File directory = new File(classProvider);
                if (!directory.isDirectory()) {
                    throw new CommandException(34, "<classDirectory> not a directory");
                }
                c = this._classLoaderFactory.loadClass(className, directory);
                if (c != null) break;
                throw new CommandException(35, "class not found in <" + this._classLoaderFactory + "> : " + className);
            }
            case "cell": {
                this._classProvider = classProvider;
                c = this._classLoaderFactory.loadClass(className, this);
                if (c != null) break;
                throw new CommandException(35, "class not found in <" + this._classLoaderFactory + "> : " + className);
            }
            default: {
                throw new CommandException(37, "Unknown class provider type : " + providerType);
            }
        }
        Class[] paraList1 = new Class[]{CellNucleus.class};
        Class[] paraList2 = new Class[]{CellNucleus.class, CellShell.class};
        StringBuilder answer = new StringBuilder();
        try {
            Constructor<?> con = c.getConstructor(paraList2);
            paras = new Object[]{this._nucleus, this};
            interObject = con.newInstance(paras);
        }
        catch (Exception e0) {
            answer.append(e0.toString()).append('\n');
            try {
                Constructor<?> con = c.getConstructor(paraList1);
                paras = new Object[]{this._nucleus};
                interObject = con.newInstance(paras);
            }
            catch (Exception e1) {
                answer.append(e1.toString()).append('\n');
                try {
                    interObject = c.newInstance();
                    if (interObject == null) {
                        throw new CommandException(36, answer.toString());
                    }
                }
                catch (Throwable e2) {
                    answer.append(e2.toString()).append('\n');
                    throw new CommandException(36, answer.toString());
                }
            }
        }
        this._externalInterpreter = new CommandInterpreter(interObject);
        return " !!! Your are now in a new Shell !!! ";
    }

    @Override
    public byte[] getClassData(String className) throws IOException {
        CellMessage answer;
        _log.info("getClassData(" + className + ") send to classProvider");
        try {
            answer = this._nucleus.sendAndWait(new CellMessage(new CellPath(this._classProvider), (Serializable)((Object)("getclass " + className))), 4000L);
        }
        catch (InterruptedException e) {
            _log.info("getClassData Exception : " + e);
            return null;
        }
        catch (NoRouteToCellException e) {
            _log.info("getClassData Exception : " + e);
            return null;
        }
        if (answer == null) {
            _log.info("getClassData sendAndWait timed out");
            return null;
        }
        Serializable answerObject = answer.getMessageObject();
        if (answerObject == null) {
            return null;
        }
        if (!(answerObject instanceof byte[])) {
            _log.info("getClassData sendAndWait got : " + answerObject.toString());
            return null;
        }
        return (byte[])answerObject;
    }

    public String ac_onerror_$_1(Args args) {
        this._doOnExit = args.argv(0).equals("continue") ? null : args.argv(0);
        return "";
    }

    public String ac_show_onexit(Args args) {
        return this._doOnExit != null ? this._doOnExit : "";
    }

    public String ac_say_$_1_99(Args args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.argc(); ++i) {
            sb.append(args.argv(i)).append(' ');
        }
        String msg = sb.toString();
        String levelString = args.getOpt("level");
        if (levelString != null && levelString.length() > 0) {
            switch (levelString) {
                case "say": {
                    _log.info(msg);
                    break;
                }
                case "esay": {
                    _log.warn(msg);
                    break;
                }
                case "fsay": {
                    _log.error(msg);
                    break;
                }
                default: {
                    try {
                        int level = Integer.parseInt(levelString);
                        if ((level & 1) != 0) {
                            _log.info(msg);
                        }
                        if ((level & 2) != 0) {
                            _log.warn(msg);
                        }
                        if ((level & 0x10) != 0) {
                            _log.error(msg);
                        }
                        if ((level & 4) != 0) {
                            _logNucleus.info(msg);
                        }
                        if ((level & 8) == 0) break;
                        _logNucleus.warn(msg);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal Level string: " + levelString);
                    }
                }
            }
        }
        return msg;
    }

    public String ac_echo_$_1_99(Args args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.argc(); ++i) {
            sb.append(args.argv(i)).append(' ');
        }
        return sb.toString();
    }

    public String ac_show_error(Args args) {
        if (this._errorCode == 0) {
            return "No Error found";
        }
        return "errorCode=" + this._errorCode + "; Msg = " + (this._errorMsg == null ? "None" : this._errorMsg);
    }

    public String ac_set_helpmode_$_1(Args args) throws CommandException {
        String mode;
        switch (mode = args.argv(0)) {
            case "none": {
                this._helpMode = 0;
                break;
            }
            case "full": {
                this._helpMode = 2;
                break;
            }
            default: {
                throw new CommandException(22, "Illegal Help Mode : " + mode);
            }
        }
        return "";
    }

    public String ac_id(Args args) {
        return this._nucleus.getCellDomainName() + "\n";
    }

    public Object ac_set_context_$_2(CommandRequestable request) throws CommandException {
        Map<String, Object> dict = this._nucleus.getDomainContext();
        Object contextName = request.getArgv(0);
        if (!(contextName instanceof String)) {
            throw new CommandException(67, "ContextName not a string");
        }
        dict.put((String)contextName, request.getArgv(1));
        Object o = dict.get(contextName);
        if (o == null) {
            throw new CommandException(68, "Setting of " + contextName + " failed");
        }
        Object[] answer = new Object[]{contextName, o};
        return answer;
    }

    public String ac_check_$_1_99(Args args) throws CommandException {
        boolean strong = args.hasOption("strong");
        for (int i = 0; i < args.argc(); ++i) {
            String strValue;
            String varName = args.argv(i);
            Object value = this._environment.get(varName);
            if (value == null) {
                value = this._nucleus.getDomainContext().get(varName);
            }
            if (value == null) {
                throw new CommandException(1, "variable not define : " + varName);
            }
            if (!strong || !(strValue = value.toString()).trim().equals("")) continue;
            throw new CommandException(2, "variable defined but empty : " + varName);
        }
        return "";
    }

    public String ac_import_context_$_1(Args args) throws CommandException {
        return this.imprt_dict(args, this._nucleus.getDomainContext());
    }

    public String ac_import_env_$_1(Args args) throws CommandException {
        return this.imprt_dict(args, this._environment);
    }

    private String imprt_dict(Args args, Map<String, Object> dict) throws CommandException {
        Object input;
        String varName = args.argv(0);
        boolean opt_overwrite = !args.hasOption("c");
        boolean resolve = !args.hasOption("nr");
        String src = args.getOpt("source");
        if (src == null) {
            input = this._environment.get(varName);
            if (input == null) {
                input = this._nucleus.getDomainContext().get(varName);
            }
        } else if (src.equals("env")) {
            input = this._environment.get(varName);
        } else if (src.equals("context")) {
            input = this._nucleus.getDomainContext().get(varName);
        } else {
            throw new CommandException("Invalid value for -source=" + src);
        }
        if (input == null) {
            throw new CommandException("Variable not defined: " + varName);
        }
        try {
            ReplaceableBackedProperties properties = new ReplaceableBackedProperties(this);
            properties.load(new StringReader(input.toString()));
            for (String key : properties.stringPropertyNames()) {
                if (!opt_overwrite && dict.get(key) != null) continue;
                String value = ((Properties)properties).getProperty(key);
                int length = value.length();
                if (length > 1 && value.charAt(0) == '\"' && value.charAt(length - 1) == '\"') {
                    value = value.substring(1, length - 1);
                }
                if (resolve) {
                    value = Formats.replaceKeywords(value, new PropertiesBackedReplaceable(properties));
                }
                dict.put(key, value);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CommandException(3, "Failed to read " + varName + ": " + e);
        }
        return "";
    }

    public String ac_set_context_$_2(Args args) throws CommandException {
        return this.set_dict(args, this._nucleus.getDomainContext());
    }

    public String ac_set_env_$_2(Args args) throws CommandException {
        return this.set_dict(args, this._environment);
    }

    private String set_dict(Args args, Map<String, Object> dict) throws CommandException {
        String name = args.argv(0);
        String value = args.argv(1);
        boolean opt_overwrite = !args.hasOption("c");
        boolean opt_interpreter = args.hasOption("s");
        if (!opt_overwrite && dict.get(name) != null) {
            throw new CommandEvaluationException(1, "Variable " + name + " is already set and can't be overwritten due to '-c'");
        }
        if (opt_interpreter) {
            boolean I_IDLE = false;
            boolean I_BS = true;
            int state = 0;
            StringBuilder sb = new StringBuilder();
            block4: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (state) {
                    case 0: {
                        if (c == '\\') {
                            state = 1;
                            continue block4;
                        }
                        sb.append(c);
                        continue block4;
                    }
                    case 1: {
                        if (c == 'n') {
                            state = 0;
                            sb.append('\n');
                            continue block4;
                        }
                        sb.append('\\');
                        sb.append(c);
                    }
                }
            }
            value = sb.toString();
        }
        dict.put(name, value);
        return "";
    }

    public String ac_unset_context_$_1(Args args) throws CommandException {
        return this.unset_dict(args, this._nucleus.getDomainContext());
    }

    public String ac_unset_env_$_1(Args args) throws CommandException {
        return this.unset_dict(args, this._environment);
    }

    private String unset_dict(Args args, Map<String, Object> dict) throws CommandException {
        String name = args.argv(0);
        Object o = dict.remove(name);
        if (o == null) {
            throw new CommandException("Not found : " + name);
        }
        return name + "<" + o.getClass().getName() + "> removed\n";
    }

    public String ac_ls_$_0_1(Args args) throws CommandException {
        return this.ls_dict(args, args.hasOption("e") ? this._environment : this._nucleus.getDomainContext());
    }

    public String ac_show_context_$_0_1(Args args) throws CommandException {
        return this.show_dict(args, this._nucleus.getDomainContext());
    }

    public String ac_show_env_$_0_1(Args args) throws CommandException {
        return this.show_dict(args, this._environment);
    }

    public String ac_test_context_$_0_1(Args args) throws CommandException {
        return this.test_dict(args, this._nucleus.getDomainContext());
    }

    public String ac_test_env_$_0_1(Args args) throws CommandException {
        return this.test_dict(args, this._environment);
    }

    private String test_dict(Args args, Map<String, Object> dict) throws CommandException {
        String name = args.argv(0);
        if (dict.get(name) == null) {
            throw new CommandException(66, "not found : " + name);
        }
        return "";
    }

    private String show_dict(Args args, Map<String, Object> dict) throws CommandException {
        StringBuilder sb = new StringBuilder();
        if (args.argc() == 0) {
            for (Map.Entry<String, Object> e : dict.entrySet()) {
                String name = e.getKey();
                Object o = e.getValue();
                if (o instanceof String) {
                    sb.append(name).append("=");
                    String line = (String)o;
                    int len = line.length();
                    len = len > 40 ? 40 : len;
                    for (int i = 0; i < len; ++i) {
                        sb.append(line.charAt(i) == '\n' ? (char)'$' : line.charAt(i));
                    }
                    if (len == 40) {
                        sb.append("...\n");
                        continue;
                    }
                    sb.append("\n");
                    continue;
                }
                sb.append(name).append("=<").append(o.getClass().getName()).append(">\n");
            }
        } else {
            String name = args.argv(0);
            Object o = dict.get(name);
            if (o == null) {
                throw new CommandException(23, "Context name " + name + " not found");
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    private String ls_dict(Args args, Map<String, Object> dict) throws CommandException {
        StringBuilder sb = new StringBuilder();
        if (args.argc() == 0) {
            int maxLength = 0;
            SortedSet<String> set = CollectionFactory.newTreeSet();
            for (String name : dict.keySet()) {
                maxLength = Math.max(maxLength, name.length());
                set.add(name);
            }
            boolean detail = args.hasOption("l");
            boolean moreDetail = args.hasOption("ll");
            if (moreDetail) {
                detail = true;
            }
            boolean list = args.hasOption("list");
            for (String name : set) {
                sb.append(name);
                if (detail) {
                    sb.append("   ");
                    if (!list) {
                        int diff = maxLength - name.length();
                        for (int i = 0; i < diff; ++i) {
                            sb.append(".");
                        }
                    }
                    Object o = dict.get(name);
                    sb.append("  ").append(o.getClass().getName());
                    if (moreDetail) {
                        sb.append("\n          ");
                        String line = o.toString();
                        int len = line.length();
                        len = len > 40 ? 40 : len;
                        for (int i = 0; i < len; ++i) {
                            sb.append(line.charAt(i) == '\n' ? (char)'$' : line.charAt(i));
                        }
                        if (len == 40) {
                            sb.append("...");
                        }
                    }
                }
                sb.append("\n");
            }
        } else {
            throw new CommandSyntaxException("Not yet supported");
        }
        return sb.toString();
    }

    public String ac_test_$_1(Args args) throws CommandEvaluationException {
        Tester tester = this.testerForArgs(args);
        if (!tester.test()) {
            throw new CommandEvaluationException(1, tester.getMessage());
        }
        return "";
    }

    Tester testerForArgs(Args args) {
        if (args.argc() != 1) {
            throw new IllegalArgumentException("Expecting exactly one argument");
        }
        if (args.hasOption("i")) {
            return new CellRunningTester(args);
        }
        if (args.hasOption("e")) {
            return new FileExistsTester(args);
        }
        if (args.hasOption("f")) {
            return new FileIsNormalTester(args);
        }
        if (args.hasOption("d")) {
            return new FileIsDirectoryTester(args);
        }
        throw new IllegalArgumentException("Expecting either -cell or -file");
    }

    public String ac_exec_$_1_99(Args args) throws CommandException {
        try {
            URI uri = new URI(args.argv(0));
            args.shift();
            return this.run_reader(uri, args);
        }
        catch (URISyntaxException e) {
            throw new CommandException(43, e.getMessage());
        }
    }

    public String ac_exec_env_$_1_99(Args args) throws CommandException {
        try {
            URI uri = new URI("env", args.argv(0), null);
            args.shift();
            return this.run_reader(uri, args);
        }
        catch (URISyntaxException e) {
            throw new CommandException(43, e.getMessage());
        }
    }

    public String ac_exec_context_$_1_99(Args args) throws CommandException {
        try {
            URI uri = new URI("context", args.argv(0), null);
            args.shift();
            return this.run_reader(uri, args);
        }
        catch (URISyntaxException e) {
            throw new CommandException(43, e.getMessage());
        }
    }

    private void println(Writer out, String s) throws IOException {
        if (!s.isEmpty()) {
            out.append(s);
            if (s.length() > 0 && s.charAt(s.length() - 1) != '\n') {
                out.append('\n');
            }
        }
    }

    public void execute(String source, Reader in, Args args) throws CommandExitException, IOException {
        try (BufferedLineWriter out = new BufferedLineWriter(new Slf4jInfoWriter(_log));
             BufferedLineWriter err = new BufferedLineWriter(new Slf4jErrorWriter(_log));){
            this.execute(source, in, out, err, args);
        }
    }

    public void execute(String source, Reader in, Writer out, Writer err, Args args) throws CommandExitException, IOException {
        List<String> store = this._argumentVector;
        int no = 1;
        try {
            String line;
            this._argumentVector = new Vector<String>();
            for (int i = 0; i < args.argc(); ++i) {
                this._argumentVector.add(args.argv(i));
            }
            StringBuilder sb = null;
            BufferedReader input = new BufferedReader(in);
            while ((line = input.readLine()) != null) {
                String s = line.trim();
                if (s.length() != 0 && s.charAt(0) != '#') {
                    int len = line.length();
                    if (line.charAt(len - 1) == '\\') {
                        if (sb == null) {
                            sb = new StringBuilder();
                        }
                        sb.append(line.substring(0, len - 1)).append(' ');
                    } else {
                        Serializable answer;
                        if (sb != null) {
                            sb.append(line);
                            line = sb.toString();
                            sb = null;
                        }
                        if (!((answer = this.objectCommand2(line)) instanceof Throwable)) {
                            this.println(out, answer.toString());
                        } else {
                            String msg;
                            Throwable error = (Throwable)answer;
                            if (this._doOnExit != null) {
                                msg = String.format("%s: line %d: %s", source, no, error.getMessage());
                                if (this._doOnExit.equals("shutdown")) {
                                    throw new CommandExitException(msg, 666, error);
                                }
                                if (error instanceof CommandException) {
                                    int rc = ((CommandException)error).getErrorCode();
                                    throw new CommandExitException(msg, rc, error);
                                }
                                throw new CommandExitException(msg, 1, error);
                            }
                            if (error instanceof IllegalArgumentException) {
                                msg = String.format("%s: line %d: Illegal argument (%s)", source, no, error.getMessage());
                                this.println(err, msg);
                            } else if (error instanceof RuntimeException) {
                                _log.warn(error.toString(), error);
                            } else if (!(error instanceof CommandEvaluationException)) {
                                msg = Exceptions.getMessageWithCauses(error);
                                this.println(err, String.format("%s: line %d: Command failed (%s)", source, no, msg));
                            }
                        }
                    }
                }
                ++no;
            }
        }
        catch (IOException e) {
            throw new IOException(String.format("%s: line %d: %s", source, no, e.getMessage()), e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("%s: line %d: %s", source, no, e.getMessage()), e);
        }
        finally {
            this._argumentVector = store;
        }
    }

    private String run_reader(URI uri, Args args) throws CommandException {
        Object x;
        String loopName = args.getOpt("loop");
        String var = args.getOpt("ifok");
        if (var != null && (var.equals("") ? this._errorCode != 0 : (x = this.getDictionaryEntry(var)) == null || !x.toString().equals("0"))) {
            return "";
        }
        var = args.getOpt("ifnotok");
        if (var != null && (var.equals("") ? this._errorCode == 0 : (x = this.getDictionaryEntry(var)) != null && x.toString().equals("0"))) {
            return "";
        }
        try {
            StringWriter out = new StringWriter();
            if (loopName == null) {
                CellShell shell = args.hasOption("shell") ? new CellShell(this._nucleus) : this;
                try (Reader in = this.open(uri);){
                    shell.execute(uri.toString(), in, out, out, args);
                }
            }
            try (Reader loopReader = this._nucleus.getDomainContextReader(loopName);){
                String line;
                BufferedReader reader = new BufferedReader(loopReader);
                while ((line = reader.readLine()) != null) {
                    CellShell shell = args.hasOption("shell") ? new CellShell(this._nucleus) : this;
                    Reader in = this.open(uri);
                    Throwable throwable = null;
                    try {
                        shell.execute(uri.toString(), in, out, out, new Args(line));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
            return args.hasOption("nooutput") ? "" : out.toString();
        }
        catch (FileNotFoundException e) {
            throw new CommandException(66, e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CommandExitException("I/O error: " + e.getMessage(), 11);
        }
    }

    public String ac_eval_$_1_99(Args args) throws CommandException {
        int rc;
        Stack<String> v = new Stack<String>();
        for (int i = 0; i < args.argc(); ++i) {
            Object left;
            Object right;
            if (args.argv(i).equals("==")) {
                right = v.pop();
                v.push(right.equals(left = v.pop()) ? "0" : "1");
                continue;
            }
            if (args.argv(i).equals("!=")) {
                right = v.pop();
                v.push(right.equals(left = v.pop()) ? "1" : "0");
                continue;
            }
            if (args.argv(i).equals("&&")) {
                right = v.pop();
                left = v.pop();
                v.push(right.equals("0") && left.equals("0") ? "0" : "1");
                continue;
            }
            if (args.argv(i).equals("||")) {
                right = v.pop();
                left = v.pop();
                v.push(right.equals("0") || left.equals("0") ? "0" : "1");
                continue;
            }
            if (args.argv(i).equals("!")) {
                right = v.pop();
                v.push(right.equals("0") ? "1" : "0");
                continue;
            }
            v.push(args.argv(i).trim());
        }
        if (v.size() != 1) {
            throw new CommandException(2, "Stack position violation (" + v.size() + ")");
        }
        String result = (String)v.firstElement();
        if (result.equals("0")) {
            return "";
        }
        try {
            rc = Integer.parseInt(result);
        }
        catch (NumberFormatException nfe) {
            rc = 3;
        }
        throw new CommandEvaluationException(rc, "Eval Result : " + result);
    }

    public String ac_define_context_$_1_2(Args args) {
        this._contextName = args.argv(0);
        this._contextDelimiter = args.argc() > 1 ? args.argv(1) : ".";
        this._contextString = new StringBuilder();
        return "";
    }

    public String ac_define_env_$_1_2(Args args) {
        this._envName = args.argv(0);
        this._envDelimiter = args.argc() > 1 ? args.argv(1) : ".";
        this._envString = new StringBuilder();
        return "";
    }

    public String ac_load_context_$_2(Args args) throws CommandException {
        String name = args.argv(0);
        File file = new File(args.argv(1));
        if (!file.canRead()) {
            throw new CommandException("File not found : " + args.argv(1));
        }
        if (args.optc() != 0 && args.optv(0).equals("-b")) {
            FileInputStream in = null;
            try {
                long fileLength = file.length();
                byte[] buffer = new byte[(int)fileLength];
                in = new FileInputStream(file);
                in.read(buffer);
                in.close();
                this._nucleus.getDomainContext().put(name, buffer);
            }
            catch (IOException ioe) {
                throw new CommandException(11, "Problem with file : " + file + " : " + ioe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException eeee) {}
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException ioe) {
            throw new CommandException(11, "Problem with file : " + file + " : " + ioe);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException eeee) {}
            }
        }
        this._nucleus.getDomainContext().put(name, sb.toString());
        return "Loaded ... ";
    }

    public String ac_copy_$_2(Args args) throws CommandException {
        String destination;
        String source;
        URI to;
        URI from;
        try {
            from = new URI(args.argv(0));
            to = new URI(args.argv(1));
        }
        catch (URISyntaxException e) {
            throw new CommandException(43, "Invalid URL: " + e.toString());
        }
        if (from.equals(to)) {
            throw new CommandException(43, "Source and destination URL must not be the same");
        }
        try (BufferedReader in = new BufferedReader(this.open(from));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line).append("\n");
            }
            source = sb.toString();
        }
        catch (IOException e) {
            throw new CommandException(43, e.toString());
        }
        String scheme = to.getScheme();
        if (scheme == null) {
            scheme = "env";
        }
        if ((destination = to.getSchemeSpecificPart()) == null) {
            throw new CommandException(43, "Destination missing");
        }
        switch (scheme) {
            case "env": {
                this._environment.put(destination, source);
                break;
            }
            case "context": {
                this._nucleus.getDomainContext().put(destination, source);
                break;
            }
            default: {
                throw new CommandException(43, "Unsupported scheme for destination:" + scheme);
            }
        }
        return "";
    }

    public String ac_exit_$_0_2(Args args) throws CommandExitException {
        String msg = "";
        int code = 0;
        if (args.argc() > 0) {
            try {
                code = new Integer(args.argv(0));
            }
            catch (Exception e) {
                code = 0;
            }
            if (args.argc() > 1) {
                msg = args.argv(1);
            }
        }
        throw new CommandExitException(msg, code);
    }

    private Reader open(URI uri) throws IOException {
        String scheme = uri.getScheme();
        String ssp = uri.getSchemeSpecificPart();
        if (scheme == null) {
            return new InputStreamReader(uri.toURL().openStream());
        }
        if (scheme.equals("context")) {
            String host = uri.getHost();
            String path = uri.getPath();
            if (host == null) {
                return this._nucleus.getDomainContextReader(ssp);
            }
            if (path == null || path.length() < 2) {
                throw new MalformedURLException("Cell URI must be on the form: context://domainname/variable");
            }
            Object o = this.getRemoteData("System@" + host, "show context " + path.substring(1), 4000L);
            if (o instanceof Exception) {
                throw new IOException(o.toString());
            }
            return new StringReader(o.toString());
        }
        if (scheme.equals("env")) {
            Object o = this._environment.get(ssp);
            if (o == null) {
                throw new IOException("Variable not defined: " + ssp);
            }
            return new StringReader(o.toString());
        }
        if (scheme.equals("cell")) {
            String host = uri.getHost();
            String path = uri.getPath();
            if (host == null || path == null || path.length() < 2) {
                throw new MalformedURLException("Cell URI must be on the form: cell://cellname/command");
            }
            Object o = this.getRemoteData(host, path.substring(1), 4000L);
            if (o instanceof Exception) {
                throw new IOException(o.toString());
            }
            return new StringReader(o.toString());
        }
        return new InputStreamReader(uri.toURL().openStream());
    }

    private Object getRemoteData(String path, String command, long timeout) throws IOException {
        try {
            CellMessage answer = this._nucleus.sendAndWait(new CellMessage(new CellPath(path), (Serializable)((Object)command)), timeout);
            if (answer == null) {
                throw new IOException("Request timed out");
            }
            return answer.getMessageObject();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        catch (NoRouteToCellException e) {
            throw new IOException("sendAndWait : " + e);
        }
    }

    private class FileIsDirectoryTester
    implements Tester {
        private final File _file;
        private boolean _exists;

        FileIsDirectoryTester(Args args) {
            this._file = new File(args.argv(0));
        }

        @Override
        public boolean test() {
            this._exists = this._file.exists();
            return this._file.isDirectory();
        }

        @Override
        public String getMessage() {
            return this._file.toString() + (this._exists ? " is not a directory file" : " does not exist");
        }
    }

    private class FileIsNormalTester
    implements Tester {
        private final File _file;
        private boolean _exists;

        FileIsNormalTester(Args args) {
            this._file = new File(args.argv(0));
        }

        @Override
        public boolean test() {
            this._exists = this._file.exists();
            return this._file.isFile();
        }

        @Override
        public String getMessage() {
            return this._file.toString() + (this._exists ? " is not a normal file" : " does not exist");
        }
    }

    private class FileExistsTester
    implements Tester {
        private final File _file;

        FileExistsTester(Args args) {
            this._file = new File(args.argv(0));
        }

        @Override
        public boolean test() {
            return this._file.exists();
        }

        @Override
        public String getMessage() {
            return this._file.toString() + " does not exist";
        }
    }

    private class CellRunningTester
    implements Tester {
        private final String _name;

        CellRunningTester(Args args) {
            this._name = args.argv(0);
        }

        @Override
        public boolean test() {
            return CellShell.this._nucleus.getCellInfo(this._name) != null;
        }

        @Override
        public String getMessage() {
            return this._name + " is not running";
        }
    }

    private static interface Tester {
        public boolean test();

        public String getMessage();
    }
}

