/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.collect.Lists;
import dmg.cells.nucleus.CellAddressCore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CellPath
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4922955783102747577L;
    private List<CellAddressCore> _list = new ArrayList<CellAddressCore>();
    private int _position = -1;

    protected CellPath() {
    }

    protected CellPath(CellPath addr) {
        this._list.addAll(addr._list);
        this._position = addr._position;
    }

    public CellPath(String path) {
        this.add(path);
    }

    public CellPath(CellAddressCore address) {
        this.add(address);
    }

    public CellPath(String cellName, String domainName) {
        this(new CellAddressCore(cellName, domainName));
    }

    public int hops() {
        return this._list.size();
    }

    public synchronized void add(CellAddressCore core) {
        this._list.add(core);
        if (this._position < 0) {
            this._position = 0;
        }
    }

    public synchronized void add(CellPath addr) {
        this._list.addAll(addr._list);
        if (this._position < 0) {
            this._position = 0;
        }
    }

    public void add(String cell, String domain) {
        this.add(new CellAddressCore(cell, domain));
    }

    public synchronized void add(String path) {
        StringTokenizer st = new StringTokenizer(path, ":");
        while (st.hasMoreTokens()) {
            this.add(new CellAddressCore(st.nextToken()));
        }
    }

    public synchronized Object clone() {
        CellPath addr = new CellPath();
        addr._list.addAll(this._list);
        addr._position = this._position;
        return addr;
    }

    synchronized void insert(CellAddressCore core) {
        this._list.add(this._position + 1, core);
        if (this._position < 0) {
            this._position = 0;
        }
    }

    public synchronized void insert(String path) {
        StringTokenizer st = new StringTokenizer(path, ":");
        while (st.hasMoreTokens()) {
            this.insert(new CellAddressCore(st.nextToken()));
        }
    }

    public void insert(String cell, String domain) {
        this.add(new CellAddressCore(cell, domain));
    }

    public synchronized boolean next() {
        if (this._position >= this._list.size() - 1) {
            return false;
        }
        ++this._position;
        return true;
    }

    public synchronized CellPath revert() {
        CellPath copy = new CellPath();
        copy._list = Lists.newArrayList((Iterable)Lists.reverse(this._list));
        copy._position = copy._list.size() == 0 ? -1 : 0;
        return copy;
    }

    public synchronized boolean isFinalDestination() {
        return this._position >= this._list.size() - 1;
    }

    public synchronized boolean isFirstDestination() {
        return this._position == 0;
    }

    synchronized CellAddressCore getCurrent() {
        if (this._list.size() == 0 || this._position < 0 || this._position >= this._list.size()) {
            return null;
        }
        return this._list.get(this._position);
    }

    public synchronized CellAddressCore getSourceAddress() {
        return this._list.get(0);
    }

    public synchronized CellAddressCore getDestinationAddress() {
        return this._list.get(this._list.size() - 1);
    }

    synchronized void replaceCurrent(CellAddressCore core) {
        if (this._list.size() == 0 || this._position < 0 || this._position >= this._list.size()) {
            return;
        }
        this._list.set(this._position, core);
    }

    public String getCellName() {
        CellAddressCore core = this.getCurrent();
        return core == null ? null : core.getCellName();
    }

    public String getCellDomainName() {
        CellAddressCore core = this.getCurrent();
        return core == null ? null : core.getCellDomainName();
    }

    public synchronized String toSmallString() {
        int size = this._list.size();
        if (size == 0) {
            return "[empty]";
        }
        if (this._position >= size || this._position < 0) {
            return "[INVALID]";
        }
        CellAddressCore core = this._list.get(this._position);
        if (size == 1) {
            return "[" + core.toString() + "]";
        }
        if (this._position == 0) {
            return "[" + core.toString() + ":...(" + (size - 1) + ")...]";
        }
        if (this._position == size - 1) {
            return "[...(" + (size - 1) + ")...:" + core.toString() + "]";
        }
        return "[...(" + this._position + ")...:" + core.toString() + "...(" + (size - this._position - 1) + ")...]";
    }

    public String toString() {
        return this.toFullString();
    }

    public synchronized String toFullString() {
        int size = this._list.size();
        if (size == 0) {
            return "[empty]";
        }
        if (this._position >= size || this._position < 0) {
            return "[INVALID]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this._list.size(); ++i) {
            if (i > 0) {
                sb.append(":");
            }
            if (i == this._position) {
                sb.append(">");
            }
            sb.append(this._list.get(i).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        ArrayList<CellAddressCore> other;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CellPath)) {
            return false;
        }
        Object object = obj;
        synchronized (object) {
            other = new ArrayList<CellAddressCore>(((CellPath)obj)._list);
        }
        object = this;
        synchronized (object) {
            return this._list.equals(other);
        }
    }

    public synchronized int hashCode() {
        return this._list.hashCode();
    }

    public static void main(String[] args) {
        CellPath addr = new CellPath();
        for (String arg : args) {
            addr.add(arg);
        }
        System.out.println(addr.toFullString());
        System.out.println(addr.toString());
        while (addr.next()) {
            System.out.println(addr.toString());
        }
    }
}

