/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellGlue;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellLock;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellRoutingTable;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.EventLogger;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.SystemCell;
import dmg.cells.nucleus.UOID;
import dmg.util.Pinboard;
import dmg.util.logback.FilterThresholds;
import dmg.util.logback.RootFilterThresholds;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CellNucleus
implements ThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellNucleus.class);
    private static final int PINBOARD_DEFAULT_SIZE = 200;
    private static final int INITIAL = 0;
    private static final int ACTIVE = 1;
    private static final int REMOVING = 2;
    private static final int DEAD = 3;
    private static CellGlue __cellGlue;
    private final String _cellName;
    private final String _cellType;
    private ThreadGroup _threads;
    private final Cell _cell;
    private final Date _creationTime = new Date();
    private int _state = 0;
    private final Map<UOID, CellLock> _waitHash = new HashMap<UOID, CellLock>();
    private String _cellClass;
    private volatile ThreadPoolExecutor _callbackExecutor;
    private volatile ThreadPoolExecutor _messageExecutor;
    private boolean _isPrivateCallbackExecutor = true;
    private boolean _isPrivateMessageExecutor = true;
    private Pinboard _pinboard;
    private FilterThresholds _loggingThresholds;
    private static final MessageEvent LAST_MESSAGE_EVENT;

    public CellNucleus(Cell cell, String name) {
        this(cell, name, "Generic");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CellNucleus(Cell cell, String name, String type) {
        this.setPinboard(new Pinboard(200));
        if (__cellGlue == null) {
            if (!(cell instanceof SystemCell)) throw new IllegalArgumentException("System must be first Cell");
            __cellGlue = new CellGlue(name);
            this._cellName = "System";
            this._cellType = "System";
            __cellGlue.setSystemNucleus(this);
        } else {
            if (cell instanceof SystemCell) {
                throw new IllegalArgumentException("System already exists");
            }
            String cellName = name.replace('@', '+');
            if (cellName == null || cellName.equals("")) {
                cellName = "*";
            }
            if (cellName.charAt(cellName.length() - 1) == '*') {
                cellName = cellName.length() == 1 ? "$-" + this.getUnique() : cellName.substring(0, cellName.length() - 1) + "-" + this.getUnique();
            }
            this._cellName = cellName;
            this._cellType = type;
        }
        this._cell = cell;
        this._cellClass = this._cell.getClass().getName();
        CellNucleus parentNucleus = CellNucleus.getLogTargetForCell(MDC.get((String)"cells.cell"));
        FilterThresholds parentThresholds = parentNucleus.isSystemNucleus() || parentNucleus == this ? RootFilterThresholds.getInstance() : parentNucleus.getLoggingThresholds();
        this.setLoggingThresholds(new FilterThresholds(parentThresholds));
        try {
            this._threads = new ThreadGroup(__cellGlue.getMasterThreadGroup(), this._cellName + "-threads");
        }
        catch (SecurityException se) {
            this._threads = null;
        }
        this._callbackExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this);
        this._messageExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this);
        this._state = 1;
        __cellGlue.addCell(this._cellName, this);
        LOGGER.info("Created {}", (Object)name);
    }

    public static CellNucleus getLogTargetForCell(String cell) {
        CellNucleus nucleus = null;
        if (__cellGlue != null) {
            if (cell != null) {
                nucleus = __cellGlue.getCell(cell);
            }
            if (nucleus == null) {
                nucleus = __cellGlue.getSystemNucleus();
            }
        }
        return nucleus;
    }

    void setSystemNucleus(CellNucleus nucleus) {
        __cellGlue.setSystemNucleus(nucleus);
    }

    boolean isSystemNucleus() {
        return this == __cellGlue.getSystemNucleus();
    }

    public String getCellName() {
        return this._cellName;
    }

    public String getCellType() {
        return this._cellType;
    }

    public String getCellClass() {
        return this._cellClass;
    }

    public void setCellClass(String cellClass) {
        this._cellClass = cellClass;
    }

    public CellAddressCore getThisAddress() {
        return new CellAddressCore(this._cellName, __cellGlue.getCellDomainName());
    }

    public String getCellDomainName() {
        return __cellGlue.getCellDomainName();
    }

    public List<String> getCellNames() {
        return __cellGlue.getCellNames();
    }

    public CellInfo getCellInfo(String name) {
        return __cellGlue.getCellInfo(name);
    }

    public CellInfo getCellInfo() {
        return __cellGlue.getCellInfo(this.getCellName());
    }

    public Map<String, Object> getDomainContext() {
        return __cellGlue.getCellContext();
    }

    public Reader getDomainContextReader(String contextName) throws FileNotFoundException {
        Object o = __cellGlue.getCellContext(contextName);
        if (o == null) {
            throw new FileNotFoundException("Context not found : " + contextName);
        }
        return new StringReader(o.toString());
    }

    public void setDomainContext(String contextName, Object context) {
        __cellGlue.getCellContext().put(contextName, context);
    }

    public Object getDomainContext(String str) {
        return __cellGlue.getCellContext(str);
    }

    public String[][] getClassProviders() {
        return __cellGlue.getClassProviders();
    }

    public synchronized void setClassProvider(String selection, String provider) {
        __cellGlue.setClassProvider(selection, provider);
    }

    Cell getThisCell() {
        return this._cell;
    }

    CellInfo _getCellInfo() {
        CellInfo info = new CellInfo();
        info.setCellName(this.getCellName());
        info.setDomainName(this.getCellDomainName());
        info.setCellType(this.getCellType());
        info.setCreationTime(this._creationTime);
        try {
            info.setCellVersion(this._cell.getCellVersion());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            info.setPrivateInfo(this._cell.getInfo());
        }
        catch (Exception e) {
            info.setPrivateInfo("Not yet/No more available\n");
        }
        try {
            info.setShortInfo(this._cell.toString());
        }
        catch (Exception e) {
            info.setShortInfo("Not yet/No more available");
        }
        info.setCellClass(this._cellClass);
        try {
            info.setEventQueueSize(this.getEventQueueSize());
            info.setState(this._state);
            info.setThreadCount(this._threads.activeCount());
        }
        catch (Exception e) {
            info.setEventQueueSize(0);
            info.setState(0);
            info.setThreadCount(0);
        }
        return info;
    }

    public void setLoggingThresholds(FilterThresholds thresholds) {
        this._loggingThresholds = thresholds;
    }

    public FilterThresholds getLoggingThresholds() {
        return this._loggingThresholds;
    }

    public synchronized void setPinboard(Pinboard pinboard) {
        this._pinboard = pinboard;
    }

    public synchronized Pinboard getPinboard() {
        return this._pinboard;
    }

    public synchronized void setAsyncCallback(boolean asyncCallback) {
        if (asyncCallback) {
            this.setCallbackExecutor(new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this));
        } else {
            this.setCallbackExecutor(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this));
        }
        this._isPrivateCallbackExecutor = true;
    }

    public synchronized void setCallbackExecutor(ThreadPoolExecutor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("null is not allowed");
        }
        if (this._isPrivateCallbackExecutor) {
            this._callbackExecutor.shutdown();
        }
        this._callbackExecutor = executor;
        this._isPrivateCallbackExecutor = false;
    }

    public synchronized void setMessageExecutor(ThreadPoolExecutor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("null is not allowed");
        }
        if (this._isPrivateMessageExecutor) {
            this._messageExecutor.shutdown();
        }
        this._messageExecutor = executor;
        this._isPrivateMessageExecutor = false;
    }

    private synchronized void shutdownPrivateExecutors() {
        if (this._isPrivateCallbackExecutor) {
            this._callbackExecutor.shutdown();
        }
        if (this._isPrivateMessageExecutor) {
            this._messageExecutor.shutdown();
        }
    }

    public void sendMessage(CellMessage msg) throws SerializationException, NoRouteToCellException {
        this.sendMessage(msg, true, true);
    }

    public void resendMessage(CellMessage msg) throws SerializationException, NoRouteToCellException {
        this.sendMessage(msg, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(CellMessage msg, boolean locally, boolean remotely) throws SerializationException, NoRouteToCellException {
        if (!msg.isStreamMode()) {
            msg.touch();
        }
        EventLogger.sendBegin(this, msg, "async");
        try {
            __cellGlue.sendMessage(this, msg, locally, remotely);
        }
        finally {
            EventLogger.sendEnd(msg);
        }
    }

    public CellMessage sendAndWait(CellMessage msg, long timeout) throws SerializationException, NoRouteToCellException, InterruptedException {
        return this.sendAndWait(msg, true, true, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CellMessage sendAndWait(CellMessage msg, boolean local, boolean remote, long timeout) throws SerializationException, NoRouteToCellException, InterruptedException {
        if (!msg.isStreamMode()) {
            msg.touch();
        }
        msg.setTtl(timeout);
        EventLogger.sendBegin(this, msg, "blocking");
        UOID uoid = msg.getUOID();
        try {
            CellLock lock = new CellLock();
            Object object = this._waitHash;
            synchronized (object) {
                this._waitHash.put(uoid, lock);
            }
            LOGGER.trace("sendAndWait : adding to hash : {}", (Object)uoid);
            __cellGlue.sendMessage(this, msg, local, remote);
            object = lock;
            synchronized (object) {
                long start = System.currentTimeMillis();
                while (lock.getObject() == null && timeout > 0L) {
                    lock.wait(timeout);
                    timeout -= System.currentTimeMillis() - start;
                }
            }
            CellMessage answer = (CellMessage)lock.getObject();
            if (answer == null) {
                CellMessage start = null;
                return start;
            }
            Serializable obj = (answer = answer.decode()).getMessageObject();
            if (obj instanceof NoRouteToCellException) {
                throw (NoRouteToCellException)obj;
            }
            if (obj instanceof SerializationException) {
                throw (SerializationException)obj;
            }
            CellMessage cellMessage = answer;
            return cellMessage;
        }
        finally {
            Map<UOID, CellLock> map = this._waitHash;
            synchronized (map) {
                this._waitHash.remove(uoid);
            }
            EventLogger.sendEnd(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<UOID, CellLock> getWaitQueue() {
        HashMap<UOID, CellLock> hash = new HashMap<UOID, CellLock>();
        Map<UOID, CellLock> map = this._waitHash;
        synchronized (map) {
            hash.putAll(this._waitHash);
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateWaitQueue() {
        int size;
        ArrayList<CellLock> expired = new ArrayList<CellLock>();
        long now = System.currentTimeMillis();
        Map<UOID, CellLock> map = this._waitHash;
        synchronized (map) {
            Iterator<CellLock> i = this._waitHash.values().iterator();
            while (i.hasNext()) {
                CellLock lock = i.next();
                if (lock == null || lock.isSync() || lock.getTimeout() >= now) continue;
                expired.add(lock);
                i.remove();
            }
            size = this._waitHash.size();
        }
        for (CellLock lock : expired) {
            try {
                CellMessage envelope = lock.getMessage();
                EventLogger.sendEnd(envelope);
                lock.getCallback().answerTimedOut(envelope);
            }
            catch (RuntimeException e) {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(CellMessage msg, boolean local, boolean remote, CellMessageAnswerable callback, long timeout) throws SerializationException {
        if (!msg.isStreamMode()) {
            msg.touch();
        }
        msg.setTtl(timeout);
        EventLogger.sendBegin(this, msg, "callback");
        UOID uoid = msg.getUOID();
        boolean success = false;
        try {
            CellLock lock = new CellLock(msg, callback, timeout);
            Map<UOID, CellLock> map = this._waitHash;
            synchronized (map) {
                this._waitHash.put(uoid, lock);
            }
            __cellGlue.sendMessage(this, msg, local, remote);
            success = true;
        }
        catch (NoRouteToCellException e) {
            if (callback != null) {
                callback.exceptionArrived(msg, e);
            }
        }
        finally {
            if (!success) {
                Map<UOID, CellLock> map = this._waitHash;
                synchronized (map) {
                    this._waitHash.remove(uoid);
                }
                EventLogger.sendEnd(msg);
            }
        }
    }

    public void addCellEventListener(CellEventListener listener) {
        __cellGlue.addCellEventListener(this, listener);
    }

    public void export() {
        __cellGlue.export(this);
    }

    public void kill() {
        __cellGlue.kill(this);
    }

    public void kill(String cellName) throws IllegalArgumentException {
        __cellGlue.kill(this, cellName);
    }

    public void listThreadGroupOf(String cellName) {
        __cellGlue.threadGroupList(cellName);
    }

    public void threadGroupList() {
        Thread[] threads = new Thread[this._threads.activeCount()];
        this._threads.enumerate(threads);
        for (Thread thread : threads) {
            LOGGER.warn("Thread: {} [{}{}{}] ({}) {}", new Object[]{thread.getName(), thread.isAlive() ? "A" : "-", thread.isDaemon() ? "D" : "-", thread.isInterrupted() ? "I" : "-", thread.getPriority(), thread.getState()});
            for (StackTraceElement s : thread.getStackTrace()) {
                LOGGER.warn("    {}", (Object)s);
            }
        }
    }

    public boolean join(String cellName, long timeout) throws InterruptedException {
        return __cellGlue.join(cellName, timeout);
    }

    private Collection<Thread> getNonDaemonThreads(ThreadGroup group) {
        Thread[] threads = new Thread[group.activeCount()];
        int count = group.enumerate(threads);
        ArrayList<Thread> nonDaemonThreads = new ArrayList<Thread>(count);
        for (int i = 0; i < count; ++i) {
            Thread thread = threads[i];
            if (thread.isDaemon()) continue;
            nonDaemonThreads.add(thread);
        }
        return nonDaemonThreads;
    }

    private boolean joinThreads(Collection<Thread> threads, long timeout) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeout;
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            long wait = deadline - System.currentTimeMillis();
            if (wait <= 0L) {
                return false;
            }
            thread.join(wait);
            if (!thread.isAlive()) continue;
            return false;
        }
        return true;
    }

    private void killThreads(Collection<Thread> threads) {
        for (Thread thread : threads) {
            if (!thread.isAlive()) continue;
            LOGGER.debug("killerThread : interrupting {}", (Object)thread.getName());
            thread.interrupt();
        }
    }

    private Runnable wrapLoggingContext(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                try (CDC ignored = CDC.reset(CellNucleus.this);){
                    runnable.run();
                }
            }
        };
    }

    @Override
    public Thread newThread(Runnable target) {
        return new Thread(this._threads, this.wrapLoggingContext(target));
    }

    public Thread newThread(Runnable target, String name) {
        return new Thread(this._threads, this.wrapLoggingContext(target), name);
    }

    Thread[] getThreads(String cellName) {
        return __cellGlue.getThreads(cellName);
    }

    public ThreadGroup getThreadGroup() {
        return this._threads;
    }

    Thread[] getThreads() {
        if (this._threads == null) {
            return new Thread[0];
        }
        int threadCount = this._threads.activeCount();
        Thread[] list = new Thread[threadCount];
        int rc = this._threads.enumerate(list);
        if (rc == list.length) {
            return list;
        }
        Thread[] ret = new Thread[rc];
        System.arraycopy(list, 0, ret, 0, rc);
        return ret;
    }

    int getUnique() {
        return __cellGlue.getUnique();
    }

    int getEventQueueSize() {
        return this._messageExecutor.getQueue().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToEventQueue(MessageEvent ce) {
        if (ce instanceof RoutedMessageEvent && !(this._cell instanceof CellTunnel)) {
            ce = new MessageEvent(((RoutedMessageEvent)ce).getMessage());
        }
        try {
            CellMessage msg = ce.getMessage();
            if (msg != null) {
                CellLock lock;
                LOGGER.trace("addToEventQueue : message arrived : {}", (Object)msg);
                Object object = this._waitHash;
                synchronized (object) {
                    lock = this._waitHash.remove(msg.getLastUOID());
                }
                if (lock != null) {
                    LOGGER.trace("addToEventQueue : lock found for : {}", (Object)msg);
                    if (lock.isSync()) {
                        LOGGER.trace("addToEventQueue : is synchronous : {}", (Object)msg);
                        object = lock;
                        synchronized (object) {
                            lock.setObject(msg);
                            lock.notifyAll();
                        }
                        LOGGER.trace("addToEventQueue : dest. was triggered : {}", (Object)msg);
                    } else {
                        LOGGER.trace("addToEventQueue : is asynchronous : {}", (Object)msg);
                        try {
                            this._callbackExecutor.execute(new CallbackTask(lock, msg));
                        }
                        catch (RejectedExecutionException e) {
                            Map<UOID, CellLock> map = this._waitHash;
                            synchronized (map) {
                                this._waitHash.put(msg.getLastUOID(), lock);
                            }
                            throw e;
                        }
                    }
                    return;
                }
            }
            this._messageExecutor.execute(new DeliverMessageTask(ce));
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("Message queue overflow. Dropping {}", (Object)ce);
        }
    }

    void shutdown(KillEvent event) {
        LOGGER.trace("Received {}", (Object)event);
        try (CDC ignored = CDC.reset(this);){
            this._state = 2;
            this.addToEventQueue(LAST_MESSAGE_EVENT);
            try {
                this._cell.prepareRemoval(event);
            }
            catch (Throwable e) {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
            }
            this.shutdownPrivateExecutors();
            LOGGER.debug("Waiting for all threads in {} to finish", (Object)this._threads);
            try {
                Collection<Thread> threads = this.getNonDaemonThreads(this._threads);
                while (!this.joinThreads(threads, 1000L)) {
                    this.killThreads(threads);
                }
                this._threads.destroy();
            }
            catch (IllegalThreadStateException e) {
                this._threads.setDaemon(true);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted while waiting for threads");
            }
            __cellGlue.destroy(this);
            this._state = 3;
        }
    }

    public Cell createNewCell(String cellClass, String cellName, String cellArgs, boolean systemOnly) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        try {
            Object[] args = new Object[]{cellArgs};
            return __cellGlue._newInstance(cellClass, cellName, args, systemOnly);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw e;
        }
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return __cellGlue.loadClass(className);
    }

    public Cell createNewCell(String className, String cellName, String[] argsClassNames, Object[] args) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassCastException {
        if (argsClassNames == null) {
            return __cellGlue._newInstance(className, cellName, args, false);
        }
        return __cellGlue._newInstance(className, cellName, argsClassNames, args, false);
    }

    public Cell createNewCell(String cellClass, String cellName, Socket socket, boolean systemOnly) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        Object[] args = new Object[]{socket};
        return __cellGlue._newInstance(cellClass, cellName, args, systemOnly);
    }

    public void routeAdd(CellRoute route) throws IllegalArgumentException {
        __cellGlue.routeAdd(route);
    }

    public void routeDelete(CellRoute route) throws IllegalArgumentException {
        __cellGlue.routeDelete(route);
    }

    CellRoute routeFind(CellAddressCore addr) {
        return __cellGlue.getRoutingTable().find(addr);
    }

    CellRoutingTable getRoutingTable() {
        return __cellGlue.getRoutingTable();
    }

    CellRoute[] getRoutingList() {
        return __cellGlue.getRoutingList();
    }

    List<CellTunnelInfo> getCellTunnelInfos() {
        return __cellGlue.getCellTunnelInfos();
    }

    static {
        LAST_MESSAGE_EVENT = new LastMessageEvent();
    }

    private class DeliverMessageTask
    extends AbstractNucleusTask {
        private final CellEvent _event;

        public DeliverMessageTask(CellEvent event) {
            this._event = event;
            EventLogger.queueBegin(this._event);
        }

        @Override
        public void innerRun() {
            EventLogger.queueEnd(this._event);
            if (this._event instanceof LastMessageEvent) {
                LOGGER.trace("messageThread : LastMessageEvent arrived");
                CellNucleus.this._cell.messageArrived((MessageEvent)this._event);
            } else if (this._event instanceof RoutedMessageEvent) {
                LOGGER.trace("messageThread : RoutedMessageEvent arrived");
                CellNucleus.this._cell.messageArrived((RoutedMessageEvent)this._event);
            } else if (this._event instanceof MessageEvent) {
                CellMessage msg;
                MessageEvent msgEvent = (MessageEvent)this._event;
                LOGGER.trace("messageThread : MessageEvent arrived");
                try {
                    msg = msgEvent.getMessage().decode();
                }
                catch (SerializationException e) {
                    CellMessage envelope = msgEvent.getMessage();
                    LOGGER.error(String.format("Discarding a malformed message from %s with UOID %s and session [%s]: %s", envelope.getSourcePath(), envelope.getUOID(), envelope.getSession(), e.getMessage()), (Throwable)e);
                    return;
                }
                CDC.setMessageContext(msg);
                try {
                    LOGGER.trace("messageThread : delivering message: {}", (Object)msg);
                    CellNucleus.this._cell.messageArrived(new MessageEvent(msg));
                    LOGGER.trace("messageThread : delivering message done: {}", (Object)msg);
                }
                catch (RuntimeException e) {
                    if (!msg.isReply()) {
                        try {
                            msg.revertDirection();
                            msg.setMessageObject(e);
                            CellNucleus.this.sendMessage(msg);
                        }
                        catch (NoRouteToCellException f) {
                            LOGGER.error("PANIC : Problem returning answer: {}", (Throwable)f);
                        }
                    }
                    throw e;
                }
                finally {
                    CDC.clearMessageContext();
                }
            }
        }
    }

    private class CallbackTask
    extends AbstractNucleusTask {
        private final CellLock _lock;
        private final CellMessage _message;

        public CallbackTask(CellLock lock, CellMessage message) {
            this._lock = lock;
            this._message = message;
        }

        @Override
        public void innerRun() {
            try (CDC ignored = this._lock.getCdc().restore();){
                Serializable obj;
                CellMessage answer;
                CellMessageAnswerable callback = this._lock.getCallback();
                try {
                    answer = this._message.decode();
                    obj = answer.getMessageObject();
                }
                catch (SerializationException e) {
                    LOGGER.warn(e.getMessage());
                    obj = e;
                    answer = null;
                }
                EventLogger.sendEnd(this._lock.getMessage());
                if (obj instanceof Exception) {
                    callback.exceptionArrived(this._lock.getMessage(), (Exception)obj);
                } else {
                    callback.answerArrived(this._lock.getMessage(), answer);
                }
                LOGGER.trace("addToEventQueue : callback done for : {}", (Object)this._message);
            }
        }
    }

    private abstract class AbstractNucleusTask
    implements Runnable {
        private AbstractNucleusTask() {
        }

        protected abstract void innerRun();

        @Override
        public void run() {
            try (CDC ignored = CDC.reset(CellNucleus.this);){
                this.innerRun();
            }
            catch (Throwable e) {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
            }
        }
    }
}

