/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import com.google.common.collect.Maps;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellExceptionMessage;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellRoute;
import dmg.cells.nucleus.CellRoutingTable;
import dmg.cells.nucleus.CellTunnel;
import dmg.cells.nucleus.CellTunnelInfo;
import dmg.cells.nucleus.CellUrl;
import dmg.cells.nucleus.ClassLoaderProvider;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.RoutedMessageEvent;
import dmg.cells.nucleus.SerializationException;
import dmg.util.CollectionFactory;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CellGlue {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellGlue.class);
    private final String _cellDomainName;
    private final ConcurrentMap<String, CellNucleus> _cellList = Maps.newConcurrentMap();
    private final Set<CellNucleus> _killedCells = Collections.newSetFromMap(Maps.newConcurrentMap());
    private final Map<String, List<CellEventListener>> _cellEventListener = CollectionFactory.newConcurrentHashMap();
    private final Map<String, Object> _cellContext = CollectionFactory.newConcurrentHashMap();
    private final AtomicInteger _uniqueCounter = new AtomicInteger(100);
    private CellNucleus _systemNucleus;
    private ClassLoaderProvider _classLoader;
    private CellRoutingTable _routingTable = new CellRoutingTable();
    private ThreadGroup _masterThreadGroup;
    private ThreadGroup _killerThreadGroup;
    private final Executor _killerExecutor;
    private final ThreadPoolExecutor _emergencyKillerExecutor;
    private static final int MAX_ROUTE_LEVELS = 16;

    CellGlue(String cellDomainName) {
        String cellDomainNameLocal = cellDomainName;
        if (cellDomainName == null || cellDomainName.equals("")) {
            cellDomainNameLocal = "*";
        }
        if (cellDomainNameLocal.charAt(cellDomainNameLocal.length() - 1) == '*') {
            cellDomainNameLocal = cellDomainNameLocal.substring(0, cellDomainNameLocal.length()) + System.currentTimeMillis();
        }
        this._cellDomainName = cellDomainNameLocal;
        this._classLoader = new ClassLoaderProvider();
        this._masterThreadGroup = new ThreadGroup("Master-Thread-Group");
        this._killerThreadGroup = new ThreadGroup("Killer-Thread-Group");
        ThreadFactory killerThreadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(CellGlue.this._killerThreadGroup, r);
            }
        };
        this._killerExecutor = Executors.newCachedThreadPool(killerThreadFactory);
        this._emergencyKillerExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), killerThreadFactory);
        this._emergencyKillerExecutor.prestartCoreThread();
        new CellUrl(this);
    }

    ThreadGroup getMasterThreadGroup() {
        return this._masterThreadGroup;
    }

    void addCell(String name, CellNucleus cell) throws IllegalArgumentException {
        if (this._cellList.putIfAbsent(name, cell) != null) {
            throw new IllegalArgumentException("Name Mismatch ( cell " + name + " exist )");
        }
        this.sendToAll(new CellEvent(name, 3));
    }

    void setSystemNucleus(CellNucleus nucleus) {
        this._systemNucleus = nucleus;
    }

    CellNucleus getSystemNucleus() {
        return this._systemNucleus;
    }

    String[][] getClassProviders() {
        return this._classLoader.getProviders();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setClassProvider(String selection, String provider) {
        String type;
        String value = null;
        int pos = provider.indexOf(58);
        if (pos < 0) {
            if (provider.indexOf(47) >= 0) {
                type = "dir";
                value = provider;
            } else if (provider.indexOf(64) >= 0) {
                type = "cells";
                value = provider;
            } else if (provider.equals("system")) {
                type = "system";
            } else {
                if (!provider.equals("none")) throw new IllegalArgumentException("Can't determine provider type");
                type = "none";
            }
        } else {
            type = provider.substring(0, pos);
            value = provider.substring(pos + 1);
        }
        switch (type) {
            case "dir": {
                File file = new File(value);
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("Not a directory : " + value);
                }
                this._classLoader.addFileProvider(selection, new File(value));
                return;
            }
            case "cell": {
                this._classLoader.addCellProvider(selection, this._systemNucleus, new CellPath(value));
                return;
            }
            case "system": {
                this._classLoader.addSystemProvider(selection);
                return;
            }
            case "none": {
                this._classLoader.removeSystemProvider(selection);
                return;
            }
            default: {
                throw new IllegalArgumentException("Provider type not supported : " + type);
            }
        }
    }

    synchronized void export(CellNucleus cell) {
        this.sendToAll(new CellEvent(cell.getCellName(), 5));
    }

    private Class<?> _loadClass(String className) throws ClassNotFoundException {
        return this._classLoader.loadClass(className);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this._classLoader.loadClass(className);
    }

    Cell _newInstance(String className, String cellName, Object[] args, boolean systemOnly) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        Class<Cell> newClass = systemOnly ? Class.forName(className).asSubclass(Cell.class) : this._loadClass(className).asSubclass(Cell.class);
        Object[] arguments = new Object[args.length + 1];
        arguments[0] = cellName;
        System.arraycopy(args, 0, arguments, 1, args.length);
        Class[] argClass = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            argClass[i] = arguments[i].getClass();
        }
        return newClass.getConstructor(argClass).newInstance(arguments);
    }

    Cell _newInstance(String className, String cellName, String[] argsClassNames, Object[] args, boolean systemOnly) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        Class<Cell> newClass = systemOnly ? Class.forName(className).asSubclass(Cell.class) : this._loadClass(className).asSubclass(Cell.class);
        Object[] arguments = new Object[args.length + 1];
        arguments[0] = cellName;
        System.arraycopy(args, 0, arguments, 1, args.length);
        Class[] argClasses = new Class[arguments.length];
        ClassLoader loader = newClass.getClassLoader();
        argClasses[0] = String.class;
        if (loader == null) {
            for (int i = 1; i < argClasses.length; ++i) {
                argClasses[i] = Class.forName(argsClassNames[i - 1]);
            }
        } else {
            for (int i = 1; i < argClasses.length; ++i) {
                argClasses[i] = loader.loadClass(argsClassNames[i - 1]);
            }
        }
        return newClass.getConstructor(argClasses).newInstance(arguments);
    }

    Map<String, Object> getCellContext() {
        return this._cellContext;
    }

    Object getCellContext(String str) {
        return this._cellContext.get(str);
    }

    public void routeAdd(CellRoute route) {
        this._routingTable.add(route);
        this.sendToAll(new CellEvent(route, 7));
    }

    public void routeDelete(CellRoute route) {
        this._routingTable.delete(route);
        this.sendToAll(new CellEvent(route, 8));
    }

    CellRoutingTable getRoutingTable() {
        return this._routingTable;
    }

    CellRoute[] getRoutingList() {
        return this._routingTable.getRoutingList();
    }

    List<CellTunnelInfo> getCellTunnelInfos() {
        ArrayList<CellTunnelInfo> v = new ArrayList<CellTunnelInfo>();
        for (CellNucleus cellNucleus : this._cellList.values()) {
            Cell c = cellNucleus.getThisCell();
            if (!(c instanceof CellTunnel)) continue;
            v.add(((CellTunnel)((Object)c)).getCellTunnelInfo());
        }
        return v;
    }

    List<String> getCellNames() {
        return new ArrayList<String>(this._cellList.keySet());
    }

    int getUnique() {
        return this._uniqueCounter.incrementAndGet();
    }

    CellInfo getCellInfo(String name) {
        CellNucleus nucleus = this.getCell(name);
        return nucleus == null ? null : nucleus._getCellInfo();
    }

    Thread[] getThreads(String name) {
        CellNucleus nucleus = this.getCell(name);
        return nucleus == null ? null : nucleus.getThreads();
    }

    private void sendToAll(CellEvent event) {
        for (List<CellEventListener> listners : this._cellEventListener.values()) {
            for (CellEventListener hallo : listners) {
                if (hallo == null) {
                    LOGGER.trace("event distributor found NULL");
                    continue;
                }
                try {
                    switch (event.getEventType()) {
                        case 3: {
                            hallo.cellCreated(event);
                            break;
                        }
                        case 5: {
                            hallo.cellExported(event);
                            break;
                        }
                        case 4: {
                            hallo.cellDied(event);
                            break;
                        }
                        case 7: {
                            hallo.routeAdded(event);
                            break;
                        }
                        case 8: {
                            hallo.routeDeleted(event);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.info("Error while sending {}: {}", (Object)event, (Object)e);
                }
            }
        }
    }

    String getCellDomainName() {
        return this._cellDomainName;
    }

    void kill(CellNucleus nucleus) {
        this._kill(nucleus, nucleus, 0L);
    }

    void kill(CellNucleus sender, String cellName) throws IllegalArgumentException {
        CellNucleus nucleus = (CellNucleus)this._cellList.get(cellName);
        if (nucleus == null || this._killedCells.contains(nucleus)) {
            throw new IllegalArgumentException("Cell Not Found : " + cellName);
        }
        this._kill(sender, nucleus, 0L);
    }

    void threadGroupList(String cellName) {
        CellNucleus nucleus = (CellNucleus)this._cellList.get(cellName);
        if (nucleus != null) {
            nucleus.threadGroupList();
        } else {
            LOGGER.warn("cell {} is not running", (Object)cellName);
        }
    }

    CellNucleus getCell(String cellName) {
        return (CellNucleus)this._cellList.get(cellName);
    }

    synchronized boolean join(String cellName, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            while (this.getCell(cellName) != null) {
                this.wait();
            }
            return true;
        }
        while (this.getCell(cellName) != null && timeout > 0L) {
            long time = System.currentTimeMillis();
            this.wait(timeout);
            timeout -= System.currentTimeMillis() - time;
        }
        return timeout > 0L;
    }

    synchronized void destroy(CellNucleus nucleus) {
        this._cellList.remove(nucleus.getCellName());
        this._killedCells.remove(nucleus);
        LOGGER.trace("destroy : sendToAll : killed {}", (Object)nucleus.getCellName());
        this.notifyAll();
    }

    private void _kill(CellNucleus source, final CellNucleus destination, long to) {
        String cellToKill = destination.getCellName();
        if (!this._killedCells.add(destination)) {
            LOGGER.trace("Cell is being killed: {}", (Object)cellToKill);
            return;
        }
        CellPath sourceAddr = new CellPath(source.getCellName(), this.getCellDomainName());
        final KillEvent killEvent = new KillEvent(sourceAddr, to);
        this.sendToAll(new CellEvent(cellToKill, 4));
        Runnable command = new Runnable(){

            @Override
            public void run() {
                destination.shutdown(killEvent);
            }
        };
        try {
            this._killerExecutor.execute(command);
        }
        catch (OutOfMemoryError e) {
            this._emergencyKillerExecutor.execute(command);
        }
    }

    void sendMessage(CellNucleus nucleus, CellMessage msg) throws SerializationException, NoRouteToCellException {
        this.sendMessage(nucleus, msg, true, true);
    }

    void sendMessage(CellNucleus nucleus, CellMessage msg, boolean resolveLocally, boolean resolveRemotely) throws SerializationException, NoRouteToCellException {
        boolean firstSend = !msg.isStreamMode();
        CellMessage transponder = msg;
        if (firstSend) {
            transponder = msg.encode();
            transponder.addSourceAddress(nucleus.getThisAddress());
        }
        if (transponder.getSourcePath().hops() > 30) {
            LOGGER.error("Hop count exceeds 30, dumping: {}", (Object)transponder);
            return;
        }
        CellPath destination = transponder.getDestinationPath();
        CellAddressCore destCore = destination.getCurrent();
        String cellName = destCore.getCellName();
        LOGGER.trace("sendMessage : {} send to {}", (Object)transponder.getUOID(), (Object)destination);
        if (!firstSend && cellName.equals("*")) {
            LOGGER.trace("sendMessage : * detected ; skipping destination");
            destination.next();
            destCore = destination.getCurrent();
        }
        for (int iter = 0; iter < 16; ++iter) {
            CellRoute route;
            cellName = destCore.getCellName();
            String domainName = destCore.getCellDomainName();
            LOGGER.trace("sendMessage : next hop at {}: {}@{}", new Object[]{iter, cellName, domainName});
            CellNucleus destNucleus = (CellNucleus)this._cellList.get(cellName);
            if (destNucleus != null && this._killedCells.contains(destNucleus)) {
                destNucleus = null;
            }
            if (domainName.equals(this._cellDomainName)) {
                if (cellName.equals("*")) {
                    LOGGER.trace("sendMessagex : * detected ; skipping destination");
                    destination.next();
                    destCore = destination.getCurrent();
                    continue;
                }
                if (destNucleus == null) {
                    if (firstSend) {
                        throw new NoRouteToCellException(transponder.getUOID(), destination, "Initial Send");
                    }
                    this.sendException(nucleus, transponder, destination, cellName);
                    return;
                }
                if (iter == 0) {
                    destNucleus.addToEventQueue(new MessageEvent(transponder));
                } else {
                    transponder.addSourceAddress(new CellAddressCore("*", this._cellDomainName));
                    destNucleus.addToEventQueue(new RoutedMessageEvent(transponder));
                }
                return;
            }
            if (domainName.equals("local") && (resolveLocally || iter != 0)) {
                if (destNucleus != null) {
                    if (iter == 0) {
                        destNucleus.addToEventQueue(new MessageEvent(transponder));
                    } else {
                        transponder.addSourceAddress(new CellAddressCore("*", this._cellDomainName));
                        destNucleus.addToEventQueue(new RoutedMessageEvent(transponder));
                    }
                    return;
                }
                if (iter == 16) {
                    LOGGER.trace("sendMessage : max route iteration reached: {}", (Object)destination);
                    if (firstSend) {
                        throw new NoRouteToCellException(transponder.getUOID(), destination, "Initial Send");
                    }
                    this.sendException(nucleus, transponder, destination, cellName);
                    return;
                }
            } else if (domainName.equals("local") && !resolveRemotely && iter == 0) {
                throw new NoRouteToCellException(transponder.getUOID(), destination, " ! resolve remotely : " + destCore);
            }
            if ((route = this._routingTable.find(destCore)) == null || iter == 16) {
                LOGGER.trace("sendMessage : no route destination for : {}", (Object)destCore);
                if (firstSend) {
                    throw new NoRouteToCellException(transponder.getUOID(), destination, "Missing routing entry for " + destCore);
                }
                this.sendException(nucleus, transponder, destination, destCore.toString());
                return;
            }
            LOGGER.trace("sendMessage : using route : {}", (Object)route);
            destCore = route.getTarget();
            if (route.getRouteType() != 6) continue;
            destination.replaceCurrent(destCore);
        }
    }

    private void sendException(CellNucleus nucleus, CellMessage msg, CellPath destination, String routeTarget) throws SerializationException, NoRouteToCellException {
        LOGGER.debug("Message from {} could not be delivered because no route to {}\u00a0is known; the sender will be notified.", (Object)msg.getSourcePath(), (Object)routeTarget);
        NoRouteToCellException exception = new NoRouteToCellException(msg.getUOID(), destination, "Tunnel cell >" + routeTarget + "< not found at >" + this._cellDomainName + "<");
        CellPath retAddr = msg.getSourcePath().revert();
        CellExceptionMessage ret = new CellExceptionMessage(retAddr, exception);
        ret.setLastUOID(msg.getUOID());
        this.sendMessage(nucleus, ret);
    }

    void addCellEventListener(CellNucleus nucleus, CellEventListener listener) {
        List<CellEventListener> v = this._cellEventListener.get(nucleus.getCellName());
        if (v == null) {
            v = CollectionFactory.newCopyOnWriteArrayList();
            this._cellEventListener.put(nucleus.getCellName(), v);
        }
        v.add(listener);
    }

    public String toString() {
        return this._cellDomainName;
    }
}

