/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.network.PingMessage;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.Cell;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellEvent;
import dmg.cells.nucleus.CellEventListener;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellLock;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.CellShell;
import dmg.cells.nucleus.CellVersion;
import dmg.cells.nucleus.EventLogger;
import dmg.cells.nucleus.ExceptionEvent;
import dmg.cells.nucleus.KillEvent;
import dmg.cells.nucleus.LastMessageEvent;
import dmg.cells.nucleus.MessageEvent;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.Reply;
import dmg.cells.nucleus.SerializationException;
import dmg.cells.nucleus.UOID;
import dmg.util.Args;
import dmg.util.Authorizable;
import dmg.util.AuthorizedArgs;
import dmg.util.AuthorizedString;
import dmg.util.CommandAclException;
import dmg.util.CommandException;
import dmg.util.CommandExitException;
import dmg.util.CommandInterpreter;
import dmg.util.CommandPanicException;
import dmg.util.CommandRequestable;
import dmg.util.CommandSyntaxException;
import dmg.util.CommandThrowableException;
import dmg.util.Gate;
import dmg.util.Pinboard;
import dmg.util.logback.FilterShell;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.dcache.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellAdapter
extends CommandInterpreter
implements Cell,
CellEventListener,
CellEndpoint {
    private static final Logger _log = LoggerFactory.getLogger(CellAdapter.class);
    private static final long RETRY_PERIOD = 30000L;
    private final CellVersion _version = new CellVersion(Version.of((Object)this));
    private static final ThreadLocal<CellMessage> CURRENT_MESSAGE = new ThreadLocal();
    private final CellNucleus _nucleus;
    private final Gate _readyGate = new Gate(false);
    private final Gate _startGate = new Gate(false);
    private final Gate _shutdownGate = new Gate(false);
    private final Args _args;
    private boolean _useInterpreter = true;
    private boolean _returnCommandException = true;
    private boolean _answerPing = true;
    private String _autoSetup;
    private String _definedSetup;
    public static final String hh_exec_context = "<var> [<arg> ...]";
    public static final String fh_exec_context = "Executes the batch script in the context variable.";
    public static final String hh_info = "[-l|-a]";
    public static final String hh_show_pinboard = "[<lines>] # dumps the last <lines> to the terminal";
    public static final String hh_dump_pinboard = "<filename> # dumps the full pinboard to <filename>";
    private CellPath _aclPath = new CellPath("acm");
    private long _aclTimeout = 10000L;

    public CellAdapter(String cellName, String args, boolean startNow) {
        this(cellName, new Args(args == null ? "" : args), startNow);
    }

    public CellAdapter(String cellName, String cellType, String args, boolean startNow) {
        this(cellName, cellType, new Args(args == null ? "" : args), startNow);
    }

    public CellAdapter(String cellName, Args args, boolean startNow) {
        this(cellName, "Generic", args, startNow);
    }

    public CellAdapter(String cellName, String cellType, Args args, boolean startNow) {
        String async;
        this._args = args;
        this._nucleus = new CellNucleus(this, cellName, cellType);
        this._autoSetup = cellName + "Setup";
        if (this._args.argc() > 0 && (this._definedSetup = this._args.argv(0)).length() > 1 && this._definedSetup.startsWith("!")) {
            this._definedSetup = this._definedSetup.substring(1);
            this._args.shift();
        } else {
            this._definedSetup = null;
        }
        if (this._args.hasOption("export")) {
            this.export();
        }
        if ((async = this._args.getOpt("callback")) == null) {
            async = (String)this._nucleus.getDomainContext("callback");
        }
        if (async != null) {
            switch (async) {
                case "async": {
                    this.setAsyncCallback(true);
                    _log.info("Callback set to async");
                    break;
                }
                case "sync": {
                    this.setAsyncCallback(false);
                    _log.info("Callback set to sync");
                    break;
                }
                default: {
                    _log.warn("Illegal value for 'callback' option : " + async);
                }
            }
        }
        if (this._args.hasOption("replyObject") && this._args.getOpt("replyObject").equals("false")) {
            this.setCommandExceptionEnabled(false);
        }
        this.addCommandListener(new FilterShell(this._nucleus.getLoggingThresholds()));
        if (startNow) {
            this.start();
        }
    }

    public void start() {
        this.executeSetupContext();
        this._startGate.open();
    }

    public void executeSetupContext() {
        if (this._autoSetup != null) {
            this.executeDomainContext(this._autoSetup);
        }
        this._autoSetup = null;
        if (this._definedSetup != null) {
            this.executeDomainContext(this._definedSetup);
        }
        this._definedSetup = null;
    }

    protected void executeDomainContext(String name) {
        if (name != null) {
            try (Reader in = this._nucleus.getDomainContextReader(name);){
                CellShell shell = new CellShell(this);
                shell.execute("context:" + name, in, new Args(""));
            }
            catch (FileNotFoundException e) {
            }
            catch (CommandExitException | IOException e) {
                _log.warn(e.getMessage());
            }
        }
    }

    public void setAsyncCallback(boolean async) {
        this._nucleus.setAsyncCallback(async);
    }

    public String ac_exec_context_$_1_99(Args args) throws IOException, CommandExitException {
        StringWriter out = new StringWriter();
        String var = args.argv(0);
        try (Reader in = this._nucleus.getDomainContextReader(var);){
            args.shift();
            CellShell shell = new CellShell(this);
            shell.execute("context:" + var, in, out, out, args);
        }
        return out.toString();
    }

    public CellAdapter(String cellName) {
        this(cellName, "", true);
    }

    public CellAdapter(String cellName, String args) {
        this(cellName, args, true);
    }

    public void addCellEventListener(CellEventListener cel) {
        this._nucleus.addCellEventListener(cel);
    }

    public void addCellEventListener() {
        this._nucleus.addCellEventListener(this);
    }

    @Override
    public Args getArgs() {
        return this._args;
    }

    public void setCommandExceptionEnabled(boolean use) {
        this._returnCommandException = use;
    }

    public void useInterpreter(boolean use) {
        this._useInterpreter = use;
    }

    public void setAnswerPing(boolean ping) {
        this._answerPing = ping;
    }

    public CellNucleus getNucleus() {
        return this._nucleus;
    }

    public void initLoggingContext() {
        CDC.reset(this._nucleus);
    }

    protected void kill() {
        this._nucleus.kill();
    }

    public String getCellName() {
        return this._nucleus.getCellName();
    }

    public String getCellDomainName() {
        return this._nucleus.getCellDomainName();
    }

    public void export() {
        this._nucleus.export();
    }

    public void createPinboard(int size) {
        this._nucleus.setPinboard(new Pinboard(size <= 0 ? 200 : size));
    }

    public Object createNewCell(String className, String cellName, String[] argsClassNames, Object[] args) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, InvocationTargetException, IllegalAccessException, ClassCastException {
        return this._nucleus.createNewCell(className, cellName, argsClassNames, args);
    }

    @Override
    public Map<String, Object> getDomainContext() {
        return this._nucleus.getDomainContext();
    }

    public Reader getDomainContextReader(String contextName) throws FileNotFoundException {
        return this._nucleus.getDomainContextReader(contextName);
    }

    @Override
    public void sendMessage(CellMessage msg) throws SerializationException, NoRouteToCellException {
        this._nucleus.sendMessage(msg);
    }

    public void sendMessage(CellMessage msg, boolean locally, boolean remotely, CellMessageAnswerable callback, long timeout) throws SerializationException {
        this._nucleus.sendMessage(msg, locally, remotely, callback, timeout);
    }

    @Override
    public void sendMessage(CellMessage msg, CellMessageAnswerable callback, long timeout) throws SerializationException {
        this._nucleus.sendMessage(msg, true, true, callback, timeout);
    }

    public void sendMessage(CellMessage msg, boolean locally, boolean remotely) throws SerializationException, NoRouteToCellException {
        this._nucleus.sendMessage(msg, locally, remotely);
    }

    public CellMessage sendAndWait(CellMessage msg, boolean local, boolean remote, long millisecs) throws SerializationException, NoRouteToCellException, InterruptedException {
        return this._nucleus.sendAndWait(msg, local, remote, millisecs);
    }

    @Override
    public CellMessage sendAndWait(CellMessage msg, long millisecs) throws SerializationException, NoRouteToCellException, InterruptedException {
        return this._nucleus.sendAndWait(msg, true, true, millisecs);
    }

    private long timeUntil(long time) {
        return time - System.currentTimeMillis();
    }

    @Override
    public CellMessage sendAndWaitToPermanent(CellMessage envelope, long timeout) throws SerializationException, InterruptedException {
        long deadline = System.currentTimeMillis() + timeout;
        try {
            return this.sendAndWait(envelope, this.timeUntil(deadline));
        }
        catch (NoRouteToCellException e) {
            _log.warn("{}", (Object)e.toString());
            while (this.timeUntil(deadline) > 30000L && !this._shutdownGate.await(30000L)) {
                try {
                    return this.sendAndWait(envelope, this.timeUntil(deadline));
                }
                catch (NoRouteToCellException ignored) {
                }
            }
            return null;
        }
    }

    public void resendMessage(CellMessage msg) throws SerializationException, NoRouteToCellException {
        this._nucleus.resendMessage(msg);
    }

    public static final CellMessage getThisMessage() {
        return CURRENT_MESSAGE.get();
    }

    public String toString() {
        return this._nucleus.getCellName();
    }

    public void getInfo(PrintWriter printWriter) {
        printWriter.println(" CellName  : " + this._nucleus.getCellName());
        printWriter.println(" CellClass : " + this.getClass().getName());
        printWriter.println(" Arguments : " + this._args);
    }

    @Override
    public CellVersion getCellVersion() {
        return this._version;
    }

    @Override
    public CellInfo getCellInfo() {
        return this._nucleus.getCellInfo();
    }

    public void messageArrived(CellMessage msg) {
        _log.info(" CellMessage From   : " + msg.getSourcePath());
        _log.info(" CellMessage To     : " + msg.getDestinationPath());
        _log.info(" CellMessage Object : " + msg.getMessageObject());
    }

    public void messageToForward(CellMessage msg) {
        msg.nextDestination();
        try {
            this._nucleus.sendMessage(msg);
        }
        catch (NoRouteToCellException nrtc) {
            _log.warn("CellAdapter : NoRouteToCell in messageToForward : " + nrtc);
        }
        catch (Exception eee) {
            _log.warn("CellAdapter : Exception in messageToForward : " + eee);
        }
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this._nucleus.loadClass(className);
    }

    public Serializable commandArrived(String str, CommandSyntaxException cse) {
        StringBuilder sb = new StringBuilder();
        sb.append("Syntax Error : ").append(cse.getMessage()).append("\n");
        String help = cse.getHelpText();
        if (help != null) {
            sb.append("Help : \n");
            sb.append(help);
        }
        return sb.toString();
    }

    public void cleanUp() {
    }

    @Override
    public void cellCreated(CellEvent ce) {
    }

    @Override
    public void cellDied(CellEvent ce) {
    }

    @Override
    public void cellExported(CellEvent ce) {
    }

    @Override
    public void routeAdded(CellEvent ce) {
    }

    @Override
    public void routeDeleted(CellEvent ce) {
    }

    public String ac_say_$_1(Args args) {
        _log.info(args.argv(0));
        return "";
    }

    public Object ac_xgetcellinfo(Args args) {
        return this.getCellInfo();
    }

    public String ac_info(Args args) {
        boolean lng;
        boolean full = args.hasOption("a");
        boolean bl = lng = full || args.hasOption("l");
        if (lng) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getInfo()).append("\n");
            Map<UOID, CellLock> map = this._nucleus.getWaitQueue();
            if (!map.isEmpty()) {
                sb.append("\nWe are waiting for the following messages\n");
            }
            for (Map.Entry<UOID, CellLock> entry : map.entrySet()) {
                UOID key = entry.getKey();
                CellLock lock = entry.getValue();
                sb.append(((Object)key).toString()).append(" r=");
                long res = lock.getTimeout() - System.currentTimeMillis();
                sb.append(res / 1000L).append(" sec;");
                CellMessage msg = lock.getMessage();
                if (msg == null) {
                    sb.append("msg=none");
                } else {
                    Serializable obj = msg.getMessageObject();
                    if (obj != null) {
                        sb.append("msg=").append(obj.getClass().getName());
                        if (full) {
                            sb.append("/").append(obj.toString());
                        }
                    }
                }
                sb.append("\n");
            }
            return sb.toString();
        }
        return this.getInfo();
    }

    public String ac_show_pinboard_$_0_1(Args args) {
        Pinboard pinboard = this._nucleus.getPinboard();
        if (pinboard == null) {
            return "No Pinboard defined";
        }
        StringBuffer sb = new StringBuffer();
        if (args.argc() > 0) {
            pinboard.dump(sb, Integer.parseInt(args.argv(0)));
        } else {
            pinboard.dump(sb, 20);
        }
        return sb.toString();
    }

    public String ac_dump_pinboard_$_1(Args args) {
        Pinboard pinboard = this._nucleus.getPinboard();
        if (pinboard == null) {
            return "No Pinboard defined";
        }
        try {
            pinboard.dump(new File(args.argv(0)));
        }
        catch (IOException e) {
            return "Dump Failed : " + e;
        }
        return "Pinboard dumped to " + args.argv(0);
    }

    @Override
    public void prepareRemoval(KillEvent ce) {
        _log.info("CellAdapter : prepareRemoval : waiting for gate to open");
        this._readyGate.check();
        this._shutdownGate.open();
        this.cleanUp();
        this.dumpPinboard();
        _log.info("CellAdapter : prepareRemoval : done");
    }

    void dumpPinboard() {
        Pinboard pinboard = this._nucleus.getPinboard();
        try {
            Map<String, Object> context = this.getDomainContext();
            String dumpDir = (String)context.get("dumpDirectory");
            if (dumpDir == null) {
                _log.info("Pinboard not dumped (dumpDirectory not sp.)");
                return;
            }
            File dir = new File(dumpDir);
            if (!dir.isDirectory()) {
                _log.info("Pinboard not dumped (dumpDirectory {} not found)", (Object)dumpDir);
                return;
            }
            if (pinboard == null) {
                _log.info("Pinboard not dumped (no pinboard defined)");
                return;
            }
            File dump = new File(dir, this.getCellDomainName() + "-" + this.getCellName() + "-" + Long.toHexString(System.currentTimeMillis()));
            pinboard.dump(dump);
        }
        catch (IOException e) {
            _log.error("Dumping pinboard failed : {}", (Object)e.toString());
        }
    }

    @Override
    public void exceptionArrived(ExceptionEvent ce) {
        _log.info(" exceptionArrived " + ce);
    }

    @Override
    public String getInfo() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.getInfo(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(MessageEvent me) {
        block33: {
            this._startGate.check();
            if (me instanceof LastMessageEvent) {
                _log.info("messageArrived : LastMessageEvent (opening gate)");
                this._readyGate.open();
            } else {
                CellMessage msg = me.getMessage();
                Serializable obj = msg.getMessageObject();
                if (msg.isFinalDestination()) {
                    if (this._useInterpreter && !msg.isReply() && (obj instanceof String || obj instanceof AuthorizedString || obj instanceof CommandRequestable)) {
                        Serializable o;
                        UOID uoid = msg.getUOID();
                        EventLogger.deliverBegin(msg);
                        try {
                            CURRENT_MESSAGE.set(msg);
                            o = this.executeLocalCommand(obj);
                            if (o == null) {
                                return;
                            }
                        }
                        catch (CommandThrowableException e) {
                            o = e.getCause();
                        }
                        catch (CommandException ce) {
                            o = ce;
                        }
                        finally {
                            EventLogger.deliverEnd(msg.getSession(), uoid);
                            CURRENT_MESSAGE.remove();
                        }
                        try {
                            msg.revertDirection();
                            if (o instanceof Reply) {
                                Reply reply = (Reply)o;
                                reply.deliver(this, msg);
                                break block33;
                            }
                            msg.setMessageObject(o);
                            this._nucleus.sendMessage(msg);
                        }
                        catch (NoRouteToCellException e) {
                            _log.warn("PANIC : Problem returning answer : " + e);
                        }
                    } else if (obj instanceof PingMessage && this._answerPing) {
                        PingMessage ping = (PingMessage)obj;
                        if (ping.isWayBack()) {
                            this.messageArrived(msg);
                            return;
                        }
                        ping.setWayBack();
                        msg.revertDirection();
                        try {
                            this._nucleus.sendMessage(msg);
                        }
                        catch (NoRouteToCellException ee) {
                            _log.warn("Couldn't revert PingMessage : " + ee);
                        }
                    } else {
                        UOID uoid = msg.getUOID();
                        EventLogger.deliverBegin(msg);
                        try {
                            this.messageArrived(msg);
                        }
                        finally {
                            EventLogger.deliverEnd(msg.getSession(), uoid);
                        }
                    }
                } else if (obj instanceof PingMessage) {
                    msg.nextDestination();
                    try {
                        this._nucleus.sendMessage(msg);
                    }
                    catch (NoRouteToCellException ee) {
                        _log.warn("Couldn't forward PingMessage : " + ee);
                    }
                } else {
                    UOID uoid = msg.getUOID();
                    EventLogger.deliverBegin(msg);
                    try {
                        this.messageToForward(msg);
                    }
                    finally {
                        EventLogger.deliverEnd(msg.getSession(), uoid);
                    }
                }
            }
        }
    }

    private Serializable executeLocalCommand(Object command) throws CommandException {
        if (command instanceof Authorizable) {
            if (this._returnCommandException) {
                return this.command(new AuthorizedArgs((Authorizable)command));
            }
            return this.autoCommand(command);
        }
        if (command instanceof String) {
            if (this._returnCommandException) {
                return this.command(new Args((String)command));
            }
            return this.autoCommand(command);
        }
        if (command instanceof CommandRequestable) {
            return this.command((CommandRequestable)command);
        }
        throw new CommandPanicException("Illegal CommandClass detected", new Exception("PANIC"));
    }

    private Serializable autoCommand(Object command) {
        try {
            if (command instanceof String) {
                return this.command(new Args((String)command));
            }
            if (command instanceof AuthorizedString) {
                return this.command(new AuthorizedArgs((AuthorizedString)command));
            }
            return "Panic : internal server error 14345";
        }
        catch (CommandSyntaxException cse) {
            return this.commandArrived(command.toString(), cse);
        }
        catch (CommandExitException cee) {
            return "Sorry, can't exit";
        }
        catch (CommandThrowableException cte) {
            StringBuilder sb = new StringBuilder();
            sb.append(cte.getMessage()).append("\n");
            Throwable t = cte.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
            return sb.toString();
        }
        catch (CommandPanicException cpe) {
            StringBuilder sb = new StringBuilder();
            sb.append("Panic : ").append(cpe.getMessage()).append("\n");
            Throwable t = cpe.getTargetException();
            sb.append(t.getClass().getName()).append(" : ").append(t.getMessage()).append("\n");
            return sb.toString();
        }
        catch (Exception e) {
            return "??? : " + e.toString();
        }
    }

    @Override
    protected void checkAclPermission(Authorizable auth, Object command, String[] acls) throws CommandException {
        String user = auth.getAuthorizedPrincipal();
        if (user.equals("admin") || acls.length == 0) {
            return;
        }
        CommandAclException recentException = null;
        for (String acl : acls) {
            try {
                this.checkAclPermission(user, command, acl);
                return;
            }
            catch (CommandAclException ce) {
                recentException = ce;
            }
        }
        throw recentException;
    }

    protected void checkAclPermission(String user, Object command, String acl) throws CommandException {
        CellMessage reply;
        Object[] request = new Object[]{"request", "<nobody>", "check-permission", user, acl};
        try {
            reply = this._nucleus.sendAndWait(new CellMessage(this._aclPath, (Serializable)request), this._aclTimeout);
            if (reply == null) {
                throw new CommandException("Error in acl handling : Acl Request timed out (" + this._aclPath + ")");
            }
        }
        catch (NoRouteToCellException | SerializationException | InterruptedException ee) {
            throw new CommandException("Error in acl handling : " + ee.getMessage());
        }
        Serializable r = reply.getMessageObject();
        if (r == null || !(r instanceof Object[]) || ((Object[])r).length < 6 || !(((Object[])r)[5] instanceof Boolean)) {
            throw new CommandException("Error in acl handling : illegal reply arrived");
        }
        if (!((Boolean)((Object[])r)[5]).booleanValue()) {
            throw new CommandAclException(user, acl);
        }
    }
}

