/*
 * Decompiled with CFR 0.152.
 */
package dmg.cells.nucleus;

import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellNucleus;
import dmg.cells.nucleus.HasDiagnosticContext;
import dmg.util.TimebasedCounter;
import java.io.Serializable;
import org.dcache.commons.util.NDC;
import org.slf4j.MDC;

public class CDC
implements AutoCloseable {
    public static final String MDC_DOMAIN = "cells.domain";
    public static final String MDC_CELL = "cells.cell";
    public static final String MDC_SESSION = "cells.session";
    private static final TimebasedCounter _sessionCounter = new TimebasedCounter();
    private final NDC _ndc;
    private final String _session = MDC.get((String)"cells.session");
    private final String _cell = MDC.get((String)"cells.cell");
    private final String _domain = MDC.get((String)"cells.domain");

    public CDC() {
        this._ndc = NDC.cloneNdc();
    }

    private static void setMdc(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    private void apply() {
        CDC.setMdc(MDC_DOMAIN, this._domain);
        CDC.setMdc(MDC_CELL, this._cell);
        CDC.setMdc(MDC_SESSION, this._session);
        if (this._ndc == null) {
            NDC.clear();
        } else {
            NDC.set((NDC)this._ndc);
        }
    }

    @Override
    public void close() {
        this.apply();
    }

    public CDC restore() {
        CDC cdc = new CDC();
        this.apply();
        return cdc;
    }

    public static String getCellName() {
        return MDC.get((String)MDC_CELL);
    }

    public static String getDomainName() {
        return MDC.get((String)MDC_DOMAIN);
    }

    public static String getSession() {
        return MDC.get((String)MDC_SESSION);
    }

    public static void setSession(String session) {
        CDC.setMdc(MDC_SESSION, session);
    }

    public static void createSession(String prefix) {
        CDC.setSession(prefix + _sessionCounter.next());
    }

    public static void createSession() {
        String domain = MDC.get((String)MDC_DOMAIN);
        if (domain == null) {
            throw new IllegalStateException("Missing domain name in MDC");
        }
        CDC.createSession(domain.toString() + "-");
    }

    public static CDC reset(CellNucleus cell) {
        return CDC.reset(cell.getCellName(), cell.getCellDomainName());
    }

    public static CDC reset(String cellName, String domainName) {
        CDC cdc = new CDC();
        CDC.setMdc(MDC_CELL, cellName);
        CDC.setMdc(MDC_DOMAIN, domainName);
        MDC.remove((String)MDC_SESSION);
        NDC.clear();
        return cdc;
    }

    protected static String getMessageContext(CellMessage envelope) {
        StringBuilder s = new StringBuilder();
        Serializable session = envelope.getSession();
        if (session != null) {
            s.append(session).append(' ');
        }
        s.append(envelope.getSourcePath().getCellName());
        Serializable msg = envelope.getMessageObject();
        if (msg instanceof HasDiagnosticContext) {
            String context = ((HasDiagnosticContext)((Object)msg)).getDiagnosticContext();
            s.append(' ').append(context);
        }
        return s.toString();
    }

    public static void setMessageContext(CellMessage envelope) {
        Serializable session = envelope.getSession();
        NDC.push((String)CDC.getMessageContext(envelope));
        CDC.setMdc(MDC_SESSION, session == null ? null : session.toString());
    }

    public static void clearMessageContext() {
        MDC.remove((String)MDC_SESSION);
        NDC.pop();
    }

    public static void clear() {
        MDC.remove((String)MDC_DOMAIN);
        MDC.remove((String)MDC_CELL);
        MDC.remove((String)MDC_SESSION);
        NDC.clear();
    }
}

